/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.spark;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.JobCreationException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PhyPlanSetter;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.UDFFinishVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ConstantExpression;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POBroadcastSpark;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPoissonSample;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStore;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.util.PlanHelper;
import org.apache.pig.backend.hadoop.executionengine.spark.JobMetricsListener;
import org.apache.pig.backend.hadoop.executionengine.spark.SparkPigContext;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.FRJoinConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.RDDConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.converter.SkewedJoinConverter;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.NativeSparkOperator;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POJoinGroupSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.operator.POPoissonSampleSpark;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperPlan;
import org.apache.pig.backend.hadoop.executionengine.spark.plan.SparkOperator;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.tools.pigstats.spark.SparkPigStats;
import org.apache.pig.tools.pigstats.spark.SparkStatsUtil;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.rdd.RDD;

public class JobGraphBuilder
extends SparkOpPlanVisitor {
    private static final Log LOG = LogFactory.getLog(JobGraphBuilder.class);
    public static final int NULLPART_JOB_ID = -1;
    private Map<Class<? extends PhysicalOperator>, RDDConverter> convertMap = null;
    private SparkPigStats sparkStats = null;
    private JavaSparkContext sparkContext = null;
    private JobMetricsListener jobMetricsListener = null;
    private String jobGroupID = null;
    private Set<Integer> seenJobIDs = new HashSet<Integer>();
    private SparkOperPlan sparkPlan = null;
    private Map<OperatorKey, RDD<Tuple>> sparkOpRdds = new HashMap<OperatorKey, RDD<Tuple>>();
    private Map<OperatorKey, RDD<Tuple>> physicalOpRdds = new HashMap<OperatorKey, RDD<Tuple>>();
    private JobConf jobConf = null;
    private PigContext pc;

    public JobGraphBuilder(SparkOperPlan plan, Map<Class<? extends PhysicalOperator>, RDDConverter> convertMap, SparkPigStats sparkStats, JavaSparkContext sparkContext, JobMetricsListener jobMetricsListener, String jobGroupID, JobConf jobConf, PigContext pc) {
        super(plan, (PlanWalker<SparkOperator, SparkOperPlan>)new DependencyOrderWalker<SparkOperator, SparkOperPlan>(plan, true));
        this.sparkPlan = plan;
        this.convertMap = convertMap;
        this.sparkStats = sparkStats;
        this.sparkContext = sparkContext;
        this.jobMetricsListener = jobMetricsListener;
        this.jobGroupID = jobGroupID;
        this.jobConf = jobConf;
        this.pc = pc;
    }

    @Override
    public void visitSparkOp(SparkOperator sparkOp) throws VisitorException {
        new PhyPlanSetter(sparkOp.physicalPlan).visit();
        try {
            this.setReplicationForMergeJoin(sparkOp.physicalPlan);
            this.sparkOperToRDD(sparkOp);
            this.finishUDFs(sparkOp.physicalPlan);
        }
        catch (Exception e) {
            throw new VisitorException("fail to get the rdds of this spark operator: ", e);
        }
    }

    private void setReplicationForMergeJoin(PhysicalPlan plan) throws IOException {
        ArrayList<Path> filesForMoreReplication = new ArrayList<Path>();
        LinkedList<POMergeJoin> poMergeJoins = PlanHelper.getPhysicalOperators(plan, POMergeJoin.class);
        if (poMergeJoins.size() > 0) {
            for (POMergeJoin poMergeJoin : poMergeJoins) {
                String idxFileName = poMergeJoin.getIndexFile();
                if (idxFileName != null) {
                    filesForMoreReplication.add(new Path(idxFileName));
                }
                poMergeJoin.setIndexFile(null);
            }
        }
        this.setReplicationForFiles(filesForMoreReplication);
    }

    private void setReplicationForFiles(List<Path> files) throws IOException {
        FileSystem fs = FileSystem.get((Configuration)this.jobConf);
        short replication = (short)this.jobConf.getInt("mapred.submit.replication", 10);
        for (int i = 0; i < files.size(); ++i) {
            fs.setReplication(files.get(i), replication);
        }
    }

    private void finishUDFs(PhysicalPlan physicalPlan) throws VisitorException {
        UDFFinishVisitor finisher = new UDFFinishVisitor(physicalPlan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DependencyOrderWalker<PhysicalOperator, PhysicalPlan>(physicalPlan));
        try {
            finisher.visit();
        }
        catch (VisitorException e) {
            int errCode = 2121;
            String msg = "Error while calling finish method on UDFs.";
            throw new VisitorException(msg, errCode, 4, (Throwable)e);
        }
    }

    private void sparkOperToRDD(SparkOperator sparkOperator) throws InterruptedException, VisitorException, JobCreationException, ExecException {
        block13: {
            Exception exception;
            boolean isFail;
            HashSet<OperatorKey> predecessorOfPreviousSparkOp;
            block12: {
                List<SparkOperator> predecessors = this.sparkPlan.getPredecessors(sparkOperator);
                predecessorOfPreviousSparkOp = new HashSet<OperatorKey>();
                if (predecessors != null) {
                    for (SparkOperator pred : predecessors) {
                        predecessorOfPreviousSparkOp.add(pred.getOperatorKey());
                    }
                }
                isFail = false;
                exception = null;
                if (!(sparkOperator instanceof NativeSparkOperator)) break block12;
                ((NativeSparkOperator)sparkOperator).runJob();
                break block13;
            }
            List leafPOs = sparkOperator.physicalPlan.getLeaves();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("sparkOperator.physicalPlan have " + sparkOperator.physicalPlan.getLeaves().size() + " leaves"));
            }
            for (PhysicalOperator leafPO : leafPOs) {
                try {
                    this.physicalToRDD(sparkOperator, sparkOperator.physicalPlan, leafPO, predecessorOfPreviousSparkOp);
                    this.sparkOpRdds.put(sparkOperator.getOperatorKey(), this.physicalOpRdds.get(leafPO.getOperatorKey()));
                }
                catch (Exception e) {
                    LOG.error((Object)"throw exception in sparkOperToRDD: ", (Throwable)e);
                    exception = e;
                    isFail = true;
                    boolean stopOnFailure = Boolean.valueOf(this.pc.getProperties().getProperty("stop.on.failure", "false"));
                    if (!stopOnFailure) continue;
                    int errCode = 6017;
                    throw new ExecException(e.getMessage(), errCode, 16);
                }
            }
            LinkedList<POStore> poStores = PlanHelper.getPhysicalOperators(sparkOperator.physicalPlan, POStore.class);
            Collections.sort(poStores);
            if (poStores.size() <= 0) break block13;
            int i = 0;
            if (!isFail) {
                List<Integer> jobIDs = this.getJobIDs(this.seenJobIDs);
                for (POStore poStore : poStores) {
                    if (jobIDs.size() == 0) {
                        if (this.physicalOpRdds.get(poStore.getOperatorKey()).partitions().length == 0) {
                            this.sparkStats.addJobStats(poStore, sparkOperator, -1, null, this.sparkContext);
                            return;
                        }
                        throw new RuntimeException("Expected at least one unseen jobID  in this call to getJobIdsForGroup, but got 0");
                    }
                    SparkStatsUtil.waitForJobAddStats(jobIDs.get(i++), poStore, sparkOperator, this.jobMetricsListener, this.sparkContext, this.sparkStats);
                }
            } else {
                for (POStore poStore : poStores) {
                    String failJobID = sparkOperator.name().concat("_fail");
                    SparkStatsUtil.addFailJobStats(failJobID, poStore, sparkOperator, this.sparkStats, exception);
                }
            }
        }
    }

    private void physicalToRDD(SparkOperator sparkOperator, PhysicalPlan plan, PhysicalOperator physicalOperator, Set<OperatorKey> predsFromPreviousSparkOper) throws IOException {
        RDD nextRDD = null;
        List<PhysicalOperator> predecessorsOfCurrentPhysicalOp = this.getPredecessors(plan, physicalOperator);
        LinkedHashSet<OperatorKey> operatorKeysOfAllPreds = new LinkedHashSet<OperatorKey>();
        this.addPredsFromPrevoiousSparkOp(sparkOperator, physicalOperator, operatorKeysOfAllPreds);
        if (predecessorsOfCurrentPhysicalOp != null) {
            for (PhysicalOperator physicalOperator2 : predecessorsOfCurrentPhysicalOp) {
                this.physicalToRDD(sparkOperator, plan, physicalOperator2, predsFromPreviousSparkOper);
                operatorKeysOfAllPreds.add(physicalOperator2.getOperatorKey());
            }
        } else if (predsFromPreviousSparkOper != null && predsFromPreviousSparkOper.size() > 0) {
            for (OperatorKey operatorKey : predsFromPreviousSparkOper) {
                operatorKeysOfAllPreds.add(operatorKey);
            }
        }
        if (physicalOperator instanceof POSplit) {
            List<PhysicalPlan> successorPlans = ((POSplit)physicalOperator).getPlans();
            for (PhysicalPlan successorPlan : successorPlans) {
                List leavesOfSuccessPlan = successorPlan.getLeaves();
                if (leavesOfSuccessPlan.size() != 1) {
                    throw new RuntimeException("the size of the leaves of successorPlan should be 1");
                }
                PhysicalOperator leafOfSuccessPlan = (PhysicalOperator)leavesOfSuccessPlan.get(0);
                this.physicalToRDD(sparkOperator, successorPlan, leafOfSuccessPlan, operatorKeysOfAllPreds);
            }
        } else {
            RDDConverter converter = this.convertMap.get(physicalOperator.getClass());
            if (converter == null) {
                throw new IllegalArgumentException("Pig on Spark does not support Physical Operator: " + physicalOperator);
            }
            LOG.info((Object)("Converting operator " + physicalOperator.getClass().getSimpleName() + " " + physicalOperator));
            List list = this.sortPredecessorRDDs(operatorKeysOfAllPreds);
            if (converter instanceof FRJoinConverter) {
                this.setReplicatedInputs(physicalOperator, (FRJoinConverter)converter);
            }
            if (sparkOperator.isSkewedJoin() && converter instanceof SkewedJoinConverter) {
                SkewedJoinConverter skewedJoinConverter = (SkewedJoinConverter)converter;
                skewedJoinConverter.setSkewedJoinPartitionFile(sparkOperator.getSkewedJoinPartitionFile());
            }
            this.adjustRuntimeParallelismForSkewedJoin(physicalOperator, sparkOperator, list);
            nextRDD = converter.convert(list, physicalOperator);
            if (nextRDD == null) {
                throw new IllegalArgumentException("RDD should not be null after PhysicalOperator: " + physicalOperator);
            }
            this.physicalOpRdds.put(physicalOperator.getOperatorKey(), nextRDD);
        }
    }

    private void setReplicatedInputs(PhysicalOperator physicalOperator, FRJoinConverter converter) {
        HashSet<String> replicatedInputs = new HashSet<String>();
        for (PhysicalOperator operator : physicalOperator.getInputs()) {
            if (!(operator instanceof POBroadcastSpark)) continue;
            replicatedInputs.add(((POBroadcastSpark)operator).getBroadcastedVariableName());
        }
        converter.setReplicatedInputs(replicatedInputs);
    }

    private List<PhysicalOperator> getPredecessors(PhysicalPlan plan, PhysicalOperator op) {
        List<PhysicalOperator> preds = null;
        if (!(op instanceof POJoinGroupSpark)) {
            preds = plan.getPredecessors(op);
            if (preds != null && preds.size() > 1 && !(op instanceof POSkewedJoin)) {
                Collections.sort(preds);
            }
        } else {
            preds = ((POJoinGroupSpark)op).getPredecessors();
        }
        return preds;
    }

    private List<RDD<Tuple>> sortPredecessorRDDs(LinkedHashSet<OperatorKey> operatorKeysOfAllPreds) {
        ArrayList predecessorRDDs = Lists.newArrayList();
        for (OperatorKey operatorKeyOfAllPred : operatorKeysOfAllPreds) {
            predecessorRDDs.add(this.physicalOpRdds.get(operatorKeyOfAllPred));
        }
        return predecessorRDDs;
    }

    private void addPredsFromPrevoiousSparkOp(SparkOperator sparkOperator, PhysicalOperator physicalOperator, Set<OperatorKey> operatorKeysOfPredecessors) {
        List<OperatorKey> predOperatorKeys = sparkOperator.getMultiQueryOptimizeConnectionItem().get(physicalOperator.getOperatorKey());
        if (predOperatorKeys != null) {
            for (OperatorKey predOperator : predOperatorKeys) {
                LOG.debug((Object)String.format("add predecessor(OperatorKey:%s) for OperatorKey:%s", predOperator, physicalOperator.getOperatorKey()));
                operatorKeysOfPredecessors.add(predOperator);
            }
        }
    }

    private List<Integer> getJobIDs(Set<Integer> seenJobIDs) {
        HashSet<Integer> groupjobIDs = new HashSet<Integer>(Arrays.asList(ArrayUtils.toObject((int[])this.sparkContext.statusTracker().getJobIdsForGroup(this.jobGroupID))));
        groupjobIDs.removeAll(seenJobIDs);
        ArrayList<Integer> unseenJobIDs = new ArrayList<Integer>(groupjobIDs);
        seenJobIDs.addAll(unseenJobIDs);
        return unseenJobIDs;
    }

    private void adjustRuntimeParallelismForSkewedJoin(PhysicalOperator physicalOperator, SparkOperator sparkOperator, List<RDD<Tuple>> allPredRDDs) throws VisitorException {
        if (sparkOperator.isSampler() && this.sparkPlan.getSuccessors(sparkOperator) != null && physicalOperator instanceof POPoissonSampleSpark) {
            SparkPigContext.get();
            int defaultParallelism = SparkPigContext.getParallelism(allPredRDDs, physicalOperator);
            ParallelConstantVisitor visitor = new ParallelConstantVisitor(sparkOperator.physicalPlan, defaultParallelism);
            visitor.visit();
        }
    }

    private static class ParallelConstantVisitor
    extends PhyPlanVisitor {
        private int rp;
        private boolean replaced = false;
        private boolean isAfterSampleOperator = false;

        public ParallelConstantVisitor(PhysicalPlan plan, int rp) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.rp = rp;
        }

        @Override
        public void visitConstant(ConstantExpression cnst) throws VisitorException {
            Object obj;
            if (this.isAfterSampleOperator && cnst.getRequestedParallelism() == -1 && (obj = cnst.getValue()) instanceof Integer) {
                if (this.replaced) {
                    throw new VisitorException("Invalid reduce plan: more than one ConstantExpression found in sampling job");
                }
                cnst.setValue(this.rp);
                cnst.setRequestedParallelism(this.rp);
                this.replaced = true;
            }
        }

        @Override
        public void visitPoissonSample(POPoissonSample po) {
            this.isAfterSampleOperator = true;
        }
    }
}

