/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.tools.pigstats;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.util.VersionInfo;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PhysicalOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhysicalPlan;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POCollectedGroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODemux;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.PODistinct;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFRJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POFilter;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POForEach;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLimit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLoad;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POLocalRearrange;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeCogroup;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POMergeJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POPartialAgg;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSkewedJoin;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSort;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POSplit;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POStream;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.relationalOperators.POUnion;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.plan.DepthFirstWalker;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.JarManager;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.newplan.logical.relational.LOCogroup;
import org.apache.pig.newplan.logical.relational.LOCross;
import org.apache.pig.newplan.logical.relational.LODistinct;
import org.apache.pig.newplan.logical.relational.LOFilter;
import org.apache.pig.newplan.logical.relational.LOForEach;
import org.apache.pig.newplan.logical.relational.LOJoin;
import org.apache.pig.newplan.logical.relational.LOLimit;
import org.apache.pig.newplan.logical.relational.LONative;
import org.apache.pig.newplan.logical.relational.LORank;
import org.apache.pig.newplan.logical.relational.LOSort;
import org.apache.pig.newplan.logical.relational.LOSplit;
import org.apache.pig.newplan.logical.relational.LOStream;
import org.apache.pig.newplan.logical.relational.LOUnion;
import org.apache.pig.newplan.logical.relational.LogicalPlan;
import org.apache.pig.newplan.logical.relational.LogicalRelationalNodesVisitor;
import org.apache.pig.tools.pigstats.JobStats;
import org.apache.pig.tools.pigstats.OutputStats;
import org.apache.pig.tools.pigstats.PigProgressNotificationListener;
import org.apache.pig.tools.pigstats.mapreduce.MRScriptState;

public abstract class ScriptState {
    private static final Log LOG = LogFactory.getLog(ScriptState.class);
    private static InheritableThreadLocal<ScriptState> tss = new InheritableThreadLocal();
    protected String id;
    protected String serializedScript;
    protected String truncatedScript;
    protected String commandLine;
    protected String fileName;
    protected String pigVersion;
    protected String hadoopVersion;
    protected long scriptFeatures;
    protected PigContext pigContext;
    protected List<PigProgressNotificationListener> listeners = Lists.newArrayList();

    protected ScriptState(String id) {
        this.id = id;
        this.serializedScript = "";
        this.truncatedScript = "";
    }

    public static ScriptState get() {
        return (ScriptState)tss.get();
    }

    public static ScriptState start(ScriptState state) {
        tss.set(state);
        return (ScriptState)tss.get();
    }

    @Deprecated
    public static ScriptState start(String commandLine, PigContext pigContext) {
        MRScriptState ss = new MRScriptState(UUID.randomUUID().toString());
        ss.setCommandLine(commandLine);
        ss.setPigContext(pigContext);
        tss.set(ss);
        return ss;
    }

    public void registerListener(PigProgressNotificationListener listener) {
        this.listeners.add(listener);
    }

    public List<PigProgressNotificationListener> getAllListeners() {
        return this.listeners;
    }

    public void emitInitialPlanNotification(OperatorPlan<?> plan) {
        for (PigProgressNotificationListener listener : this.listeners) {
            try {
                listener.initialPlanNotification(this.id, plan);
            }
            catch (NoSuchMethodError e) {
                LOG.warn((Object)("PigProgressNotificationListener implementation doesn't implement initialPlanNotification(..) method: " + listener.getClass().getName()), (Throwable)e);
            }
        }
    }

    public void emitLaunchStartedNotification(int numJobsToLaunch) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.launchStartedNotification(this.id, numJobsToLaunch);
        }
    }

    public void emitJobsSubmittedNotification(int numJobsSubmitted) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobsSubmittedNotification(this.id, numJobsSubmitted);
        }
    }

    public void emitJobStartedNotification(String assignedJobId) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobStartedNotification(this.id, assignedJobId);
        }
    }

    public void emitjobFinishedNotification(JobStats jobStats) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobFinishedNotification(this.id, jobStats);
        }
    }

    public void emitJobFailedNotification(JobStats jobStats) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.jobFailedNotification(this.id, jobStats);
        }
    }

    public void emitOutputCompletedNotification(OutputStats outputStats) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.outputCompletedNotification(this.id, outputStats);
        }
    }

    public void emitProgressUpdatedNotification(int progress) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.progressUpdatedNotification(this.id, progress);
        }
    }

    public void emitLaunchCompletedNotification(int numJobsSucceeded) {
        for (PigProgressNotificationListener listener : this.listeners) {
            listener.launchCompletedNotification(this.id, numJobsSucceeded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScript(File file) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            this.setScript(reader);
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)"unable to find the file", (Throwable)e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setScript(String script) throws IOException {
        if (script == null) {
            return;
        }
        this.setTruncatedScript(script);
        this.serializedScript = ObjectSerializer.serialize((Serializable)((Object)script));
    }

    private void setTruncatedScript(String script) {
        String prop;
        int maxScriptSize = 10240;
        if (this.pigContext != null && (prop = this.pigContext.getProperties().getProperty("pig.script.max.size")) != null) {
            maxScriptSize = Integer.valueOf(prop);
        }
        this.truncatedScript = script.length() > maxScriptSize ? script.substring(0, maxScriptSize) : script;
    }

    public void setScriptFeatures(LogicalPlan plan) {
        BitSet bs = new BitSet();
        try {
            new LogicalPlanFeatureVisitor(plan, bs).visit();
        }
        catch (FrontendException e) {
            LOG.warn((Object)"unable to get script feature", (Throwable)e);
        }
        this.scriptFeatures = this.bitSetToLong(bs);
        LOG.info((Object)("Pig features used in the script: " + this.featureLongToString(this.scriptFeatures)));
    }

    public String getHadoopVersion() {
        if (this.hadoopVersion == null) {
            this.hadoopVersion = VersionInfo.getVersion();
        }
        return this.hadoopVersion == null ? "" : this.hadoopVersion;
    }

    public String getPigVersion() {
        if (this.pigVersion == null) {
            String findContainingJar = JarManager.findContainingJar(ScriptState.class);
            if (findContainingJar != null) {
                try {
                    JarFile jar = new JarFile(findContainingJar);
                    Manifest manifest = jar.getManifest();
                    Map<String, Attributes> attrs = manifest.getEntries();
                    Attributes attr = attrs.get("org/apache/pig");
                    this.pigVersion = attr.getValue("Implementation-Version");
                }
                catch (Exception e) {
                    LOG.warn((Object)"unable to read pigs manifest file");
                }
            } else {
                LOG.warn((Object)"unable to read pigs manifest file. Not running from the Pig jar");
            }
        }
        return this.pigVersion == null ? "" : this.pigVersion;
    }

    public String getFileName() {
        return this.fileName == null ? "" : this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getId() {
        return this.id;
    }

    public void setCommandLine(String commandLine) {
        this.commandLine = new String(Base64.encodeBase64((byte[])commandLine.getBytes()));
    }

    public String getCommandLine() {
        return this.commandLine == null ? "" : this.commandLine;
    }

    public String getSerializedScript() {
        return this.serializedScript == null ? "" : this.serializedScript;
    }

    public String getScript() {
        return this.truncatedScript == null ? "" : this.truncatedScript;
    }

    protected void setScript(BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append("\n");
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"unable to parse the script", (Throwable)e);
        }
        this.setScript(sb.toString());
    }

    protected long bitSetToLong(BitSet bs) {
        long ret = 0L;
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            ret |= 1L << i;
            i = bs.nextSetBit(i + 1);
        }
        return ret;
    }

    protected String featureLongToString(long l) {
        if (l == 0L) {
            return PIG_FEATURE.UNKNOWN.name();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < PIG_FEATURE.values().length; ++i) {
            if ((l >> i & 1L) == 0L) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(PIG_FEATURE.values()[i].name());
        }
        return sb.toString();
    }

    public void setPigContext(PigContext pigContext) {
        this.pigContext = pigContext;
    }

    public PigContext getPigContext() {
        return this.pigContext;
    }

    public String getScriptFeatures() {
        return this.featureLongToString(this.scriptFeatures);
    }

    protected static class AliasVisitor
    extends PhyPlanVisitor {
        private HashSet<String> aliasSet;
        private List<String> alias;
        private final List<String> aliasLocation;

        public AliasVisitor(PhysicalPlan plan, List<String> alias, List<String> aliasLocation) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.alias = alias;
            this.aliasLocation = aliasLocation;
            this.aliasSet = new HashSet();
            if (!alias.isEmpty()) {
                for (String s : alias) {
                    this.aliasSet.add(s);
                }
            }
        }

        @Override
        public void visitLoad(POLoad load) throws VisitorException {
            this.setAlias(load);
            super.visitLoad(load);
        }

        @Override
        public void visitFRJoin(POFRJoin join) throws VisitorException {
            this.setAlias(join);
            super.visitFRJoin(join);
        }

        @Override
        public void visitMergeJoin(POMergeJoin join) throws VisitorException {
            this.setAlias(join);
            super.visitMergeJoin(join);
        }

        @Override
        public void visitMergeCoGroup(POMergeCogroup mergeCoGrp) throws VisitorException {
            this.setAlias(mergeCoGrp);
            super.visitMergeCoGroup(mergeCoGrp);
        }

        @Override
        public void visitCollectedGroup(POCollectedGroup mg) throws VisitorException {
            this.setAlias(mg);
            super.visitCollectedGroup(mg);
        }

        @Override
        public void visitDistinct(PODistinct distinct) throws VisitorException {
            this.setAlias(distinct);
            super.visitDistinct(distinct);
        }

        @Override
        public void visitStream(POStream stream) throws VisitorException {
            this.setAlias(stream);
            super.visitStream(stream);
        }

        @Override
        public void visitFilter(POFilter fl) throws VisitorException {
            this.setAlias(fl);
            super.visitFilter(fl);
        }

        @Override
        public void visitLocalRearrange(POLocalRearrange lr) throws VisitorException {
            this.setAlias(lr);
            super.visitLocalRearrange(lr);
        }

        @Override
        public void visitPOForEach(POForEach nfe) throws VisitorException {
            this.setAlias(nfe);
            super.visitPOForEach(nfe);
        }

        @Override
        public void visitUnion(POUnion un) throws VisitorException {
            this.setAlias(un);
            super.visitUnion(un);
        }

        @Override
        public void visitSort(POSort sort) throws VisitorException {
            this.setAlias(sort);
            super.visitSort(sort);
        }

        @Override
        public void visitLimit(POLimit lim) throws VisitorException {
            this.setAlias(lim);
            super.visitLimit(lim);
        }

        @Override
        public void visitSkewedJoin(POSkewedJoin sk) throws VisitorException {
            this.setAlias(sk);
            super.visitSkewedJoin(sk);
        }

        private void setAlias(PhysicalOperator op) {
            String s = op.getAlias();
            if (s != null && !this.aliasSet.contains(s)) {
                this.alias.add(s);
                this.aliasSet.add(s);
            }
            List<PhysicalOperator.OriginalLocation> originalLocations = op.getOriginalLocations();
            for (PhysicalOperator.OriginalLocation originalLocation : originalLocations) {
                this.aliasLocation.add(originalLocation.toString());
            }
        }
    }

    protected static class FeatureVisitor
    extends PhyPlanVisitor {
        private BitSet feature;

        public FeatureVisitor(PhysicalPlan plan, BitSet feature) {
            super(plan, (PlanWalker<PhysicalOperator, PhysicalPlan>)new DepthFirstWalker<PhysicalOperator, PhysicalPlan>(plan));
            this.feature = feature;
        }

        @Override
        public void visitFRJoin(POFRJoin join) throws VisitorException {
            this.feature.set(PIG_FEATURE.REPLICATED_JOIN.ordinal());
        }

        @Override
        public void visitMergeJoin(POMergeJoin join) throws VisitorException {
            if (join.getJoinType() == LOJoin.JOINTYPE.MERGESPARSE) {
                this.feature.set(PIG_FEATURE.MERGE_SPARSE_JOIN.ordinal());
            } else {
                this.feature.set(PIG_FEATURE.MERGE_JOIN.ordinal());
            }
        }

        @Override
        public void visitMergeCoGroup(POMergeCogroup mergeCoGrp) throws VisitorException {
            this.feature.set(PIG_FEATURE.MERGE_COGROUP.ordinal());
        }

        @Override
        public void visitCollectedGroup(POCollectedGroup mg) throws VisitorException {
            this.feature.set(PIG_FEATURE.COLLECTED_GROUP.ordinal());
        }

        @Override
        public void visitDistinct(PODistinct distinct) throws VisitorException {
            this.feature.set(PIG_FEATURE.DISTINCT.ordinal());
        }

        @Override
        public void visitStream(POStream stream) throws VisitorException {
            this.feature.set(PIG_FEATURE.STREAMING.ordinal());
        }

        @Override
        public void visitSplit(POSplit split) throws VisitorException {
            this.feature.set(PIG_FEATURE.MULTI_QUERY.ordinal());
        }

        @Override
        public void visitDemux(PODemux demux) throws VisitorException {
            this.feature.set(PIG_FEATURE.MULTI_QUERY.ordinal());
        }

        @Override
        public void visitPartialAgg(POPartialAgg partAgg) {
            this.feature.set(PIG_FEATURE.MAP_PARTIALAGG.ordinal());
        }
    }

    static class LogicalPlanFeatureVisitor
    extends LogicalRelationalNodesVisitor {
        private BitSet feature;

        protected LogicalPlanFeatureVisitor(LogicalPlan plan, BitSet feature) throws FrontendException {
            super(plan, new org.apache.pig.newplan.DepthFirstWalker(plan));
            this.feature = feature;
        }

        @Override
        public void visit(LOCogroup op) {
            if (op.getGroupType() == LOCogroup.GROUPTYPE.COLLECTED) {
                this.feature.set(PIG_FEATURE.COLLECTED_GROUP.ordinal());
            } else if (op.getGroupType() == LOCogroup.GROUPTYPE.MERGE) {
                this.feature.set(PIG_FEATURE.MERGE_COGROUP.ordinal());
            } else if (op.getGroupType() == LOCogroup.GROUPTYPE.REGULAR) {
                if (op.getExpressionPlans().size() > 1) {
                    this.feature.set(PIG_FEATURE.COGROUP.ordinal());
                } else {
                    this.feature.set(PIG_FEATURE.GROUP_BY.ordinal());
                }
            }
        }

        @Override
        public void visit(LOCross op) {
            this.feature.set(PIG_FEATURE.CROSS.ordinal());
        }

        @Override
        public void visit(LODistinct op) {
            this.feature.set(PIG_FEATURE.DISTINCT.ordinal());
        }

        @Override
        public void visit(LOFilter op) {
            this.feature.set(PIG_FEATURE.FILTER.ordinal());
        }

        @Override
        public void visit(LOForEach op) {
        }

        @Override
        public void visit(LOJoin op) {
            if (op.getJoinType() == LOJoin.JOINTYPE.HASH) {
                this.feature.set(PIG_FEATURE.HASH_JOIN.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.BLOOM) {
                this.feature.set(PIG_FEATURE.HASH_JOIN.ordinal());
                this.feature.set(PIG_FEATURE.BUILD_BLOOM.ordinal());
                this.feature.set(PIG_FEATURE.FILTER_BLOOM.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.MERGE) {
                this.feature.set(PIG_FEATURE.MERGE_JOIN.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.MERGESPARSE) {
                this.feature.set(PIG_FEATURE.MERGE_SPARSE_JOIN.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.REPLICATED) {
                this.feature.set(PIG_FEATURE.REPLICATED_JOIN.ordinal());
            } else if (op.getJoinType() == LOJoin.JOINTYPE.SKEWED) {
                this.feature.set(PIG_FEATURE.SKEWED_JOIN.ordinal());
            }
        }

        @Override
        public void visit(LOLimit op) {
            this.feature.set(PIG_FEATURE.LIMIT.ordinal());
        }

        @Override
        public void visit(LORank op) {
            this.feature.set(PIG_FEATURE.RANK.ordinal());
        }

        @Override
        public void visit(LOSort op) {
            this.feature.set(PIG_FEATURE.ORDER_BY.ordinal());
        }

        @Override
        public void visit(LOStream op) {
            this.feature.set(PIG_FEATURE.STREAMING.ordinal());
        }

        @Override
        public void visit(LOSplit op) {
        }

        @Override
        public void visit(LOUnion op) {
            this.feature.set(PIG_FEATURE.UNION.ordinal());
        }

        @Override
        public void visit(LONative n) {
            this.feature.set(PIG_FEATURE.NATIVE.ordinal());
        }
    }

    public static enum PIG_FEATURE {
        UNKNOWN,
        MERGE_JOIN,
        MERGE_SPARSE_JOIN,
        REPLICATED_JOIN,
        SKEWED_JOIN,
        BUILD_BLOOM,
        FILTER_BLOOM,
        HASH_JOIN,
        COLLECTED_GROUP,
        MERGE_COGROUP,
        COGROUP,
        GROUP_BY,
        ORDER_BY,
        RANK,
        DISTINCT,
        STREAMING,
        SAMPLER,
        INDEXER,
        MULTI_QUERY,
        FILTER,
        MAP_ONLY,
        CROSS,
        LIMIT,
        UNION,
        COMBINER,
        NATIVE,
        MAP_PARTIALAGG;

    }

    protected static enum PIG_PROPERTY {
        SCRIPT_ID("pig.script.id"),
        SCRIPT("pig.script"),
        COMMAND_LINE("pig.command.line"),
        HADOOP_VERSION("pig.hadoop.version"),
        VERSION("pig.version"),
        INPUT_DIRS("pig.input.dirs"),
        MAP_OUTPUT_DIRS("pig.map.output.dirs"),
        REDUCE_OUTPUT_DIRS("pig.reduce.output.dirs"),
        JOB_PARENTS("pig.parent.jobid"),
        JOB_FEATURE("pig.job.feature"),
        SCRIPT_FEATURES("pig.script.features"),
        JOB_ALIAS("pig.alias"),
        JOB_ALIAS_LOCATION("pig.alias.location");

        private String displayStr;

        private PIG_PROPERTY(String s) {
            this.displayStr = s;
        }

        public String toString() {
            return this.displayStr;
        }
    }
}

