/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPInputStream;
import org.apache.calcite.util.Source;

public abstract class Sources {
    private Sources() {
    }

    public static Source of(File file) {
        return new MySource(file);
    }

    public static Source file(File baseDirectory, String fileName) {
        File file = new File(fileName);
        if (baseDirectory != null && !file.isAbsolute()) {
            return Sources.of(new File(baseDirectory, fileName));
        }
        return Sources.of(file);
    }

    public static Source url(String url) {
        try {
            URL url_ = new URL(url);
            return new MySource(url_);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Malformed URL: '" + url + "'", e);
        }
    }

    private static String trimOrNull(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : null;
    }

    private static boolean isFile(Source source) {
        return source.protocol().equals("file");
    }

    private static class MySource
    implements Source {
        private final File file;
        private final URL url;

        private MySource(URL url) {
            this.url = (URL)Preconditions.checkNotNull((Object)url);
            this.file = url.getProtocol().equals("file") ? new File(url.getFile()) : null;
        }

        private MySource(File file) {
            this.file = (File)Preconditions.checkNotNull((Object)file);
            this.url = null;
        }

        public String toString() {
            return (this.url != null ? this.url : this.file).toString();
        }

        @Override
        public URL url() {
            if (this.url == null) {
                throw new UnsupportedOperationException();
            }
            return this.url;
        }

        @Override
        public File file() {
            if (this.file == null) {
                throw new UnsupportedOperationException();
            }
            return this.file;
        }

        @Override
        public String protocol() {
            return this.file != null ? "file" : this.url.getProtocol();
        }

        @Override
        public String path() {
            return this.file != null ? this.file.getPath() : this.url.toExternalForm();
        }

        @Override
        public Reader reader() throws IOException {
            InputStream is;
            if (this.path().endsWith(".gz")) {
                InputStream fis = this.openStream();
                is = new GZIPInputStream(fis);
            } else {
                is = this.openStream();
            }
            return new InputStreamReader(is, StandardCharsets.UTF_8);
        }

        @Override
        public InputStream openStream() throws IOException {
            if (this.file != null) {
                return new FileInputStream(this.file);
            }
            return this.url.openStream();
        }

        @Override
        public Source trim(String suffix) {
            Source x = this.trimOrNull(suffix);
            return x == null ? this : x;
        }

        @Override
        public Source trimOrNull(String suffix) {
            if (this.url != null) {
                String s = Sources.trimOrNull(this.url.toExternalForm(), suffix);
                return s == null ? null : Sources.url(s);
            }
            String s = Sources.trimOrNull(this.file.getPath(), suffix);
            return s == null ? null : Sources.of(new File(s));
        }

        @Override
        public Source append(Source child) {
            String path;
            if (Sources.isFile(child)) {
                path = child.file().getPath();
                if (child.file().isAbsolute()) {
                    return child;
                }
            } else {
                path = child.url().getPath();
                if (path.startsWith("/")) {
                    return child;
                }
            }
            if (this.url != null) {
                return Sources.url(this.url + "/" + path);
            }
            return Sources.file(this.file, path);
        }

        @Override
        public Source relative(Source parent) {
            String rest;
            if (Sources.isFile(parent)) {
                String rest2;
                if (Sources.isFile(this) && this.file.getPath().startsWith(parent.file().getPath()) && (rest2 = this.file.getPath().substring(parent.file().getPath().length())).startsWith(File.separator)) {
                    return Sources.file(null, rest2.substring(File.separator.length()));
                }
                return this;
            }
            if (!Sources.isFile(this) && (rest = Sources.trimOrNull(this.url.toExternalForm(), parent.url().toExternalForm())) != null && rest.startsWith("/")) {
                return Sources.file(null, rest.substring(1));
            }
            return this;
        }
    }
}

