/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColMultiplyDecimalColumn
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum1;
    private final int colNum2;

    public DecimalColMultiplyDecimalColumn(int colNum1, int colNum2, int outputColumnNum) {
        super(outputColumnNum);
        this.colNum1 = colNum1;
        this.colNum2 = colNum2;
    }

    public DecimalColMultiplyDecimalColumn() {
        this.colNum1 = -1;
        this.colNum2 = -1;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        int n = batch.size;
        if (n == 0) {
            return;
        }
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColVector1 = (DecimalColumnVector)batch.cols[this.colNum1];
        DecimalColumnVector inputColVector2 = (DecimalColumnVector)batch.cols[this.colNum2];
        DecimalColumnVector outputColVector = (DecimalColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        HiveDecimalWritable[] vector1 = inputColVector1.vector;
        HiveDecimalWritable[] vector2 = inputColVector2.vector;
        NullUtil.propagateNullsColCol((ColumnVector)inputColVector1, (ColumnVector)inputColVector2, (ColumnVector)outputColVector, sel, n, batch.selectedInUse);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            DecimalUtil.multiplyChecked(0, vector1[0], vector2[0], outputColVector);
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    DecimalUtil.multiplyChecked(i, vector1[0], vector2[i], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.multiplyChecked(i, vector1[0], vector2[i], outputColVector);
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    DecimalUtil.multiplyChecked(i, vector1[i], vector2[0], outputColVector);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    DecimalUtil.multiplyChecked(i, vector1[i], vector2[0], outputColVector);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                DecimalUtil.multiplyChecked(i, vector1[i], vector2[i], outputColVector);
            }
        } else {
            for (int i = 0; i != n; ++i) {
                DecimalUtil.multiplyChecked(i, vector1[i], vector2[i], outputColVector);
            }
        }
        NullUtil.setNullDataEntriesDecimal(outputColVector, batch.selectedInUse, sel, n);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum1) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.getType("decimal"), VectorExpressionDescriptor.ArgumentType.getType("decimal")).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN).build();
    }
}

