/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.common.LogUtils;
import org.apache.hadoop.hive.common.cli.CommonCliOptions;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.TransactionalValidationListener;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.utils.HiveStrictManagedUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.util.UpgradeTool;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveStrictManagedMigration {
    private static final Logger LOG = LoggerFactory.getLogger(HiveStrictManagedMigration.class);
    private RunOptions runOptions;
    private HiveConf conf;
    private HiveMetaStoreClient hms;
    private boolean failedValidationChecks;
    private boolean failuresEncountered;
    private Warehouse wh;
    private Warehouse oldWh;
    private String ownerName;
    private String groupName;
    private FsPermission dirPerms;
    private FsPermission filePerms;
    private boolean createExternalDirsForDbs;
    Path curWhRootPath;
    private HadoopShims.HdfsEncryptionShim encryptionShim;
    private static final Map<String, String> convertToExternalTableProps = new HashMap<String, String>();
    private static final Map<String, String> convertToAcidTableProps = new HashMap<String, String>();
    private static final Map<String, String> convertToMMTableProps = new HashMap<String, String>();
    HiveUpdater hiveUpdater;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        RunOptions runOptions;
        try {
            Options opts = HiveStrictManagedMigration.createOptions();
            CommandLine cli = new GnuParser().parse(opts, args);
            if (cli.hasOption('h')) {
                HelpFormatter formatter = new HelpFormatter();
                formatter.printHelp(HiveStrictManagedMigration.class.getName(), opts);
                return;
            }
            runOptions = HiveStrictManagedMigration.createRunOptions(cli);
        }
        catch (Exception err) {
            throw new Exception("Error processing options", err);
        }
        int rc = 0;
        HiveStrictManagedMigration migration = null;
        try {
            migration = new HiveStrictManagedMigration(runOptions);
            migration.run();
        }
        catch (Exception err) {
            LOG.error("Failed with error", (Throwable)err);
            rc = -1;
        }
        finally {
            if (migration != null) {
                migration.cleanup();
            }
        }
        System.exit(rc);
    }

    static Options createOptions() {
        Options result = new Options();
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dryRun");
        OptionBuilder.withDescription((String)"Show what migration actions would be taken without actually running commands");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dbRegex");
        OptionBuilder.withDescription((String)"Regular expression to match database names on which this tool will be run");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'d'));
        OptionBuilder.withLongOpt((String)"tableRegex");
        OptionBuilder.withDescription((String)"Regular expression to match table names on which this tool will be run");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'t'));
        OptionBuilder.withLongOpt((String)"oldWarehouseRoot");
        OptionBuilder.withDescription((String)"Location of the previous warehouse root");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"migrationOption");
        OptionBuilder.withDescription((String)"Table migration option (automatic|external|managed|validate|none)");
        OptionBuilder.hasArg();
        result.addOption(OptionBuilder.create((char)'m'));
        OptionBuilder.withLongOpt((String)"shouldModifyManagedTableLocation");
        OptionBuilder.withDescription((String)"Whether managed tables should have their data moved from the old warehouse path to the current warehouse path");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"shouldModifyManagedTableOwner");
        OptionBuilder.withDescription((String)"Whether managed tables should have their directory owners changed to the hive user");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"shouldModifyManagedTablePermissions");
        OptionBuilder.withDescription((String)"Whether managed tables should have their directory permissions changed to conform to strict managed tables mode");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"modifyManagedTables");
        OptionBuilder.withDescription((String)"This setting enables the shouldModifyManagedTableLocation, shouldModifyManagedTableOwner, shouldModifyManagedTablePermissions options");
        result.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        result.addOption(OptionBuilder.create((char)'h'));
        return result;
    }

    static RunOptions createRunOptions(CommandLine cli) throws Exception {
        Properties confProps = cli.getOptionProperties("hiveconf");
        for (String propKey : confProps.stringPropertyNames()) {
            LOG.info("Setting {}={}", (Object)propKey, (Object)confProps.getProperty(propKey));
            if (propKey.equalsIgnoreCase("hive.root.logger")) {
                CommonCliOptions.splitAndSetLogger((String)propKey, (Properties)confProps);
                continue;
            }
            System.setProperty(propKey, confProps.getProperty(propKey));
        }
        LogUtils.initHiveLog4j();
        String dbRegex = cli.getOptionValue("dbRegex", ".*");
        String tableRegex = cli.getOptionValue("tableRegex", ".*");
        TableMigrationOption migrationOption = TableMigrationOption.valueOf(cli.getOptionValue("migrationOption", "none").toUpperCase());
        boolean shouldModifyManagedTableLocation = cli.hasOption("shouldModifyManagedTableLocation");
        boolean shouldModifyManagedTableOwner = cli.hasOption("shouldModifyManagedTableOwner");
        boolean shouldModifyManagedTablePermissions = cli.hasOption("shouldModifyManagedTablePermissions");
        if (cli.hasOption("modifyManagedTables")) {
            shouldModifyManagedTableLocation = true;
            shouldModifyManagedTableOwner = true;
            shouldModifyManagedTablePermissions = true;
        }
        String oldWarehouseRoot = cli.getOptionValue("oldWarehouseRoot");
        boolean dryRun = cli.hasOption("dryRun");
        RunOptions runOpts = new RunOptions(dbRegex, tableRegex, oldWarehouseRoot, migrationOption, shouldModifyManagedTableLocation, shouldModifyManagedTableOwner, shouldModifyManagedTablePermissions, dryRun);
        return runOpts;
    }

    HiveStrictManagedMigration(RunOptions runOptions) {
        this.runOptions = runOptions;
        this.conf = new HiveConf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() throws Exception {
        this.wh = new Warehouse((Configuration)this.conf);
        this.checkOldWarehouseRoot();
        this.checkExternalWarehouseDir();
        this.checkOwnerPermsOptions();
        this.hms = new HiveMetaStoreClient((Configuration)this.conf);
        try {
            List databases = this.hms.getAllDatabases();
            LOG.info("Found {} databases", (Object)databases.size());
            for (String dbName : databases) {
                if (!dbName.matches(this.runOptions.dbRegex)) continue;
                try {
                    this.processDatabase(dbName);
                }
                catch (Exception err) {
                    LOG.error("Error processing database " + dbName, (Throwable)err);
                    this.failuresEncountered = true;
                }
            }
            LOG.info("Done processing databases.");
        }
        finally {
            this.hms.close();
        }
        if (this.failuresEncountered) {
            throw new HiveException("One or more failures encountered during processing.");
        }
        if (this.failedValidationChecks) {
            throw new HiveException("One or more tables failed validation checks for strict managed table mode.");
        }
    }

    void checkOldWarehouseRoot() throws IOException, MetaException {
        if (this.runOptions.shouldModifyManagedTableLocation) {
            if (this.runOptions.oldWarehouseRoot == null) {
                LOG.info("oldWarehouseRoot is not specified. Disabling shouldModifyManagedTableLocation");
                this.runOptions.shouldModifyManagedTableLocation = false;
            } else {
                String curWarehouseRoot = HiveConf.getVar((Configuration)this.conf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREWAREHOUSE);
                if (HiveStrictManagedMigration.arePathsEqual((Configuration)this.conf, this.runOptions.oldWarehouseRoot, curWarehouseRoot)) {
                    LOG.info("oldWarehouseRoot is the same as the current warehouse root {}. Disabling shouldModifyManagedTableLocation", (Object)this.runOptions.oldWarehouseRoot);
                    this.runOptions.shouldModifyManagedTableLocation = false;
                } else {
                    Path oldWhRootPath = new Path(this.runOptions.oldWarehouseRoot);
                    this.curWhRootPath = new Path(curWarehouseRoot);
                    FileSystem oldWhRootFs = oldWhRootPath.getFileSystem((Configuration)this.conf);
                    FileSystem curWhRootFs = this.curWhRootPath.getFileSystem((Configuration)this.conf);
                    oldWhRootPath = oldWhRootFs.makeQualified(oldWhRootPath);
                    this.curWhRootPath = curWhRootFs.makeQualified(this.curWhRootPath);
                    if (!FileUtils.equalsFileSystem((FileSystem)oldWhRootFs, (FileSystem)curWhRootFs)) {
                        LOG.info("oldWarehouseRoot {} has a different FS than the current warehouse root {}. Disabling shouldModifyManagedTableLocation", (Object)this.runOptions.oldWarehouseRoot, (Object)curWarehouseRoot);
                        this.runOptions.shouldModifyManagedTableLocation = false;
                    } else if (!HiveStrictManagedMigration.isHdfs(oldWhRootFs)) {
                        LOG.info("Warehouse is using non-HDFS FileSystem {}. Disabling shouldModifyManagedTableLocation", (Object)oldWhRootFs.getUri());
                        this.runOptions.shouldModifyManagedTableLocation = false;
                    } else {
                        this.encryptionShim = ShimLoader.getHadoopShims().createHdfsEncryptionShim(oldWhRootFs, (Configuration)this.conf);
                        if (!HiveStrictManagedMigration.hasEquivalentEncryption(this.encryptionShim, oldWhRootPath, this.curWhRootPath)) {
                            LOG.info("oldWarehouseRoot {} and current warehouse root {} have different encryption zones. Disabling shouldModifyManagedTableLocation", (Object)oldWhRootPath, (Object)this.curWhRootPath);
                            this.runOptions.shouldModifyManagedTableLocation = false;
                        }
                    }
                }
            }
        }
        if (this.runOptions.shouldModifyManagedTableLocation) {
            Configuration oldWhConf = new Configuration((Configuration)this.conf);
            HiveConf.setVar((Configuration)oldWhConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREWAREHOUSE, (String)this.runOptions.oldWarehouseRoot);
            this.oldWh = new Warehouse(oldWhConf);
        }
    }

    void checkOwnerPermsOptions() {
        if (this.runOptions.shouldModifyManagedTableOwner) {
            this.ownerName = this.conf.get("strict.managed.tables.migration.owner", "hive");
            this.groupName = this.conf.get("strict.managed.tables.migration.group", null);
        }
        if (this.runOptions.shouldModifyManagedTablePermissions) {
            String filePermsString;
            String dirPermsString = this.conf.get("strict.managed.tables.migration.dir.permissions", "700");
            if (dirPermsString != null) {
                this.dirPerms = new FsPermission(dirPermsString);
            }
            if ((filePermsString = this.conf.get("strict.managed.tables.migration.file.permissions", "700")) != null) {
                this.filePerms = new FsPermission(filePermsString);
            }
        }
    }

    void checkExternalWarehouseDir() {
        String externalWarehouseDir = this.conf.getVar(HiveConf.ConfVars.HIVE_METASTORE_WAREHOUSE_EXTERNAL);
        if (externalWarehouseDir != null && !externalWarehouseDir.isEmpty()) {
            this.createExternalDirsForDbs = true;
        }
    }

    void processDatabase(String dbName) throws IOException, HiveException, MetaException, TException {
        LOG.info("Processing database {}", (Object)dbName);
        Database dbObj = this.hms.getDatabase(dbName);
        boolean modifyDefaultManagedLocation = this.shouldModifyDatabaseLocation(dbObj);
        if (modifyDefaultManagedLocation) {
            Path newDefaultDbLocation = this.wh.getDefaultDatabasePath(dbName);
            LOG.info("Changing location of database {} to {}", (Object)dbName, (Object)newDefaultDbLocation);
            if (!this.runOptions.dryRun) {
                FileSystem fs = newDefaultDbLocation.getFileSystem((Configuration)this.conf);
                FileUtils.mkdir((FileSystem)fs, (Path)newDefaultDbLocation, (Configuration)this.conf);
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, newDefaultDbLocation, this.ownerName, this.groupName, this.dirPerms, null, this.runOptions.dryRun, false);
                Database modifiedDb = dbObj.deepCopy();
                this.getHiveUpdater().updateDbLocation(modifiedDb, newDefaultDbLocation);
            }
        }
        if (this.createExternalDirsForDbs) {
            this.createExternalDbDir(dbObj);
        }
        List tableNames = this.hms.getTables(dbName, this.runOptions.tableRegex);
        for (String tableName : tableNames) {
            try {
                this.processTable(dbObj, tableName, modifyDefaultManagedLocation);
            }
            catch (Exception err) {
                LOG.error("Error processing table " + HiveStrictManagedMigration.getQualifiedName(dbObj.getName(), tableName), (Throwable)err);
                this.failuresEncountered = true;
            }
        }
    }

    void processTable(Database dbObj, String tableName, boolean modifyDefaultManagedLocation) throws HiveException, IOException, TException {
        String dbName = dbObj.getName();
        LOG.debug("Processing table {}", (Object)HiveStrictManagedMigration.getQualifiedName(dbName, tableName));
        org.apache.hadoop.hive.metastore.api.Table tableObj = this.hms.getTable(dbName, tableName);
        TableType tableType = TableType.valueOf((String)tableObj.getTableType());
        TableMigrationOption migrationOption = this.runOptions.migrationOption;
        if (migrationOption == TableMigrationOption.AUTOMATIC) {
            migrationOption = this.determineMigrationTypeAutomatically(tableObj, tableType);
        }
        switch (migrationOption) {
            case EXTERNAL: {
                boolean tableMigrated = this.migrateToExternalTable(tableObj, tableType);
                if (!tableMigrated) break;
                tableType = TableType.EXTERNAL_TABLE;
                break;
            }
            case MANAGED: {
                boolean tableMigrated = this.migrateToManagedTable(tableObj, tableType);
                if (!tableMigrated) break;
                tableType = TableType.MANAGED_TABLE;
                break;
            }
            case NONE: {
                break;
            }
            case VALIDATE: {
                String reason = HiveStrictManagedUtils.validateStrictManagedTable((Configuration)this.conf, (org.apache.hadoop.hive.metastore.api.Table)tableObj);
                if (reason == null) break;
                LOG.warn(reason);
                this.failedValidationChecks = true;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected table migration option " + (Object)((Object)this.runOptions.migrationOption));
            }
        }
        if (tableType == TableType.MANAGED_TABLE) {
            FileSystem fs;
            Path tablePath = new Path(tableObj.getSd().getLocation());
            if (modifyDefaultManagedLocation && this.shouldModifyTableLocation(dbObj, tableObj)) {
                Path newTablePath = this.wh.getDnsPath(new Path(this.wh.getDefaultDatabasePath(dbName), MetaStoreUtils.encodeTableName((String)tableName.toLowerCase())));
                this.moveTableData(dbObj, tableObj, newTablePath);
                if (!this.runOptions.dryRun) {
                    tablePath = newTablePath;
                }
            }
            if ((this.runOptions.shouldModifyManagedTableOwner || this.runOptions.shouldModifyManagedTablePermissions) && HiveStrictManagedMigration.isHdfs(fs = tablePath.getFileSystem((Configuration)this.conf))) {
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, tablePath, this.ownerName, this.groupName, this.dirPerms, this.filePerms, this.runOptions.dryRun, true);
            }
        }
    }

    boolean shouldModifyDatabaseLocation(Database dbObj) throws IOException, MetaException {
        Path oldDefaultDbLocation;
        String dbLocation;
        String dbName = dbObj.getName();
        if (this.runOptions.shouldModifyManagedTableLocation && HiveStrictManagedMigration.arePathsEqual((Configuration)this.conf, dbLocation = dbObj.getLocationUri(), (oldDefaultDbLocation = this.oldWh.getDefaultDatabasePath(dbName)).toString())) {
            if (HiveStrictManagedMigration.hasEquivalentEncryption(this.encryptionShim, oldDefaultDbLocation, this.curWhRootPath)) {
                return true;
            }
            LOG.info("{} and {} are on different encryption zones. Will not change database location for {}", new Object[]{oldDefaultDbLocation, this.curWhRootPath, dbName});
        }
        return false;
    }

    boolean shouldModifyTableLocation(Database dbObj, org.apache.hadoop.hive.metastore.api.Table tableObj) throws IOException, MetaException {
        Path oldDefaultTableLocation;
        String tableLocation = tableObj.getSd().getLocation();
        if (HiveStrictManagedMigration.arePathsEqual((Configuration)this.conf, tableLocation, (oldDefaultTableLocation = this.oldWh.getDefaultTablePath(dbObj, tableObj.getTableName())).toString())) {
            if (HiveStrictManagedMigration.hasEquivalentEncryption(this.encryptionShim, oldDefaultTableLocation, this.curWhRootPath)) {
                return true;
            }
            LOG.info("{} and {} are on different encryption zones. Will not change table location for {}", new Object[]{oldDefaultTableLocation, this.curWhRootPath, HiveStrictManagedMigration.getQualifiedName(tableObj)});
        }
        return false;
    }

    boolean shouldModifyPartitionLocation(Database dbObj, org.apache.hadoop.hive.metastore.api.Table tableObj, org.apache.hadoop.hive.metastore.api.Partition partObj, Map<String, String> partSpec) throws IOException, MetaException {
        Path oldDefaultPartLocation;
        String tableName = tableObj.getTableName();
        String partLocation = partObj.getSd().getLocation();
        if (HiveStrictManagedMigration.arePathsEqual((Configuration)this.conf, partLocation, (oldDefaultPartLocation = this.oldWh.getDefaultPartitionPath(dbObj, tableObj, partSpec)).toString())) {
            if (HiveStrictManagedMigration.hasEquivalentEncryption(this.encryptionShim, oldDefaultPartLocation, this.curWhRootPath)) {
                return true;
            }
            LOG.info("{} and {} are on different encryption zones. Will not change partition location", (Object)oldDefaultPartLocation, (Object)this.curWhRootPath);
        }
        return false;
    }

    void createExternalDbDir(Database dbObj) throws IOException, MetaException {
        Path externalTableDbPath = this.wh.getDefaultExternalDatabasePath(dbObj.getName());
        FileSystem fs = externalTableDbPath.getFileSystem((Configuration)this.conf);
        if (!fs.exists(externalTableDbPath)) {
            String dbOwner = this.ownerName;
            String dbGroup = null;
            String dbOwnerName = dbObj.getOwnerName();
            if (dbOwnerName != null && !dbOwnerName.isEmpty()) {
                switch (dbObj.getOwnerType()) {
                    case USER: {
                        dbOwner = dbOwnerName;
                        break;
                    }
                    case ROLE: {
                        break;
                    }
                    case GROUP: {
                        dbGroup = dbOwnerName;
                    }
                }
            }
            LOG.info("Creating external table directory for database {} at {} with ownership {}/{}", new Object[]{dbObj.getName(), externalTableDbPath, dbOwner, dbGroup});
            if (!this.runOptions.dryRun) {
                fs.mkdirs(externalTableDbPath);
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, externalTableDbPath, dbOwner, dbGroup, null, null, this.runOptions.dryRun, false);
            }
        } else {
            LOG.info("Not creating external table directory for database {} - {} already exists.", (Object)dbObj.getName(), (Object)externalTableDbPath);
        }
    }

    void moveTableData(Database dbObj, org.apache.hadoop.hive.metastore.api.Table tableObj, Path newTablePath) throws HiveException, IOException, TException {
        boolean movedData;
        FileSystem fs;
        String dbName = tableObj.getDbName();
        String tableName = tableObj.getTableName();
        Path oldTablePath = new Path(tableObj.getSd().getLocation());
        LOG.info("Moving location of {} from {} to {}", new Object[]{HiveStrictManagedMigration.getQualifiedName(tableObj), oldTablePath, newTablePath});
        if (!this.runOptions.dryRun && (fs = newTablePath.getFileSystem((Configuration)this.conf)).exists(oldTablePath) && !(movedData = fs.rename(oldTablePath, newTablePath))) {
            String msg = String.format("Unable to move data directory for table %s from %s to %s", HiveStrictManagedMigration.getQualifiedName(tableObj), oldTablePath, newTablePath);
            throw new HiveException(msg);
        }
        if (!this.runOptions.dryRun) {
            this.getHiveUpdater().updateTableLocation(tableObj, newTablePath);
        }
        if (HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            List partNames = this.hms.listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            for (String partName : partNames) {
                Map partSpec;
                org.apache.hadoop.hive.metastore.api.Partition partObj = this.hms.getPartition(dbName, tableName, partName);
                if (!this.shouldModifyPartitionLocation(dbObj, tableObj, partObj, partSpec = Warehouse.makeSpecFromValues((List)tableObj.getPartitionKeys(), (List)partObj.getValues())) || this.runOptions.dryRun) continue;
                Path newPartPath = this.wh.getPartitionPath(newTablePath, partSpec);
                this.getHiveUpdater().updatePartitionLocation(dbName, tableObj, partName, partObj, newPartPath);
            }
        }
    }

    void renameFilesToConformToAcid(org.apache.hadoop.hive.metastore.api.Table tableObj) throws IOException, TException {
        if (HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            String dbName = tableObj.getDbName();
            String tableName = tableObj.getTableName();
            List partNames = this.hms.listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            for (String partName : partNames) {
                org.apache.hadoop.hive.metastore.api.Partition partObj = this.hms.getPartition(dbName, tableName, partName);
                Path partPath = new Path(partObj.getSd().getLocation());
                FileSystem fs = partPath.getFileSystem((Configuration)this.conf);
                if (!fs.exists(partPath)) continue;
                UpgradeTool.handleRenameFiles(tableObj, partPath, !this.runOptions.dryRun, (Configuration)this.conf, tableObj.getSd().getBucketColsSize() > 0, null);
            }
        } else {
            Path tablePath = new Path(tableObj.getSd().getLocation());
            FileSystem fs = tablePath.getFileSystem((Configuration)this.conf);
            if (fs.exists(tablePath)) {
                UpgradeTool.handleRenameFiles(tableObj, tablePath, !this.runOptions.dryRun, (Configuration)this.conf, tableObj.getSd().getBucketColsSize() > 0, null);
            }
        }
    }

    TableMigrationOption determineMigrationTypeAutomatically(org.apache.hadoop.hive.metastore.api.Table tableObj, TableType tableType) throws IOException, MetaException, TException {
        TableMigrationOption result = TableMigrationOption.NONE;
        switch (tableType) {
            case MANAGED_TABLE: {
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    result = TableMigrationOption.MANAGED;
                    break;
                }
                String reason = this.shouldTableBeExternal(tableObj);
                if (reason != null) {
                    LOG.debug("Converting {} to external table. {}", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj), (Object)reason);
                    result = TableMigrationOption.EXTERNAL;
                    break;
                }
                result = TableMigrationOption.MANAGED;
                break;
            }
            case EXTERNAL_TABLE: {
                String msg = String.format("Table %s is already an external table, not processing.", HiveStrictManagedMigration.getQualifiedName(tableObj));
                LOG.debug(msg);
                result = TableMigrationOption.NONE;
                break;
            }
            default: {
                String msg = String.format("Ignoring table %s because it has table type %s", HiveStrictManagedMigration.getQualifiedName(tableObj), tableType);
                LOG.debug(msg);
                result = TableMigrationOption.NONE;
            }
        }
        return result;
    }

    boolean migrateToExternalTable(org.apache.hadoop.hive.metastore.api.Table tableObj, TableType tableType) throws HiveException {
        switch (tableType) {
            case MANAGED_TABLE: {
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table is a transactional table");
                    LOG.debug(msg);
                    return false;
                }
                LOG.info("Converting {} to external table ...", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                if (!this.runOptions.dryRun) {
                    tableObj.setTableType(TableType.EXTERNAL_TABLE.toString());
                    this.getHiveUpdater().updateTableProperties(tableObj, convertToExternalTableProps);
                }
                return true;
            }
            case EXTERNAL_TABLE: {
                String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table is already an external table");
                LOG.debug(msg);
                break;
            }
            default: {
                String msg = HiveStrictManagedMigration.createExternalConversionExcuse(tableObj, "Table type " + tableType + " cannot be converted");
                LOG.debug(msg);
            }
        }
        return false;
    }

    boolean canTableBeFullAcid(org.apache.hadoop.hive.metastore.api.Table tableObj) throws MetaException {
        return TransactionalValidationListener.conformToAcid((org.apache.hadoop.hive.metastore.api.Table)tableObj) && tableObj.getSd().getSortColsSize() <= 0;
    }

    Map<String, String> getTablePropsForConversionToTransactional(Map<String, String> props, boolean convertFromExternal) {
        if (convertFromExternal) {
            props = new HashMap<String, String>(props);
            props.put("EXTERNAL", "FALSE");
        }
        return props;
    }

    boolean migrateToManagedTable(org.apache.hadoop.hive.metastore.api.Table tableObj, TableType tableType) throws HiveException, IOException, MetaException, TException {
        boolean convertFromExternal = false;
        switch (tableType) {
            case EXTERNAL_TABLE: {
                convertFromExternal = true;
            }
            case MANAGED_TABLE: {
                if (MetaStoreUtils.isNonNativeTable((org.apache.hadoop.hive.metastore.api.Table)tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is a non-native (StorageHandler) table");
                    LOG.debug(msg);
                    return false;
                }
                if (HiveStrictManagedUtils.isAvroTableWithExternalSchema((org.apache.hadoop.hive.metastore.api.Table)tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is an Avro table with an external schema url");
                    LOG.debug(msg);
                    return false;
                }
                if (HiveStrictManagedUtils.isListBucketedTable((org.apache.hadoop.hive.metastore.api.Table)tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is a list bucketed table");
                    LOG.debug(msg);
                    return false;
                }
                if (AcidUtils.isTransactionalTable(tableObj)) {
                    String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table is already a transactional table");
                    LOG.debug(msg);
                    return false;
                }
                if (this.canTableBeFullAcid(tableObj)) {
                    LOG.info("Converting {} to full transactional table", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                    this.renameFilesToConformToAcid(tableObj);
                    if (!this.runOptions.dryRun) {
                        Map<String, String> props = this.getTablePropsForConversionToTransactional(convertToAcidTableProps, convertFromExternal);
                        this.getHiveUpdater().updateTableProperties(tableObj, props);
                    }
                    return true;
                }
                LOG.info("Converting {} to insert-only transactional table", (Object)HiveStrictManagedMigration.getQualifiedName(tableObj));
                if (!this.runOptions.dryRun) {
                    Map<String, String> props = this.getTablePropsForConversionToTransactional(convertToMMTableProps, convertFromExternal);
                    this.getHiveUpdater().updateTableProperties(tableObj, props);
                }
                return true;
            }
        }
        String msg = HiveStrictManagedMigration.createManagedConversionExcuse(tableObj, "Table type " + tableType + " cannot be converted");
        LOG.debug(msg);
        return false;
    }

    String shouldTableBeExternal(org.apache.hadoop.hive.metastore.api.Table tableObj) throws IOException, MetaException, TException {
        if (MetaStoreUtils.isNonNativeTable((org.apache.hadoop.hive.metastore.api.Table)tableObj)) {
            return "Table is a non-native (StorageHandler) table";
        }
        if (HiveStrictManagedUtils.isAvroTableWithExternalSchema((org.apache.hadoop.hive.metastore.api.Table)tableObj)) {
            return "Table is an Avro table with an external schema url";
        }
        if (HiveStrictManagedUtils.isListBucketedTable((org.apache.hadoop.hive.metastore.api.Table)tableObj)) {
            return "Table is a list bucketed table";
        }
        if (this.shouldTablePathBeExternal(tableObj, this.ownerName)) {
            return String.format("One or more table directories not owned by %s, or non-HDFS path", this.ownerName);
        }
        return null;
    }

    boolean shouldTablePathBeExternal(org.apache.hadoop.hive.metastore.api.Table tableObj, String userName) throws IOException, MetaException, TException {
        boolean shouldBeExternal = false;
        String dbName = tableObj.getDbName();
        String tableName = tableObj.getTableName();
        if (!HiveStrictManagedMigration.isPartitionedTable(tableObj)) {
            boolean ownedByHive;
            Path tablePath = new Path(tableObj.getSd().getLocation());
            FileSystem fs = tablePath.getFileSystem((Configuration)this.conf);
            shouldBeExternal = HiveStrictManagedMigration.isHdfs(fs) ? !(ownedByHive = HiveStrictManagedMigration.checkDirectoryOwnership(fs, tablePath, this.ownerName, true)) : true;
        } else {
            boolean ownedByHive;
            String partName;
            org.apache.hadoop.hive.metastore.api.Partition partObj;
            Path partPath;
            FileSystem fs;
            List partNames = this.hms.listPartitionNames(dbName, tableName, (short)Short.MAX_VALUE);
            Iterator iterator = partNames.iterator();
            while (iterator.hasNext() && !(shouldBeExternal = HiveStrictManagedMigration.isHdfs(fs = (partPath = new Path((partObj = this.hms.getPartition(dbName, tableName, partName = (String)iterator.next())).getSd().getLocation())).getFileSystem((Configuration)this.conf)) ? !(ownedByHive = HiveStrictManagedMigration.checkDirectoryOwnership(fs, partPath, this.ownerName, true)) : true)) {
            }
        }
        return shouldBeExternal;
    }

    void cleanup() {
        if (this.hiveUpdater != null) {
            HiveStrictManagedMigration.runAndLogErrors(() -> this.hiveUpdater.close());
            this.hiveUpdater = null;
        }
    }

    HiveUpdater getHiveUpdater() throws HiveException {
        if (this.hiveUpdater == null) {
            this.hiveUpdater = new HiveUpdater();
        }
        return this.hiveUpdater;
    }

    static void runAndLogErrors(ThrowableRunnable r) {
        try {
            r.run();
        }
        catch (Exception err) {
            LOG.error("Error encountered", (Throwable)err);
        }
    }

    static String createExternalConversionExcuse(org.apache.hadoop.hive.metastore.api.Table tableObj, String reason) {
        return String.format("Table %s cannot be converted to an external table in strict managed table mode for the following reason: %s", HiveStrictManagedMigration.getQualifiedName(tableObj), reason);
    }

    static String createManagedConversionExcuse(org.apache.hadoop.hive.metastore.api.Table tableObj, String reason) {
        return String.format("Table %s cannot be converted to a managed table in strict managed table mode for the following reason: %s", HiveStrictManagedMigration.getQualifiedName(tableObj), reason);
    }

    static boolean isPartitionedTable(org.apache.hadoop.hive.metastore.api.Table tableObj) {
        List partKeys = tableObj.getPartitionKeys();
        return partKeys != null && partKeys.size() > 0;
    }

    static boolean isHdfs(FileSystem fs) {
        return fs.getScheme().equals("hdfs");
    }

    static String getQualifiedName(org.apache.hadoop.hive.metastore.api.Table tableObj) {
        return HiveStrictManagedMigration.getQualifiedName(tableObj.getDbName(), tableObj.getTableName());
    }

    static String getQualifiedName(String dbName, String tableName) {
        StringBuilder sb = new StringBuilder();
        sb.append('`');
        sb.append(dbName);
        sb.append("`.`");
        sb.append(tableName);
        sb.append('`');
        return sb.toString();
    }

    static boolean arePathsEqual(Configuration conf, String path1, String path2) throws IOException {
        String qualified1 = HiveStrictManagedMigration.getQualifiedPath(conf, new Path(path1));
        String qualified2 = HiveStrictManagedMigration.getQualifiedPath(conf, new Path(path2));
        return qualified1.equals(qualified2);
    }

    static String getQualifiedPath(Configuration conf, Path path) throws IOException {
        if (path == null) {
            return null;
        }
        FileSystem fs = path.getFileSystem(conf);
        return fs.makeQualified(path).toString();
    }

    static void checkAndSetFileOwnerPermissions(FileSystem fs, Path path, String userName, String groupName, FsPermission dirPerms, FsPermission filePerms, boolean dryRun, boolean recurse) throws IOException {
        FileStatus fStatus = HiveStrictManagedMigration.getFileStatus(fs, path);
        HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, fStatus, userName, groupName, dirPerms, filePerms, dryRun, recurse);
    }

    static void checkAndSetFileOwnerPermissions(FileSystem fs, FileStatus fStatus, String userName, String groupName, FsPermission dirPerms, FsPermission filePerms, boolean dryRun, boolean recurse) throws IOException {
        if (fStatus == null) {
            return;
        }
        Path path = fStatus.getPath();
        boolean setOwner = false;
        if (userName != null && !userName.equals(fStatus.getOwner())) {
            setOwner = true;
        } else if (groupName != null && !groupName.equals(fStatus.getGroup())) {
            setOwner = true;
        }
        boolean isDir = fStatus.isDirectory();
        boolean setPerms = false;
        FsPermission perms = filePerms;
        if (isDir) {
            perms = dirPerms;
        }
        if (perms != null && !perms.equals((Object)fStatus.getPermission())) {
            setPerms = true;
        }
        if (setOwner) {
            LOG.debug("Setting owner/group of {} to {}/{}", new Object[]{path, userName, groupName});
            if (!dryRun) {
                fs.setOwner(path, userName, groupName);
            }
        }
        if (setPerms) {
            LOG.debug("Setting perms of {} to {}", (Object)path, (Object)perms);
            if (!dryRun) {
                fs.setPermission(path, perms);
            }
        }
        if (isDir && recurse) {
            for (FileStatus subFile : fs.listStatus(path)) {
                HiveStrictManagedMigration.checkAndSetFileOwnerPermissions(fs, subFile, userName, groupName, dirPerms, filePerms, dryRun, recurse);
            }
        }
    }

    static boolean checkDirectoryOwnership(FileSystem fs, Path path, String userName, boolean recurse) throws IOException {
        FileStatus fStatus = HiveStrictManagedMigration.getFileStatus(fs, path);
        return HiveStrictManagedMigration.checkDirectoryOwnership(fs, fStatus, userName, recurse);
    }

    static boolean checkDirectoryOwnership(FileSystem fs, FileStatus fStatus, String userName, boolean recurse) throws IOException {
        if (fStatus == null) {
            return true;
        }
        Path path = fStatus.getPath();
        boolean result = true;
        boolean isDir = fStatus.isDirectory();
        if (isDir) {
            if (userName != null && !userName.equals(fStatus.getOwner())) {
                return false;
            }
            if (recurse) {
                for (FileStatus subFile : fs.listStatus(path)) {
                    if (HiveStrictManagedMigration.checkDirectoryOwnership(fs, subFile, userName, recurse)) continue;
                    return false;
                }
            }
        }
        return result;
    }

    static FileStatus getFileStatus(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            return null;
        }
        return fs.getFileStatus(path);
    }

    static FileStatus[] listStatus(FileSystem fs, Path path) throws IOException {
        if (!fs.exists(path)) {
            return null;
        }
        return fs.listStatus(path);
    }

    static boolean hasEquivalentEncryption(HadoopShims.HdfsEncryptionShim encryptionShim, Path path1, Path path2) throws IOException {
        return !encryptionShim.isPathEncrypted(path1) && !encryptionShim.isPathEncrypted(path2) || encryptionShim.arePathsOnSameEncryptionZone(path1, path2);
    }

    static {
        convertToExternalTableProps.put("EXTERNAL", "TRUE");
        convertToExternalTableProps.put("external.table.purge", "true");
        convertToAcidTableProps.put("transactional", "true");
        convertToMMTableProps.put("transactional", "true");
        convertToMMTableProps.put("transactional_properties", "insert_only");
    }

    static interface ThrowableRunnable {
        public void run() throws Exception;
    }

    class HiveUpdater {
        Hive hive;

        HiveUpdater() throws HiveException {
            this.hive = Hive.get(HiveStrictManagedMigration.this.conf);
            Hive.set(this.hive);
        }

        void close() {
            if (this.hive != null) {
                HiveStrictManagedMigration.runAndLogErrors(() -> Hive.closeCurrent());
                this.hive = null;
            }
        }

        void updateDbLocation(Database db, Path newLocation) throws HiveException {
            String msg = String.format("ALTER DATABASE %s SET LOCATION '%s'", db.getName(), newLocation);
            LOG.info(msg);
            db.setLocationUri(newLocation.toString());
            this.hive.alterDatabase(db.getName(), db);
        }

        void updateTableLocation(org.apache.hadoop.hive.metastore.api.Table table, Path newLocation) throws HiveException {
            String msg = String.format("ALTER TABLE %s SET LOCATION '%s'", HiveStrictManagedMigration.getQualifiedName(table), newLocation);
            LOG.info(msg);
            Table modifiedTable = new Table(table);
            modifiedTable.setDataLocation(newLocation);
            this.hive.alterTable(table.getDbName(), table.getTableName(), modifiedTable, false, null);
        }

        void updatePartitionLocation(String dbName, org.apache.hadoop.hive.metastore.api.Table table, String partName, org.apache.hadoop.hive.metastore.api.Partition part, Path newLocation) throws HiveException, TException {
            String msg = String.format("ALTER TABLE %s PARTITION (%s) SET LOCATION '%s'", HiveStrictManagedMigration.getQualifiedName(table), partName, newLocation.toString());
            LOG.info(msg);
            Partition modifiedPart = new Partition(new Table(table), part);
            modifiedPart.setLocation(newLocation.toString());
            this.hive.alterPartition(dbName, table.getTableName(), modifiedPart, null);
        }

        void updateTableProperties(org.apache.hadoop.hive.metastore.api.Table table, Map<String, String> props) throws HiveException {
            StringBuilder sb = new StringBuilder();
            Table modifiedTable = new Table(table);
            if (props.size() == 0) {
                return;
            }
            boolean first = true;
            for (String key : props.keySet()) {
                String value = props.get(key);
                modifiedTable.getParameters().put(key, value);
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("'");
                sb.append(key);
                sb.append("'='");
                sb.append(value);
                sb.append("'");
            }
            String msg = String.format("ALTER TABLE %s SET TBLPROPERTIES (%s)", HiveStrictManagedMigration.getQualifiedName(table), sb.toString());
            LOG.info(msg);
            this.hive.alterTable(table.getDbName(), table.getTableName(), modifiedTable, false, null);
        }
    }

    static class RunOptions {
        String dbRegex;
        String tableRegex;
        String oldWarehouseRoot;
        TableMigrationOption migrationOption;
        boolean shouldModifyManagedTableLocation;
        boolean shouldModifyManagedTableOwner;
        boolean shouldModifyManagedTablePermissions;
        boolean dryRun;

        public RunOptions(String dbRegex, String tableRegex, String oldWarehouseRoot, TableMigrationOption migrationOption, boolean shouldModifyManagedTableLocation, boolean shouldModifyManagedTableOwner, boolean shouldModifyManagedTablePermissions, boolean dryRun) {
            this.dbRegex = dbRegex;
            this.tableRegex = tableRegex;
            this.oldWarehouseRoot = oldWarehouseRoot;
            this.migrationOption = migrationOption;
            this.shouldModifyManagedTableLocation = shouldModifyManagedTableLocation;
            this.shouldModifyManagedTableOwner = shouldModifyManagedTableOwner;
            this.shouldModifyManagedTablePermissions = shouldModifyManagedTablePermissions;
            this.dryRun = dryRun;
        }
    }

    static enum TableMigrationOption {
        NONE,
        VALIDATE,
        AUTOMATIC,
        EXTERNAL,
        MANAGED;

    }
}

