/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.oozie.util.XLog;

public final class AMLocalityHelper {
    private static final RecordFactory recordFactory = RecordFactoryProvider.getRecordFactory(null);
    private static final XLog LOG = XLog.getLog(AMLocalityHelper.class);
    private static final String DEFAULT_RACK = "/default-rack";
    private static final String RACK_GROUP = "rack";
    private static final String NODE_IF_RACK_GROUP = "node1";
    private static final String NODE_IF_NO_RACK_GROUP = "node2";
    private static final Pattern RACK_NODE_PATTERN = Pattern.compile(String.format("(?<%s>[^/]+?)|(?<%s>/[^/]+?)(?:/(?<%s>[^/]+?))?", "node2", "rack", "node1"));

    private AMLocalityHelper() {
    }

    public static List<ResourceRequest> generateResourceRequests(int memory, int vcores, int priority, Collection<String> locality) {
        Resource capability = (Resource)recordFactory.newRecordInstance(Resource.class);
        capability.setMemorySize((long)memory);
        capability.setVirtualCores(vcores);
        LOG.debug("AppMaster capability = {0}", capability);
        ArrayList<ResourceRequest> amResourceRequests = new ArrayList<ResourceRequest>();
        ResourceRequest amAnyResourceRequest = AMLocalityHelper.createSingleContainerRelaxedLocalityResourceRequest("*", capability, priority);
        HashMap<String, ResourceRequest> rackRequests = new HashMap<String, ResourceRequest>();
        amResourceRequests.add(amAnyResourceRequest);
        for (String amStrictResource : locality) {
            amAnyResourceRequest.setRelaxLocality(false);
            Matcher matcher = RACK_NODE_PATTERN.matcher(amStrictResource);
            if (matcher.matches()) {
                String nodeName;
                String rackName = matcher.group(RACK_GROUP);
                if (rackName == null) {
                    rackName = DEFAULT_RACK;
                    nodeName = matcher.group(NODE_IF_NO_RACK_GROUP);
                } else {
                    nodeName = matcher.group(NODE_IF_RACK_GROUP);
                }
                ResourceRequest amRackResourceRequest = (ResourceRequest)rackRequests.get(rackName);
                if (amRackResourceRequest == null) {
                    amRackResourceRequest = AMLocalityHelper.createSingleContainerRelaxedLocalityResourceRequest(rackName, capability, priority);
                    amResourceRequests.add(amRackResourceRequest);
                    rackRequests.put(rackName, amRackResourceRequest);
                }
                if (nodeName == null) continue;
                amRackResourceRequest.setRelaxLocality(false);
                ResourceRequest amNodeResourceRequest = AMLocalityHelper.createSingleContainerRelaxedLocalityResourceRequest(nodeName, capability, priority);
                amResourceRequests.add(amNodeResourceRequest);
                continue;
            }
            String errMsg = "Invalid resource name: " + amStrictResource + " specified.";
            LOG.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        for (ResourceRequest amResourceRequest : amResourceRequests) {
            LOG.debug("ResourceRequest: resource = {0}, locality = {1}", amResourceRequest.getResourceName(), amResourceRequest.getRelaxLocality());
        }
        return amResourceRequests;
    }

    private static ResourceRequest createSingleContainerRelaxedLocalityResourceRequest(String resource, Resource capability, int priority) {
        ResourceRequest resourceRequest = (ResourceRequest)recordFactory.newRecordInstance(ResourceRequest.class);
        resourceRequest.setPriority(Priority.newInstance((int)priority));
        resourceRequest.setResourceName(resource);
        resourceRequest.setCapability(capability);
        resourceRequest.setNumContainers(1);
        resourceRequest.setRelaxLocality(true);
        return resourceRequest;
    }
}

