/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.hcatalog.api.HCatClient;
import org.apache.hive.hcatalog.common.HCatException;
import org.apache.oozie.action.hadoop.CredentialsProviderFactory;
import org.apache.oozie.util.XLog;

public class HCatCredentialHelper {
    private static final String USER_NAME = "user.name";
    private static final String HIVE_METASTORE_SASL_ENABLED = "hive.metastore.sasl.enabled";
    private static final String HIVE_METASTORE_KERBEROS_PRINCIPAL = "hive.metastore.kerberos.principal";
    private static final String HIVE_METASTORE_LOCAL = "hive.metastore.local";
    private static final String HADOOP_RPC_PROTECTION = "hadoop.rpc.protection";

    public void set(Credentials credentials, Configuration launcherConfig, String principal, String server) throws Exception {
        try (HCatClient client = null;){
            client = this.getHCatClient(launcherConfig, principal, server);
            XLog.getLog(this.getClass()).debug("HCatCredentialHelper: set: User name for which token will be asked from HCat: {0}", launcherConfig.get(USER_NAME));
            String tokenStrForm = client.getDelegationToken(launcherConfig.get(USER_NAME), UserGroupInformation.getLoginUser().getShortUserName());
            Token hcatToken = new Token();
            hcatToken.decodeFromUrlString(tokenStrForm);
            credentials.addToken(CredentialsProviderFactory.getUniqueAlias(hcatToken), hcatToken);
            XLog.getLog(this.getClass()).debug("Added the HCat token to launcher's credentials");
        }
    }

    public HCatClient getHCatClient(Configuration launcherConfig, String principal, String server) throws HCatException {
        HiveConf hiveConf = null;
        HCatClient hiveclient = null;
        hiveConf = new HiveConf();
        XLog.getLog(this.getClass()).debug("getHCatClient: Principal: {0} Server: {1}", principal, server);
        hiveConf.set(HIVE_METASTORE_SASL_ENABLED, "true");
        hiveConf.set(HIVE_METASTORE_KERBEROS_PRINCIPAL, principal);
        hiveConf.set(HIVE_METASTORE_LOCAL, "false");
        hiveConf.set(HiveConf.ConfVars.METASTOREURIS.varname, server);
        String protection = launcherConfig.get(HADOOP_RPC_PROTECTION, SaslRpcServer.QualityOfProtection.AUTHENTICATION.name().toLowerCase());
        XLog.getLog(this.getClass()).debug("getHCatClient, setting rpc protection to {0}", protection);
        hiveConf.set(HADOOP_RPC_PROTECTION, protection);
        hiveclient = HCatClient.create((Configuration)hiveConf);
        return hiveclient;
    }
}

