/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.PrivilegedExceptionAction;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.mapreduce.security.TokenCache;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialException;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.HadoopTokenHelper;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UserGroupInformationService;
import org.apache.oozie.util.XLog;

public class HDFSCredentials
implements CredentialsProvider {
    protected XLog LOG = XLog.getLog(this.getClass());

    @Override
    public void updateCredentials(Credentials credentials, Configuration config, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        String[] jobNameNodes = config.getStrings("mapreduce.job.hdfs-servers");
        if (jobNameNodes != null) {
            Path[] paths = new Path[jobNameNodes.length];
            for (int i = 0; i != jobNameNodes.length; ++i) {
                paths[i] = new Path(jobNameNodes[i]);
            }
            UserGroupInformation ugi = Services.get().get(UserGroupInformationService.class).getProxyUser(context.getWorkflow().getUser());
            User user = User.create((UserGroupInformation)ugi);
            this.obtainTokensForNamenodes(credentials, config, user, paths);
        } else {
            this.obtainTokenForAppFileSystemNameNode(credentials, config, context);
        }
    }

    private void obtainTokenForAppFileSystemNameNode(Credentials credentials, Configuration config, ActionExecutor.Context context) throws IOException, CredentialException, HadoopAccessorException, URISyntaxException {
        try (FileSystem fileSystem = context.getAppFileSystem();){
            String renewer = new HadoopTokenHelper().getServerPrincipal(config);
            this.LOG.debug("Server principal present, getting HDFS delegation token. [renewer={0}]", renewer);
            Token hdfsDelegationToken = fileSystem.getDelegationToken(renewer);
            if (hdfsDelegationToken == null) {
                throw new CredentialException(ErrorCode.E0511, renewer);
            }
            this.LOG.info("Got HDFS delegation token, setting credentials. [hdfsDelegationToken={0}]", hdfsDelegationToken);
            credentials.addToken(hdfsDelegationToken.getService(), hdfsDelegationToken);
        }
        catch (Exception e) {
            this.LOG.debug((Object)"exception in updateCredentials", e);
            throw e;
        }
    }

    private void obtainTokensForNamenodes(final Credentials credentials, final Configuration config, User user, final Path[] paths) throws IOException, InterruptedException {
        this.LOG.info(String.format("\"%s\" is present in workflow configuration. Obtaining tokens for NameNode(s) [%s]", "mapreduce.job.hdfs-servers", config.get("mapreduce.job.hdfs-servers")));
        user.runAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                TokenCache.obtainTokensForNamenodes((Credentials)credentials, (Path[])paths, (Configuration)config);
                return null;
            }
        });
    }
}

