/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.sql.Connection;
import java.sql.DriverManager;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.Token;
import org.apache.hive.jdbc.HiveConnection;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.CredentialException;
import org.apache.oozie.action.hadoop.CredentialsProperties;
import org.apache.oozie.action.hadoop.CredentialsProvider;
import org.apache.oozie.action.hadoop.CredentialsProviderFactory;
import org.apache.oozie.util.XLog;

public class Hive2Credentials
implements CredentialsProvider {
    private static final String USER_NAME = "user.name";
    private static final String HIVE2_JDBC_URL = "hive2.jdbc.url";
    private static final String HIVE2_SERVER_PRINCIPAL = "hive2.server.principal";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateCredentials(Credentials credentials, Configuration config, CredentialsProperties props, ActionExecutor.Context context) throws Exception {
        try {
            Class.forName("org.apache.hive.jdbc.HiveDriver");
            String url = props.getProperties().get(HIVE2_JDBC_URL);
            if (url == null || url.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hive2.jdbc.url is required to get hive server 2 credential");
            }
            String principal = props.getProperties().get(HIVE2_SERVER_PRINCIPAL);
            if (principal == null || principal.isEmpty()) {
                throw new CredentialException(ErrorCode.E0510, "hive2.server.principal is required to get hive server 2 credentials");
            }
            url = url + ";principal=" + principal;
            String tokenStr = null;
            try (Connection con = null;){
                con = DriverManager.getConnection(url);
                XLog.getLog(this.getClass()).debug("Connected successfully to " + url);
                tokenStr = ((HiveConnection)con).getDelegationToken(config.get(USER_NAME), principal);
            }
            XLog.getLog(this.getClass()).debug("Got token");
            Token hive2Token = new Token();
            hive2Token.decodeFromUrlString(tokenStr);
            credentials.addToken(CredentialsProviderFactory.getUniqueAlias(hive2Token), hive2Token);
            XLog.getLog(this.getClass()).debug("Added the Hive Server 2 token to launcher's credential");
        }
        catch (Exception e) {
            XLog.getLog(this.getClass()).warn((Object)"Exception in obtaining Hive2 token", e);
            throw e;
        }
    }
}

