/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.hadoop.ActionUtils;
import org.apache.oozie.action.hadoop.ScriptLanguageActionExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.jdom.Element;
import org.jdom.Namespace;

public class HiveActionExecutor
extends ScriptLanguageActionExecutor {
    private static final String HIVE_MAIN_CLASS_NAME = "org.apache.oozie.action.hadoop.HiveMain";
    static final String HIVE_QUERY = "oozie.hive.query";
    static final String HIVE_SCRIPT = "oozie.hive.script";
    static final String HIVE_PARAMS = "oozie.hive.params";
    static final String HIVE_ARGS = "oozie.hive.args";
    private boolean addScriptToCache = false;

    public HiveActionExecutor() {
        super("hive");
    }

    @Override
    public List<Class<?>> getLauncherClasses() {
        ArrayList classes = new ArrayList();
        try {
            classes.add(Class.forName(HIVE_MAIN_CLASS_NAME));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class not found", e);
        }
        return classes;
    }

    @Override
    protected boolean shouldAddScriptToCache() {
        return this.addScriptToCache;
    }

    @Override
    protected String getLauncherMain(Configuration launcherConf, Element actionXml) {
        return launcherConf.get("oozie.launcher.action.main.class", HIVE_MAIN_CLASS_NAME);
    }

    @Override
    Configuration setupActionConf(Configuration actionConf, ActionExecutor.Context context, Element actionXml, Path appPath) throws ActionExecutorException {
        Configuration conf = super.setupActionConf(actionConf, context, actionXml, appPath);
        Namespace ns = actionXml.getNamespace();
        Element scriptElement = actionXml.getChild("script", ns);
        Element queryElement = actionXml.getChild("query", ns);
        if (scriptElement != null) {
            String script = scriptElement.getTextTrim();
            String scriptName = new Path(script).getName();
            this.addScriptToCache = true;
            conf.set(HIVE_SCRIPT, scriptName);
        } else if (queryElement != null) {
            String query = queryElement.getText();
            conf.set(HIVE_QUERY, query);
        } else {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, "INVALID_ARGUMENTS", "Hive action requires one of <script> or <query> to be set. Neither were found.");
        }
        List params = actionXml.getChildren("param", ns);
        String[] strParams = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            strParams[i] = ((Element)params.get(i)).getTextTrim();
        }
        ActionUtils.setStrings((Configuration)conf, (String)HIVE_PARAMS, (String[])strParams);
        String[] strArgs = null;
        List eArgs = actionXml.getChildren("argument", ns);
        if (eArgs != null && eArgs.size() > 0) {
            strArgs = new String[eArgs.size()];
            for (int i = 0; i < eArgs.size(); ++i) {
                strArgs[i] = ((Element)eArgs.get(i)).getTextTrim();
            }
        }
        ActionUtils.setStrings((Configuration)conf, (String)HIVE_ARGS, strArgs);
        return conf;
    }

    @Override
    protected String getDefaultShareLibName(Element actionXml) {
        return "hive";
    }

    @Override
    protected String getScriptName() {
        return HIVE_SCRIPT;
    }

    @Override
    public String[] getShareLibFilesForActionConf() {
        return new String[]{"hive-site.xml"};
    }

    @Override
    protected Configuration loadHadoopDefaultResources(ActionExecutor.Context context, Element actionXml) {
        boolean loadDefaultResources = ConfigurationService.getBoolean("oozie.service.HadoopAccessorService.action.configurations.load.default.resources");
        Configuration conf = super.createBaseHadoopConf(context, actionXml, loadDefaultResources);
        return conf;
    }
}

