/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.curator.framework.recipes.leader.LeaderLatch;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.JobsConcurrencyService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ZKUtils;

public class ZKJobsConcurrencyService
extends JobsConcurrencyService
implements Service,
Instrumentable {
    private ZKUtils zk;
    private static final Pattern ID_PATTERN = Pattern.compile("(\\d{7})-.*");
    private static final String ZK_LEADER_PATH = "concurrencyleader";
    private static LeaderLatch leaderLatch = null;

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
            leaderLatch = new LeaderLatch(this.zk.getClient(), "/services/concurrencyleader", this.zk.getZKId());
            leaderLatch.start();
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
    }

    @Override
    public void destroy() {
        if (leaderLatch != null) {
            IOUtils.closeSafely(new Closeable[]{leaderLatch});
        }
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        super.instrument(instr);
    }

    @Override
    public boolean isLeader() {
        return leaderLatch.hasLeadership();
    }

    @Override
    public boolean isJobIdForThisServer(String jobId) {
        List<ServiceInstance<Map>> oozies = this.zk.getAllMetaData();
        int numOozies = oozies.size();
        int myIndex = this.zk.getZKIdIndex(oozies);
        return this.checkJobIdForServer(jobId, numOozies, myIndex);
    }

    @Override
    public List<String> getJobIdsForThisServer(List<String> ids) {
        ArrayList<String> filteredIds = new ArrayList<String>();
        List<ServiceInstance<Map>> oozies = this.zk.getAllMetaData();
        int numOozies = oozies.size();
        int myIndex = this.zk.getZKIdIndex(oozies);
        for (String id : ids) {
            if (!this.checkJobIdForServer(id, numOozies, myIndex)) continue;
            filteredIds.add(id);
        }
        return filteredIds;
    }

    private boolean checkJobIdForServer(String jobId, int numOozies, int myIndex) {
        boolean belongs = true;
        Matcher m = ID_PATTERN.matcher(jobId);
        if (m.matches() && m.groupCount() == 1) {
            String idNumStr = m.group(1);
            int idNum = Integer.parseInt(idNumStr);
            belongs = idNum % numOozies == myIndex;
        }
        return belongs;
    }

    @Override
    public Map<String, String> getServerUrls() {
        HashMap<String, String> urls = new HashMap<String, String>();
        List<ServiceInstance<Map>> oozies = this.zk.getAllMetaData();
        for (ServiceInstance<Map> oozie : oozies) {
            Map metadata = (Map)oozie.getPayload();
            String id = (String)metadata.get("OOZIE_ID");
            String url = (String)metadata.get("OOZIE_URL");
            urls.put(id, url);
        }
        return urls;
    }

    @Override
    public Map<String, String> getOtherServerUrls() {
        HashMap<String, String> urls = new HashMap<String, String>();
        List<ServiceInstance<Map>> oozies = this.zk.getAllMetaData();
        for (ServiceInstance<Map> oozie : oozies) {
            Map metadata = (Map)oozie.getPayload();
            String id = (String)metadata.get("OOZIE_ID");
            if (id.equals(this.zk.getZKId())) continue;
            String url = (String)metadata.get("OOZIE_URL");
            urls.put(id, url);
        }
        return urls;
    }

    @Override
    public boolean isAllServerRequest(Map<String, String[]> params) {
        return params == null || params.get("allservers") == null || params.isEmpty() || !params.get("allservers")[0].equalsIgnoreCase("false");
    }

    @Override
    public boolean isHighlyAvailableMode() {
        return true;
    }
}

