/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.MapMaker;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.curator.framework.recipes.locks.Reaper;
import org.apache.curator.utils.ThreadUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ChildReaper;
import org.apache.oozie.util.Instrumentable;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.ZKUtils;
import org.apache.zookeeper.KeeperException;

public class ZKLocksService
extends MemoryLocksService
implements Service,
Instrumentable {
    private ZKUtils zk;
    public static final String LOCKS_NODE = "/locks";
    private static final XLog LOG = XLog.getLog(ZKLocksService.class);
    private final ConcurrentMap<String, InterProcessReadWriteLock> zkLocks = new MapMaker().weakValues().makeMap();
    private ChildReaper reaper = null;
    private static final String REAPING_LEADER_PATH = "/services/locksChildReaperLeaderPath";
    static final String REAPING_THRESHOLD = "oozie.service.ZKLocksService.locks.reaper.threshold";
    static final String REAPING_THREADS = "oozie.service.ZKLocksService.locks.reaper.threads";
    private static final String RELEASE_RETRY_TIME_LIMIT_MINUTES = "oozie.service.ZKLocksService.lock.release.retry.time.limit.minutes";

    @Override
    public void init(Services services) throws ServiceException {
        super.init(services);
        try {
            this.zk = ZKUtils.register(this);
            this.reaper = new ChildReaper(this.zk.getClient(), LOCKS_NODE, Reaper.Mode.REAP_UNTIL_GONE, ZKLocksService.getExecutorService(), ConfigurationService.getInt(services.getConf(), REAPING_THRESHOLD) * 1000, REAPING_LEADER_PATH);
            this.reaper.start();
        }
        catch (Exception ex) {
            throw new ServiceException(ErrorCode.E1700, ex.getMessage(), ex);
        }
    }

    @Override
    public void destroy() {
        if (this.reaper != null) {
            try {
                this.reaper.close();
            }
            catch (IOException e) {
                LOG.error((Object)"Error closing childReaper", e);
            }
        }
        if (this.zk != null) {
            this.zk.unregister(this);
        }
        this.zk = null;
        super.destroy();
    }

    @Override
    public void instrument(Instrumentation instr) {
        instr.addVariable("locks", "locks", new Instrumentation.Variable<Integer>(){

            @Override
            public Integer getValue() {
                return ZKLocksService.this.zkLocks.size();
            }
        });
    }

    @Override
    public LockToken getReadLock(String resource, long wait) throws InterruptedException {
        return this.acquireLock(resource, MemoryLocksService.Type.READ, wait);
    }

    @Override
    public LockToken getWriteLock(String resource, long wait) throws InterruptedException {
        return this.acquireLock(resource, MemoryLocksService.Type.WRITE, wait);
    }

    private LockToken acquireLock(String resource, MemoryLocksService.Type type, long wait) throws InterruptedException {
        InterProcessReadWriteLock lockEntry;
        LOG.debug("Acquiring ZooKeeper lock. [resource={};type={};wait={}]", new Object[]{resource, type, wait});
        String zkPath = "/locks/" + resource;
        LOG.debug("Checking existing Curator lock or creating new one. [zkPath={}]", zkPath);
        InterProcessReadWriteLock newLockEntry = new InterProcessReadWriteLock(this.zk.getClient(), zkPath);
        InterProcessReadWriteLock existingLockEntry = this.zkLocks.putIfAbsent(resource, newLockEntry);
        if (existingLockEntry == null) {
            lockEntry = newLockEntry;
            LOG.debug("No existing Curator lock present, new one created successfully. [zkPath={}]", zkPath);
        } else {
            lockEntry = existingLockEntry;
            LOG.debug("Reusing existing Curator lock. [zkPath={}]", zkPath);
        }
        ZKLockToken token = null;
        try {
            InterProcessMutex lock;
            LOG.debug("Calling Curator to acquire ZooKeeper lock. [resource={};type={};wait={}]", new Object[]{resource, type, wait});
            InterProcessMutex interProcessMutex = lock = type.equals((Object)MemoryLocksService.Type.READ) ? lockEntry.readLock() : lockEntry.writeLock();
            if (wait == -1L) {
                lock.acquire();
                token = new ZKLockToken(lockEntry, type);
                LOG.debug("ZooKeeper lock acquired successfully. [resource={};type={}]", new Object[]{resource, type});
            } else if (lock.acquire(wait, TimeUnit.MILLISECONDS)) {
                token = new ZKLockToken(lockEntry, type);
                LOG.debug("ZooKeeper lock acquired successfully waiting. [resource={};type={};wait={}]", new Object[]{resource, type, wait});
            } else {
                LOG.warn("Could not acquire ZooKeeper lock, timed out. [resource={};type={};wait={}]", new Object[]{resource, type, wait});
            }
        }
        catch (Exception ex) {
            LOG.warn("Could not acquire lock due to a ZooKeeper error. [ex={};resource={};type={};wait={}]", new Object[]{ex, resource, type, wait});
            LOG.error((Object)"Error while acquiring lock", ex);
        }
        return token;
    }

    @VisibleForTesting
    public ConcurrentMap<String, InterProcessReadWriteLock> getLocks() {
        return this.zkLocks;
    }

    private static ScheduledExecutorService getExecutorService() {
        return ThreadUtils.newFixedThreadScheduledPool((int)ConfigurationService.getInt(REAPING_THREADS), (String)"ZKLocksChildReaper");
    }

    class ZKLockToken
    implements LockToken {
        private final InterProcessReadWriteLock lockEntry;
        private final MemoryLocksService.Type type;

        private ZKLockToken(InterProcessReadWriteLock lockEntry, MemoryLocksService.Type type) {
            this.lockEntry = lockEntry;
            this.type = type;
        }

        @Override
        public void release() {
            try {
                this.retriableRelease();
            }
            catch (Exception ex) {
                LOG.warn((Object)("Could not release lock: " + ex.getMessage()), ex);
            }
        }

        private void retriableRelease() throws Exception {
            long retryTimeLimit = TimeUnit.MINUTES.toSeconds(ConfigurationService.getLong(ZKLocksService.RELEASE_RETRY_TIME_LIMIT_MINUTES, 30L));
            int sleepSeconds = 10;
            int retryCount = 1;
            while (retryTimeLimit >= 0L) {
                try {
                    switch (this.type) {
                        case WRITE: {
                            this.lockEntry.writeLock().release();
                            break;
                        }
                        case READ: {
                            this.lockEntry.readLock().release();
                        }
                    }
                    break;
                }
                catch (KeeperException.ConnectionLossException ex) {
                    LOG.warn((Object)("Could not release lock: " + ex.getMessage() + ". Retry will be after " + sleepSeconds + " seconds"), ex);
                    Thread.sleep(TimeUnit.SECONDS.toMillis(sleepSeconds));
                    LOG.info("Retrying to release lock. Retry number=" + retryCount);
                    retryTimeLimit -= (long)sleepSeconds;
                    ++retryCount;
                }
            }
        }
    }
}

