/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.util.Date;
import java.util.Map;
import org.apache.oozie.AppType;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.XLog;

public class SLACalcStatus
extends SLAEvent {
    public static String SLA_ENTITYKEY_PREFIX = "sla-";
    private SLARegistrationBean regBean;
    private SLASummaryBean summary;
    private String jobStatus;
    private SLAEvent.SLAStatus slaStatus;
    private SLAEvent.EventStatus eventStatus;
    private Date actualStart;
    private Date actualEnd;
    private long actualDuration = -1L;
    private Date lastModifiedTime;
    private byte eventProcessed;
    private String jobId;
    private int retryCount = 0;
    private XLog LOG;

    public SLACalcStatus(SLARegistrationBean reg) {
        this();
        this.setSLARegistrationBean(reg);
        this.LOG = LogUtils.setLogPrefix(this.LOG, (Event)this);
    }

    public SLACalcStatus(SLASummaryBean summary, SLARegistrationBean regBean) {
        this(summary);
        this.updateSLARegistrationBean(regBean);
        this.LOG = LogUtils.setLogPrefix(this.LOG, (Event)this);
    }

    public SLACalcStatus(SLASummaryBean summary) {
        this();
        this.setActualStart(summary.getActualStart());
        this.setActualEnd(summary.getActualEnd());
        this.setActualDuration(summary.getActualDuration());
        this.setSLAStatus(summary.getSLAStatus());
        this.setJobStatus(summary.getJobStatus());
        this.setEventStatus(summary.getEventStatus());
        this.setLastModifiedTime(summary.getLastModifiedTime());
        this.setEventProcessed(summary.getEventProcessed());
        this.setId(summary.getId());
        this.summary = summary;
    }

    public SLACalcStatus(SLACalcStatus a) {
        this();
        this.setSLARegistrationBean(a.getSLARegistrationBean());
        this.setJobStatus(a.getJobStatus());
        this.setSLAStatus(a.getSLAStatus());
        this.setEventStatus(a.getEventStatus());
        this.setActualStart(a.getActualStart());
        this.setActualEnd(a.getActualEnd());
        this.setActualDuration(a.getActualDuration());
        this.setEventProcessed(a.getEventProcessed());
        this.LOG = LogUtils.setLogPrefix(this.LOG, (Event)this);
    }

    public SLACalcStatus() {
        this.setMsgType(Event.MessageType.SLA);
        this.setLastModifiedTime(new Date());
        this.LOG = XLog.getLog(((Object)((Object)this)).getClass());
    }

    public SLARegistrationBean getSLARegistrationBean() {
        return this.regBean;
    }

    public SLASummaryBean getSLASummaryBean() {
        return this.summary;
    }

    public void setSLARegistrationBean(SLARegistrationBean slaBean) {
        if (slaBean != null) {
            this.jobId = slaBean.getId();
        }
        this.regBean = slaBean;
    }

    public String getId() {
        return this.jobId;
    }

    public void setId(String id) {
        this.jobId = id;
    }

    public Date getActualStart() {
        return this.actualStart;
    }

    public void setActualStart(Date actualStart) {
        this.actualStart = actualStart;
    }

    public Date getActualEnd() {
        return this.actualEnd;
    }

    public void setActualEnd(Date actualEnd) {
        this.actualEnd = actualEnd;
    }

    public long getActualDuration() {
        return this.actualDuration;
    }

    public void setActualDuration(long actualDuration) {
        this.actualDuration = actualDuration;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(String status) {
        this.jobStatus = status;
    }

    public SLAEvent.SLAStatus getSLAStatus() {
        return this.slaStatus;
    }

    public void setSLAStatus(SLAEvent.SLAStatus slaStatus) {
        this.slaStatus = slaStatus;
    }

    public SLAEvent.EventStatus getEventStatus() {
        return this.eventStatus;
    }

    public void setEventStatus(SLAEvent.EventStatus es) {
        this.eventStatus = es;
    }

    public void setLastModifiedTime(Date lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public byte getEventProcessed() {
        return this.eventProcessed;
    }

    public void setEventProcessed(int eventProcessed) {
        this.eventProcessed = (byte)eventProcessed;
    }

    public String getParentId() {
        return this.regBean.getParentId();
    }

    public AppType getAppType() {
        return this.regBean.getAppType();
    }

    public String getAppName() {
        return this.regBean.getAppName();
    }

    public Date getNominalTime() {
        return this.regBean.getNominalTime();
    }

    public Date getExpectedStart() {
        return this.regBean.getExpectedStart();
    }

    public Date getExpectedEnd() {
        return this.regBean.getExpectedEnd();
    }

    public long getExpectedDuration() {
        return this.regBean.getExpectedDuration();
    }

    public String getNotificationMsg() {
        return this.regBean.getNotificationMsg();
    }

    public String getAlertEvents() {
        return this.regBean.getAlertEvents();
    }

    public String getAlertContact() {
        return this.regBean.getAlertContact();
    }

    public String getUpstreamApps() {
        return this.regBean.getUpstreamApps();
    }

    public String getJobData() {
        return this.regBean.getJobData();
    }

    public String getUser() {
        return this.regBean.getUser();
    }

    public String getSLAConfig() {
        return this.regBean.getSlaConfig();
    }

    public Map<String, String> getSLAConfigMap() {
        return this.regBean.getSLAConfigMap();
    }

    public Event.MessageType getMsgType() {
        return this.regBean.getMsgType();
    }

    public Date getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String getEntityKey() {
        return SLA_ENTITYKEY_PREFIX + this.getId();
    }

    public void updateSLARegistrationBean(SLARegistrationBean slaBean) {
        SLARegistrationBean reg = new SLARegistrationBean();
        reg.setNotificationMsg(slaBean.getNotificationMsg());
        reg.setUpstreamApps(slaBean.getUpstreamApps());
        reg.setAlertContact(slaBean.getAlertContact());
        reg.setAlertEvents(slaBean.getAlertEvents());
        reg.setJobData(slaBean.getJobData());
        if (slaBean.getSLAConfigMap().containsKey("oozie.sla.disable.alerts")) {
            reg.addToSLAConfigMap("oozie.sla.disable.alerts", slaBean.getSLAConfigMap().get("oozie.sla.disable.alerts"));
        }
        reg.setId(this.summary.getId());
        reg.setAppType(this.summary.getAppType());
        reg.setUser(this.summary.getUser());
        reg.setAppName(this.summary.getAppName());
        reg.setParentId(this.summary.getParentId());
        reg.setNominalTime(this.summary.getNominalTime());
        reg.setExpectedStart(this.summary.getExpectedStart());
        reg.setExpectedEnd(this.summary.getExpectedEnd());
        reg.setExpectedDuration(this.summary.getExpectedDuration());
        this.setSLARegistrationBean(reg);
    }

    int getRetryCount() {
        return this.retryCount;
    }

    void incrementRetryCount() {
        ++this.retryCount;
    }

    void resetRetryCount() {
        this.retryCount = 0;
    }
}

