/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.store;

import java.sql.Blob;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.util.db.Schema;

public class OozieSchema {
    private static String oozieDbName;
    private static final String OOZIE_VERSION = "0.1";
    public static final Map<Schema.Table, List<Schema.Column>> TABLE_COLUMNS;

    public static void setOozieDbName(String dbName) {
        oozieDbName = dbName;
    }

    public static String generateCreateTableScript(Schema.Table table, Schema.DBType dbType) {
        return Schema.generateCreateTableScript(table, dbType, TABLE_COLUMNS.get(table));
    }

    public static String getValidationQuery(String dbName) {
        return "select count(" + OozieColumn.VER_versionNumber.columnName() + ") from " + dbName + "." + OozieTable.VERSION.name().toUpperCase();
    }

    public static String generateInsertVersionScript(String dbName) {
        return "INSERT INTO " + dbName + "." + OozieTable.VERSION.name().toUpperCase() + "(" + OozieColumn.VER_versionNumber.columnName() + ") VALUES(" + OOZIE_VERSION + ")";
    }

    public static String getOozieVersion() {
        return OOZIE_VERSION;
    }

    static {
        HashMap<Schema.Table, ArrayList<OozieColumn>> tmpColumns = new HashMap<Schema.Table, ArrayList<OozieColumn>>();
        for (OozieColumn column : OozieColumn.values()) {
            ArrayList<OozieColumn> tColumns = (ArrayList<OozieColumn>)tmpColumns.get(column.table());
            if (tColumns == null) {
                tColumns = new ArrayList<OozieColumn>();
                tmpColumns.put(column.table(), tColumns);
            }
            tColumns.add(column);
        }
        TABLE_COLUMNS = Collections.unmodifiableMap(tmpColumns);
    }

    public static enum OozieColumn implements Schema.Column
    {
        PI_wfId(OozieTable.WF_PROCESS_INSTANCE, String.class, true, 100),
        PI_state(OozieTable.WF_PROCESS_INSTANCE, Blob.class, false),
        WF_id(OozieTable.WORKFLOWS, String.class, true, 100),
        WF_externalId(OozieTable.WORKFLOWS, String.class, false, 100),
        WF_appName(OozieTable.WORKFLOWS, String.class, false, 100),
        WF_appPath(OozieTable.WORKFLOWS, String.class, false, 255),
        WF_conf(OozieTable.WORKFLOWS, String.class, false),
        WF_protoActionConf(OozieTable.WORKFLOWS, String.class, false),
        WF_logToken(OozieTable.WORKFLOWS, String.class, false, 100),
        WF_status(OozieTable.WORKFLOWS, String.class, false, 100),
        WF_run(OozieTable.WORKFLOWS, Long.class, false),
        WF_lastModTime(OozieTable.WORKFLOWS, Timestamp.class, false),
        WF_createdTime(OozieTable.WORKFLOWS, Timestamp.class, false),
        WF_startTime(OozieTable.WORKFLOWS, Timestamp.class, false),
        WF_endTime(OozieTable.WORKFLOWS, Timestamp.class, false),
        WF_userName(OozieTable.WORKFLOWS, String.class, false, 100),
        WF_groupName(OozieTable.WORKFLOWS, String.class, false, 100),
        WF_authToken(OozieTable.WORKFLOWS, String.class, false),
        ACTIONS_id(OozieTable.ACTIONS, String.class, true, 100),
        ACTIONS_name(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_type(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_wfId(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_conf(OozieTable.ACTIONS, String.class, false),
        ACTIONS_status(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_externalStatus(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_errorCode(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_errorMessage(OozieTable.ACTIONS, String.class, false),
        ACTIONS_transition(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_retries(OozieTable.ACTIONS, Long.class, false),
        ACTIONS_startTime(OozieTable.ACTIONS, Timestamp.class, false),
        ACTIONS_endTime(OozieTable.ACTIONS, Timestamp.class, false),
        ACTIONS_lastCheckTime(OozieTable.ACTIONS, Timestamp.class, false),
        ACTIONS_data(OozieTable.ACTIONS, String.class, false),
        ACTIONS_externalId(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_trackerUri(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_consoleUrl(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_executionPath(OozieTable.ACTIONS, String.class, false, 255),
        ACTIONS_pending(OozieTable.ACTIONS, Boolean.class, false),
        ACTIONS_pendingAge(OozieTable.ACTIONS, Timestamp.class, false),
        ACTIONS_signalValue(OozieTable.ACTIONS, String.class, false, 100),
        ACTIONS_logToken(OozieTable.ACTIONS, String.class, false, 100),
        VER_versionNumber(OozieTable.VERSION, String.class, false, 255);

        final Schema.Table table;
        final Class<?> type;
        int length = -1;
        final boolean isPrimaryKey;

        private OozieColumn(Schema.Table table, Class<?> type, boolean isPrimaryKey) {
            this(table, type, isPrimaryKey, -1);
        }

        private OozieColumn(Schema.Table table, Class<?> type, boolean isPrimaryKey, int length) {
            this.table = table;
            this.type = type;
            this.isPrimaryKey = isPrimaryKey;
            this.length = length;
        }

        private String getName() {
            String tName = this.table.name();
            return tName + "." + this.columnName();
        }

        @Override
        public String columnName() {
            return this.name().split("_")[1].toLowerCase();
        }

        public String toString() {
            return this.getName();
        }

        @Override
        public Schema.Table table() {
            return this.table;
        }

        @Override
        public Class<?> getType() {
            return this.type;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String asLabel() {
            return this.name().toUpperCase();
        }

        @Override
        public boolean isPrimaryKey() {
            return this.isPrimaryKey;
        }
    }

    public static enum OozieIndex implements Schema.Index
    {
        IDX_WF_APPNAME(OozieColumn.WF_appName),
        IDX_WF_USER(OozieColumn.WF_userName),
        IDX_WF_GROUP(OozieColumn.WF_groupName),
        IDX_WF_STATUS(OozieColumn.WF_status),
        IDX_WF_EXTERNAL_ID(OozieColumn.WF_externalId),
        IDX_ACTIONS_BEGINTIME(OozieColumn.ACTIONS_pendingAge),
        IDX_ACTIONS_WFID(OozieColumn.ACTIONS_wfId);

        final Schema.Column column;

        private OozieIndex(Schema.Column column) {
            this.column = column;
        }

        @Override
        public Schema.Column column() {
            return this.column;
        }
    }

    public static enum OozieTable implements Schema.Table
    {
        WORKFLOWS,
        ACTIONS,
        WF_PROCESS_INSTANCE,
        VERSION;


        public String toString() {
            return oozieDbName + "." + this.name().toUpperCase();
        }
    }
}

