/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.test;

import java.net.InetAddress;
import java.util.EnumSet;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.oozie.servlet.ErrorServlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.servlet.ErrorPageErrorHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class EmbeddedServletContainer {
    private Server server;
    private String host = null;
    private int port = -1;
    private String contextPath;
    private ServletContextHandler context;

    public EmbeddedServletContainer(String contextPath) {
        this.contextPath = contextPath;
        this.server = new Server(0);
        this.context = new ServletContextHandler();
        this.context.setContextPath("/" + contextPath);
        this.context.setErrorHandler((ErrorHandler)this.getErrorHandler());
        this.addServletEndpoint("/error/*", ErrorServlet.class);
        this.server.setHandler((Handler)this.context);
    }

    public void addServletEndpoint(String servletPath, Class<? extends Servlet> servletClass, Map<String, String> initParams) {
        ServletHolder holder = new ServletHolder(servletClass);
        if (initParams != null) {
            holder.setInitParameters(initParams);
        }
        this.context.addServlet(holder, servletPath);
    }

    public void addServletEndpoint(String servletPath, Class<? extends Servlet> servletClass) {
        this.addServletEndpoint(servletPath, servletClass, null);
    }

    public void addServletEndpoint(String servletPath, Servlet servlet) {
        ServletHolder holder = new ServletHolder(servlet);
        this.context.addServlet(holder, servletPath);
    }

    public void addFilter(String filterPath, Class<? extends Filter> filterClass) {
        this.context.addFilter(new FilterHolder(filterClass), filterPath, EnumSet.of(DispatcherType.REQUEST));
    }

    public void start() throws Exception {
        this.host = InetAddress.getLocalHost().getHostName();
        ServerConnector connector = new ServerConnector(this.server, new ConnectionFactory[]{new HttpConnectionFactory(new HttpConfiguration())});
        connector.setHost(this.host);
        this.server.setConnectors(new Connector[]{connector});
        this.server.start();
        this.port = connector.getLocalPort();
        System.out.println("Running embedded servlet container at: http://" + this.host + ":" + this.port);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getContextURL() {
        return "http://" + this.host + ":" + this.port + "/" + this.contextPath;
    }

    public String getServletURL(String servletPath) {
        String path = servletPath;
        if (path.endsWith("*")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.getContextURL() + path;
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.server.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.host = null;
        this.port = -1;
    }

    private ErrorPageErrorHandler getErrorHandler() {
        ErrorPageErrorHandler errorHandler = new ErrorPageErrorHandler();
        errorHandler.addErrorPage(400, "/error");
        errorHandler.addErrorPage(401, "/error");
        errorHandler.addErrorPage(403, "/error");
        errorHandler.addErrorPage(404, "/error");
        errorHandler.addErrorPage(405, "/error");
        errorHandler.addErrorPage(409, "/error");
        errorHandler.addErrorPage(500, "/error");
        errorHandler.addErrorPage(501, "/error");
        errorHandler.addErrorPage(503, "/error");
        errorHandler.addErrorPage("java.lang.Throwable", "/error");
        return errorHandler;
    }
}

