/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticatedURL;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.client.Authenticator;
import org.apache.hadoop.security.authentication.client.KerberosAuthenticator;
import org.apache.hadoop.security.authentication.client.PseudoAuthenticator;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.XLog;

public class AuthUrlClient {
    public static final String SERVER_SERVER_AUTH_TYPE = "oozie.server.authentication.type";
    public static final String SERVER_SERVER_CONNECTION_TIMEOUT_SECONDS = "oozie.server.connection.timeout.seconds";
    private static XLog LOG = XLog.getLog(AuthUrlClient.class);
    private static Class<? extends Authenticator> AuthenticatorClass = null;
    private static String errorMsg = null;

    private static HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection conn;
        AuthenticatedURL.Token token = new AuthenticatedURL.Token();
        try {
            conn = new AuthenticatedURL(AuthenticatorClass.newInstance()).openConnection(url, token);
        }
        catch (AuthenticationException ex) {
            throw new IOException("Could not authenticate, " + ex.getMessage(), ex);
        }
        catch (InstantiationException ex) {
            throw new IOException("Could not authenticate, " + ex.getMessage(), ex);
        }
        catch (IllegalAccessException ex) {
            throw new IOException("Could not authenticate, " + ex.getMessage(), ex);
        }
        if (conn.getResponseCode() != 200) {
            throw new IOException("Unexpected response code [" + conn.getResponseCode() + "], message [" + conn.getResponseMessage() + "]");
        }
        return conn;
    }

    private static Class<? extends Authenticator> determineAuthenticatorClassType() throws Exception {
        String authName = ConfigurationService.get(SERVER_SERVER_AUTH_TYPE);
        LOG.info("Oozie server-server authentication is " + authName);
        if (authName == null) {
            throw new IOException("Authentication type must be specified: simple|kerberos|<class>");
        }
        String authClassName = (authName = authName.trim()).equals("simple") ? PseudoAuthenticator.class.getName() : (authName.equals("kerberos") ? KerberosAuthenticator.class.getName() : authName);
        Class<?> authClass = Thread.currentThread().getContextClassLoader().loadClass(authClassName);
        return authClass;
    }

    public static BufferedReader callServer(String server) throws IOException {
        if (AuthenticatorClass == null) {
            throw new IOException(errorMsg);
        }
        final URL url = new URL(server);
        BufferedReader reader = null;
        try {
            reader = (BufferedReader)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<BufferedReader>(){

                @Override
                public BufferedReader run() throws IOException {
                    HttpURLConnection conn = AuthUrlClient.getConnection(url);
                    conn.setConnectTimeout(ConfigurationService.getInt(AuthUrlClient.SERVER_SERVER_CONNECTION_TIMEOUT_SECONDS, 180));
                    BufferedReader reader = null;
                    if (conn.getResponseCode() == 200) {
                        InputStream is = conn.getInputStream();
                        reader = new BufferedReader(new InputStreamReader(is));
                    }
                    return reader;
                }
            });
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
        return reader;
    }

    public static String getQueryParamString(Map<String, String[]> params) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        if (params == null || params.isEmpty()) {
            return "";
        }
        for (String key : params.keySet()) {
            if (key.isEmpty() || params.get(key).length <= 0) continue;
            stringBuilder.append("&");
            String value = params.get(key)[0];
            stringBuilder.append(key);
            stringBuilder.append("=");
            stringBuilder.append(URLEncoder.encode(value, "UTF-8"));
        }
        return stringBuilder.toString();
    }

    static {
        try {
            AuthenticatorClass = AuthUrlClient.determineAuthenticatorClassType();
        }
        catch (Exception e) {
            errorMsg = e.getMessage();
        }
    }
}

