/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XConfiguration;

public class JobUtils {
    public static void normalizeAppPath(String user, String group, Configuration conf) throws IOException {
        ParamChecker.notNull(user, "user");
        if (conf.get("oozie.proxysubmission") != null) {
            return;
        }
        String wfPathStr = conf.get("oozie.wf.application.path");
        String coordPathStr = conf.get("oozie.coord.application.path");
        String bundlePathStr = conf.get("oozie.bundle.application.path");
        String appPathStr = wfPathStr != null ? wfPathStr : (coordPathStr != null ? coordPathStr : bundlePathStr);
        FileSystem fs = null;
        try {
            URI uri = new Path(appPathStr).toUri();
            HadoopAccessorService has = Services.get().get(HadoopAccessorService.class);
            Configuration fsConf = has.createConfiguration(uri.getAuthority());
            fs = has.createFileSystem(user, uri, fsConf);
        }
        catch (HadoopAccessorException ex) {
            throw new IOException(ex.getMessage());
        }
        Path appPath = new Path(appPathStr);
        String normalizedAppPathStr = appPathStr;
        if (!fs.exists(appPath)) {
            throw new IOException("Error: " + appPathStr + " does not exist");
        }
        if (wfPathStr != null) {
            conf.set("oozie.wf.application.path", normalizedAppPathStr);
        } else if (coordPathStr != null) {
            conf.set("oozie.coord.application.path", normalizedAppPathStr);
        } else if (bundlePathStr != null) {
            conf.set("oozie.bundle.application.path", normalizedAppPathStr);
        }
    }

    public static Map<String, String> parseChangeValue(String changeValue) throws CommandException {
        String[] tokens;
        if (changeValue == null || changeValue.trim().equalsIgnoreCase("")) {
            throw new CommandException(ErrorCode.E1015, "change value can not be empty string or null");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String token : tokens = changeValue.split(";")) {
            if (!token.contains("=")) {
                throw new CommandException(ErrorCode.E1015, changeValue, "change value must be name=value pair or name=(empty string)");
            }
            String[] pair = token.split("=");
            String key = pair[0];
            if (map.containsKey(key)) {
                throw new CommandException(ErrorCode.E1015, changeValue, "can not specify repeated change values on " + key);
            }
            if (pair.length == 2) {
                map.put(key, pair[1]);
                continue;
            }
            if (pair.length == 1) {
                map.put(key, "");
                continue;
            }
            throw new CommandException(ErrorCode.E1015, changeValue, "elements on " + key + " must be name=value pair or name=(empty string)");
        }
        return map;
    }

    public static void addFileToClassPath(Path file, Configuration conf, FileSystem fs) throws IOException {
        if (fs == null) {
            Configuration defaultConf = Services.get().get(HadoopAccessorService.class).createConfiguration(conf.get("yarn.resourcemanager.address"));
            XConfiguration.copy(conf, defaultConf);
            fs = file.getFileSystem(defaultConf);
        }
        DistributedCache.addFileToClassPath((Path)file, (Configuration)conf, (FileSystem)fs);
    }

    public static String getRetryKey(WorkflowActionBean wfAction, String key) {
        return "retry." + wfAction.getUserRetryCount() + "." + key;
    }

    public static String getRetryKey(String key, int retry) {
        return "retry." + retry + "." + key;
    }
}

