/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import com.codahale.metrics.Counter;
import com.codahale.metrics.ExponentiallyDecayingReservoir;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.JmxReporter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Timer;
import com.codahale.metrics.ganglia.GangliaReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.json.MetricsModule;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import info.ganglia.gmetric4j.gmetric.GMetric;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.XLog;

public class MetricsInstrumentation
extends Instrumentation {
    private final MetricRegistry metricRegistry;
    private transient ObjectMapper jsonMapper;
    private ScheduledExecutorService scheduler;
    private final LoadingCache<String, Counter> counters;
    private final Map<String, Gauge> gauges;
    private final LoadingCache<String, Timer> timers;
    private final Map<String, Histogram> histograms;
    private Lock timersLock;
    private Lock gaugesLock;
    private Lock countersLock;
    private Lock histogramsLock;
    public static final String EXTERNAL_MONITORING_ENABLE = "oozie.external_monitoring.enable";
    public static final String EXTERNAL_MONITORING_TYPE = "oozie.external_monitoring.type";
    public static final String EXTERNAL_MONITORING_ADDRESS = "oozie.external_monitoring.address";
    public static final String EXTERNAL_MONITORING_PREFIX = "oozie.external_monitoring.metricPrefix";
    public static final String EXTERNAL_MONITORING_INTERVAL = "oozie.external_monitoring.reporterIntervalSecs";
    public static final String JMX_MONITORING_ENABLE = "oozie.jmx_monitoring.enable";
    public static final String GRAPHITE = "graphite";
    public static final String GANGLIA = "ganglia";
    private String metricsAddress;
    private String metricsHost;
    private String metricsPrefix;
    private String metricsServerName;
    private int metricsPort;
    private GraphiteReporter graphiteReporter = null;
    private GangliaReporter gangliaReporter = null;
    private JmxReporter jmxReporter = null;
    private long metricsReportIntervalSec;
    private boolean isExternalMonitoringEnabled;
    private boolean isJMXMonitoringEnabled;
    private static final TimeUnit RATE_UNIT = TimeUnit.MILLISECONDS;
    private static final TimeUnit DURATION_UNIT = TimeUnit.MILLISECONDS;
    protected XLog LOG = XLog.getLog(this.getClass());

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MetricsInstrumentation() {
        this.metricRegistry = new MetricRegistry();
        this.isExternalMonitoringEnabled = ConfigurationService.getBoolean(EXTERNAL_MONITORING_ENABLE);
        if (this.isExternalMonitoringEnabled) {
            this.metricsServerName = ConfigurationService.get(EXTERNAL_MONITORING_TYPE);
            if (this.metricsServerName == null) throw new RuntimeException("Metrics Server Name is not specified");
            String modifiedServerName = this.metricsServerName.trim().toLowerCase();
            if (!modifiedServerName.equals(GRAPHITE) && !modifiedServerName.equals(GANGLIA)) throw new RuntimeException("Metrics Server Name should be either graphite or ganglia");
            this.metricsAddress = ConfigurationService.get(EXTERNAL_MONITORING_ADDRESS);
            this.metricsPrefix = ConfigurationService.get(EXTERNAL_MONITORING_PREFIX);
            this.metricsReportIntervalSec = ConfigurationService.getLong(EXTERNAL_MONITORING_INTERVAL);
            this.LOG.debug("Publishing external monitoring to [{0}]  at host [{1}] every [{2}] seconds with prefix [{3}]", this.metricsServerName, this.metricsAddress, this.metricsReportIntervalSec, this.metricsPrefix);
            try {
                URL url = new URL(this.metricsAddress);
                this.metricsHost = url.getHost();
                this.metricsPort = url.getPort();
            }
            catch (MalformedURLException e) {
                this.LOG.error((Object)"Exception, ", e);
            }
            if (modifiedServerName.equals(GRAPHITE)) {
                Graphite graphite = new Graphite(new InetSocketAddress(this.metricsHost, this.metricsPort));
                this.graphiteReporter = GraphiteReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(this.metricsPrefix).convertDurationsTo(TimeUnit.SECONDS).filter(MetricFilter.ALL).build(graphite);
                this.graphiteReporter.start(this.metricsReportIntervalSec, TimeUnit.SECONDS);
            }
            if (modifiedServerName.equals(GANGLIA)) {
                GMetric ganglia;
                try {
                    ganglia = new GMetric(this.metricsHost, this.metricsPort, GMetric.UDPAddressingMode.MULTICAST, 1);
                }
                catch (IOException e) {
                    this.LOG.error((Object)"Exception, ", e);
                    throw new RuntimeException(e);
                }
                this.gangliaReporter = GangliaReporter.forRegistry((MetricRegistry)this.metricRegistry).prefixedWith(this.metricsPrefix).convertRatesTo(TimeUnit.SECONDS).convertDurationsTo(TimeUnit.MILLISECONDS).build(ganglia);
                this.gangliaReporter.start(this.metricsReportIntervalSec, TimeUnit.SECONDS);
            }
        }
        this.timersLock = new ReentrantLock();
        this.gaugesLock = new ReentrantLock();
        this.countersLock = new ReentrantLock();
        this.histogramsLock = new ReentrantLock();
        this.jsonMapper = new ObjectMapper().registerModule((Module)new MetricsModule(RATE_UNIT, DURATION_UNIT, false));
        MemoryUsageGaugeSet memorySet = new MemoryUsageGaugeSet();
        for (String key : memorySet.getMetrics().keySet()) {
            this.metricRegistry.register(MetricRegistry.name((String)"jvm", (String[])new String[]{"memory", key}), (Metric)memorySet.getMetrics().get(key));
        }
        this.counters = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Counter>(){

            public Counter load(String key) throws Exception {
                Counter counter = new Counter();
                MetricsInstrumentation.this.metricRegistry.register(key, (Metric)counter);
                return counter;
            }
        });
        this.timers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, Timer>(){

            public Timer load(String key) throws Exception {
                Timer timer = new Timer((Reservoir)new ExponentiallyDecayingReservoir());
                MetricsInstrumentation.this.metricRegistry.register(key, (Metric)timer);
                return timer;
            }
        });
        this.gauges = new ConcurrentHashMap<String, Gauge>();
        this.histograms = new ConcurrentHashMap<String, Histogram>();
        this.isJMXMonitoringEnabled = ConfigurationService.getBoolean(JMX_MONITORING_ENABLE);
        if (!this.isJMXMonitoringEnabled) return;
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).build();
        this.jmxReporter.start();
    }

    @Override
    public void stop() {
        if (this.graphiteReporter != null) {
            try {
                this.graphiteReporter.report();
            }
            finally {
                this.graphiteReporter.stop();
            }
        }
        if (this.gangliaReporter != null) {
            try {
                this.gangliaReporter.report();
            }
            finally {
                this.gangliaReporter.stop();
            }
        }
        if (this.jmxReporter != null) {
            this.jmxReporter.stop();
        }
    }

    @Override
    public void addCron(String group, String name, Instrumentation.Cron cron) {
        String key = MetricRegistry.name((String)group, (String[])new String[]{name, "timer"});
        try {
            this.timersLock.lock();
            Timer timer = (Timer)this.timers.get((Object)key);
            timer.update(cron.getOwn(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        finally {
            this.timersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVariable(String group, String name, final Instrumentation.Variable variable) {
        Gauge gauge = new Gauge(){

            public Object getValue() {
                return variable.getValue();
            }
        };
        String key = MetricRegistry.name((String)group, (String[])new String[]{name});
        try {
            this.gaugesLock.lock();
            this.gauges.put(key, gauge);
            if (this.metricRegistry.getGauges().containsKey(key)) {
                XLog.getLog(MetricsInstrumentation.class).debug("A Variable with name [" + key + "] already exists.  The old Variable will be overwritten, but this is not recommended");
                this.metricRegistry.remove(key);
            }
            this.metricRegistry.register(key, (Metric)gauge);
        }
        finally {
            this.gaugesLock.unlock();
        }
    }

    @Override
    public void incr(String group, String name, long count) {
        String key = MetricRegistry.name((String)group, (String[])new String[]{name});
        try {
            this.countersLock.lock();
            ((Counter)this.counters.get((Object)key)).inc(count);
        }
        catch (ExecutionException ee) {
            throw new RuntimeException(ee);
        }
        finally {
            this.countersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSampler(String group, String name, int period, int interval, Instrumentation.Variable<Long> variable) {
        if (this.scheduler == null) {
            throw new IllegalStateException("scheduler not set, cannot sample");
        }
        Histogram histogram = new Histogram((Reservoir)new ExponentiallyDecayingReservoir());
        Sampler sampler = new Sampler(variable, histogram);
        this.scheduler.scheduleAtFixedRate(sampler, 0L, interval, TimeUnit.SECONDS);
        String key = MetricRegistry.name((String)group, (String[])new String[]{name, "histogram"});
        try {
            this.histogramsLock.lock();
            this.histograms.put(key, histogram);
            if (this.metricRegistry.getHistograms().containsKey(key)) {
                XLog.getLog(MetricsInstrumentation.class).debug("A Sampler with name [" + key + "] already exists.  The old Sampler will be overwritten, but this is not recommended");
                this.metricRegistry.remove(key);
            }
            this.metricRegistry.register(key, (Metric)histogram);
        }
        finally {
            this.histogramsLock.unlock();
        }
    }

    @Override
    public void setScheduler(ScheduledExecutorService scheduler) {
        this.scheduler = scheduler;
    }

    @Override
    public String toString() {
        try {
            return this.jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this.metricRegistry);
        }
        catch (JsonProcessingException jpe) {
            throw new RuntimeException(jpe);
        }
    }

    public void writeJSONResponse(OutputStream os) throws IOException {
        this.jsonMapper.writer().writeValue(os, (Object)this.metricRegistry);
    }

    @VisibleForTesting
    MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public Map<String, Map<String, Map<String, Object>>> getAll() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Long>>> getCounters() {
        ConcurrentMap countersAsMap = this.counters.asMap();
        HashMap<String, Map<String, Instrumentation.Element<Long>>> countersAsDeepMap = new HashMap<String, Map<String, Instrumentation.Element<Long>>>();
        for (Map.Entry counterEntry : countersAsMap.entrySet()) {
            String groupAndName = (String)counterEntry.getKey();
            Counter value = (Counter)counterEntry.getValue();
            String group = groupAndName.substring(0, groupAndName.indexOf("."));
            String name = groupAndName.substring(groupAndName.indexOf(".") + 1);
            if (!countersAsDeepMap.containsKey(group)) {
                countersAsDeepMap.put(group, new HashMap());
            }
            Instrumentation.Counter counter = new Instrumentation.Counter();
            counter.set(value.getCount());
            ((Map)countersAsDeepMap.get(group)).put(name, counter);
        }
        return countersAsDeepMap;
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Double>>> getSamplers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Instrumentation.Timer>>> getTimers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Map<String, Map<String, Instrumentation.Element<Instrumentation.Variable>>> getVariables() {
        throw new UnsupportedOperationException();
    }

    public static class Sampler
    implements Runnable {
        private final Instrumentation.Variable<Long> variable;
        private final Histogram histogram;

        public Sampler(Instrumentation.Variable<Long> variable, Histogram histogram) {
            this.variable = variable;
            this.histogram = histogram;
        }

        @Override
        public void run() {
            this.histogram.update(((Long)this.variable.getValue()).longValue());
        }
    }
}

