/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.oozie.util.LogLine;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;

public class TimestampedMessageParser {
    static final String SYSTEM_LINE_SEPARATOR = System.getProperty("line.separator");
    protected BufferedReader reader;
    private LogLine nextLine = null;
    private String lastTimestamp = null;
    private XLogFilter filter;
    private boolean empty = false;
    private String lastMessage = null;
    private boolean patternMatched = false;
    public int count = 0;
    private Pattern splitPattern = null;

    public TimestampedMessageParser(BufferedReader reader, XLogFilter filter) {
        this.reader = reader;
        this.filter = filter;
        if (filter == null) {
            filter = new XLogFilter();
        }
        filter.constructPattern();
        String regEx = "(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)\\s+(\\w+)\\s+" + filter.getFilterPattern().pattern();
        this.splitPattern = Pattern.compile(regEx);
    }

    public boolean increment() throws IOException {
        if (this.empty) {
            return false;
        }
        StringBuilder message = new StringBuilder();
        if (this.nextLine == null) {
            this.nextLine = this.parseNextLogLine();
            if (this.nextLine == null || this.nextLine.getLine() == null) {
                this.empty = true;
                return false;
            }
        }
        this.lastTimestamp = this.parseTimestamp(this.nextLine);
        String nextTimestamp = null;
        while (nextTimestamp == null) {
            message.append(this.nextLine.getLine()).append(SYSTEM_LINE_SEPARATOR);
            this.nextLine = this.parseNextLogLine();
            if (this.nextLine != null && this.nextLine.getLine() != null) {
                nextTimestamp = this.parseTimestamp(this.nextLine);
                continue;
            }
            this.empty = true;
            nextTimestamp = "";
        }
        this.lastMessage = message.toString();
        return true;
    }

    public String getLastTimestamp() {
        return this.lastTimestamp;
    }

    public String getLastMessage() {
        return this.lastMessage;
    }

    public void closeReader() throws IOException {
        this.reader.close();
    }

    protected LogLine parseNextLogLine() throws IOException {
        String line;
        LogLine logLine = new LogLine();
        while ((line = this.reader.readLine()) != null) {
            logLine.setLine(line);
            logLine.setLogParts(null);
            this.filter.splitLogMessage(logLine, this.splitPattern);
            boolean bl = this.patternMatched = logLine.getMatchedPattern() == LogLine.MATCHED_PATTERN.NONE ? this.patternMatched : this.filter.splitsMatches(logLine);
            if (!this.patternMatched) continue;
            if (this.filter.getLogLimit() != -1 && logLine.getLogParts() != null) {
                if (this.count >= this.filter.getLogLimit()) {
                    return null;
                }
                ++this.count;
            }
            if (logLine.getLogParts() != null && this.filter.getEndDate() != null && logLine.getLogParts().get(0).substring(0, 19).compareTo(this.filter.getFormattedEndDate()) > 0) {
                return null;
            }
            return logLine;
        }
        logLine.setLine(null);
        return logLine;
    }

    private String parseTimestamp(LogLine logLine) {
        String timestamp = null;
        if (logLine != null && logLine.getLogParts() != null && logLine.getLogParts().size() > 0) {
            timestamp = logLine.getLogParts().get(0);
        }
        return timestamp;
    }

    public void processRemaining(Writer writer, XLogStreamer logStreamer) throws IOException {
        while (this.increment()) {
            writer.write(this.lastMessage);
            if (!logStreamer.shouldFlushOutput(this.lastMessage.length())) continue;
            writer.flush();
        }
        writer.flush();
    }

    protected ArrayList<String> splitLogMessage(String line) {
        return this.filter.splitLogMessage(line);
    }
}

