/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util.db;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.apache.commons.dbcp.SQLNestedException;

public class BasicDataSourceWrapper
extends BasicDataSource {
    protected ConnectionFactory createConnectionFactory() throws SQLException {
        String user;
        Class<?> driverFromCCL;
        block16: {
            driverFromCCL = null;
            if (this.driverClassName != null) {
                try {
                    try {
                        if (this.driverClassLoader == null) {
                            driverFromCCL = Class.forName(this.driverClassName);
                            break block16;
                        }
                        driverFromCCL = Class.forName(this.driverClassName, true, this.driverClassLoader);
                    }
                    catch (ClassNotFoundException cnfe) {
                        driverFromCCL = Thread.currentThread().getContextClassLoader().loadClass(this.driverClassName);
                    }
                }
                catch (Throwable t) {
                    String message = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                    this.logWriter.println(message);
                    t.printStackTrace(this.logWriter);
                    throw new SQLNestedException(message, t);
                }
            }
        }
        Driver driver = null;
        try {
            if (driverFromCCL == null) {
                driver = DriverManager.getDriver(this.url);
            } else {
                driver = (Driver)driverFromCCL.newInstance();
                if (!driver.acceptsURL(this.url)) {
                    throw new SQLException("No suitable driver", "08001");
                }
            }
        }
        catch (Throwable t) {
            String message = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLNestedException(message, t);
        }
        if (this.validationQuery == null) {
            this.setTestOnBorrow(false);
            this.setTestOnReturn(false);
            this.setTestWhileIdle(false);
        }
        if ((user = this.username) != null) {
            this.connectionProperties.put("user", user);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        String pwd = this.password;
        if (pwd != null) {
            this.connectionProperties.put("password", pwd);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driver, this.url, this.connectionProperties);
        return driverConnectionFactory;
    }
}

