/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.formats.impl.orc;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.provider.UriParser;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.big.data.kettle.plugins.formats.impl.parquet.input.VFSScheme;
import org.pentaho.di.core.SwtUniversalImage;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public abstract class BaseOrcStepDialog<T extends BaseStepMeta>
extends BaseStepDialog
implements StepDialogInterface {
    protected final Class<?> PKG = ((Object)((Object)this)).getClass();
    protected final Class<?> BPKG = BaseOrcStepDialog.class;
    protected T meta;
    protected ModifyListener lsMod;
    public static final int MARGIN = 15;
    public static final int FIELDS_SEP = 10;
    public static final int FIELD_LABEL_SEP = 5;
    public static final int FIELD_SMALL = 150;
    public static final int FIELD_MEDIUM = 250;
    public static final int FIELD_LARGE = 350;
    private static final String ELLIPSIS = "...";
    private static final int TABLE_ITEM_MARGIN = 2;
    private static final int TOOLTIP_SHOW_DELAY = 350;
    private static final int TOOLTIP_HIDE_DELAY = 2000;
    private static final String DEFAULT_LOCAL_PATH = "file:///C:/";
    protected static final int VAR_EXTRA_WIDTH = GUIResource.getInstance().getImageVariable().getBounds().width;
    protected static final String[] FILES_FILTERS = new String[]{"*.*"};
    protected static final String[] fileFilterNames = new String[]{BaseMessages.getString((String)"System.FileType.AllFiles")};
    private static final String HDFS_SCHEME = "hdfs";
    protected Image icon;
    protected TextVar wPath;
    protected Button wbBrowse;
    protected VFSScheme selectedVFSScheme;
    protected CCombo wLocation;

    public BaseOrcStepDialog(Shell parent, T in, TransMeta transMeta, String sname) {
        super(parent, in, transMeta, sname);
        this.meta = in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 2160);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.meta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseOrcStepDialog.this.meta.setChanged();
            }
        };
        this.changed = this.meta.hasChanged();
        this.createUI();
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                BaseOrcStepDialog.this.cancel();
            }
        });
        int height = Math.max(this.getMinHeight((Composite)this.shell, this.getWidth()), this.getHeight());
        this.shell.setMinimumSize(this.getWidth(), height);
        this.shell.setSize(this.getWidth(), height);
        this.getData(this.meta);
        this.updateLocation();
        this.shell.open();
        this.wStepname.setFocus();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected abstract void createUI();

    protected Control createFooter(Composite shell) {
        this.wCancel = new Button(shell, 8);
        this.wCancel.setText(this.getMsg("System.Button.Cancel"));
        this.wCancel.addListener(13, this.lsCancel);
        new FD((Control)this.wCancel).right(100, 0).bottom(100, 0).apply();
        this.wOK = new Button(shell, 8);
        this.wOK.setText(this.getMsg("System.Button.OK"));
        this.wOK.addListener(13, this.lsOK);
        new FD((Control)this.wOK).right((Control)this.wCancel, -5).bottom(100, 0).apply();
        this.lsPreview = this.getPreview();
        if (this.lsPreview != null) {
            this.wPreview = new Button(shell, 8);
            this.wPreview.setText(this.getBaseMsg("BaseStepDialog.Preview"));
            this.wPreview.pack();
            this.wPreview.addListener(13, this.lsPreview);
            int offset = this.wPreview.getBounds().width / 2;
            new FD((Control)this.wPreview).left(50, -offset).bottom(100, 0).apply();
        }
        return this.wCancel;
    }

    protected void cancel() {
        this.stepname = null;
        this.meta.setChanged(this.changed);
        this.dispose();
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.meta, false);
        this.dispose();
    }

    protected abstract String getStepTitle();

    protected abstract void getData(T var1);

    protected abstract void getInfo(T var1, boolean var2);

    protected abstract int getWidth();

    protected abstract int getHeight();

    protected abstract Listener getPreview();

    protected Label createHeader() {
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.getStepTitle());
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                BaseOrcStepDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                BaseOrcStepDialog.this.cancel();
            }
        };
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(this.getBaseMsg("BaseStepDialog.StepName"));
        this.props.setLook((Control)this.wlStepname);
        new FD((Control)this.wlStepname).left(0, 0).top(0, 0).apply();
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        new FD((Control)this.wStepname).left(0, 0).top((Control)this.wlStepname, 5).width(250).rright().apply();
        Label separator = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.height = 2;
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wStepname, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        separator.setLayoutData((Object)fdSpacer);
        this.addIcon((Control)separator);
        return separator;
    }

    protected void addIcon(Control bottom) {
        Label wicon = new Label((Composite)this.shell, 131072);
        String stepId = this.meta.getParentStepMeta().getStepID();
        wicon.setImage(((SwtUniversalImage)GUIResource.getInstance().getImagesSteps().get(stepId)).getAsBitmapForSize((Device)this.shell.getDisplay(), 48, 48));
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        this.props.setLook((Control)wicon);
    }

    protected Control addFileWidgets(Control prev) {
        Label wlLocation = new Label((Composite)this.shell, 131072);
        wlLocation.setText(this.getBaseMsg("OrcDialog.Location.Label"));
        this.props.setLook((Control)wlLocation);
        new FD((Control)wlLocation).left(0, 0).top(prev, 15).apply();
        this.wLocation = new CCombo((Composite)this.shell, 2056);
        try {
            List<VFSScheme> availableVFSSchemes = this.getAvailableVFSSchemes();
            availableVFSSchemes.forEach(scheme -> this.wLocation.add(scheme.getSchemeName()));
            this.wLocation.addListener(13, event -> {
                this.selectedVFSScheme = (VFSScheme)availableVFSSchemes.get(this.wLocation.getSelectionIndex());
                this.wPath.setText("");
            });
            if (!availableVFSSchemes.isEmpty()) {
                this.wLocation.select(0);
                this.selectedVFSScheme = availableVFSSchemes.get(this.wLocation.getSelectionIndex());
            }
        }
        catch (KettleFileException ex) {
            this.log.logError(this.getBaseMsg("OrcDialog.FileBrowser.KettleFileException"));
        }
        catch (FileSystemException ex) {
            this.log.logError(this.getBaseMsg("OrcDialog.FileBrowser.FileSystemException"));
        }
        this.wLocation.addModifyListener(this.lsMod);
        new FD((Control)this.wLocation).left(0, 0).top((Control)wlLocation, 5).width(150).apply();
        Label wlPath = new Label((Composite)this.shell, 131072);
        wlPath.setText(this.getBaseMsg("OrcDialog.Filename.Label"));
        this.props.setLook((Control)wlPath);
        new FD((Control)wlPath).left(0, 0).top((Control)this.wLocation, 10).apply();
        this.wPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wPath.addModifyListener(event -> {
            if (this.wPreview != null) {
                this.wPreview.setEnabled(!Utils.isEmpty((CharSequence)this.wPath.getText()));
            }
        });
        this.props.setLook((Control)this.wPath);
        this.wPath.addModifyListener(this.lsMod);
        new FD((Control)this.wPath).left(0, 0).top((Control)wlPath, 5).width(350 + VAR_EXTRA_WIDTH).rright().apply();
        this.wbBrowse = new Button((Composite)this.shell, 8);
        this.props.setLook((Control)this.wbBrowse);
        this.wbBrowse.setText(this.getMsg("System.Button.Browse"));
        this.wbBrowse.addListener(13, event -> this.browseForFileInputPath());
        int bOffset = (this.wbBrowse.computeSize((int)-1, (int)-1, (boolean)false).y - this.wPath.computeSize((int)-1, (int)-1, (boolean)false).y) / 2;
        new FD((Control)this.wbBrowse).left((Control)this.wPath, 5).top((Control)wlPath, 5 - bOffset).apply();
        return this.wPath;
    }

    protected void browseForFileInputPath() {
        try {
            String filePath;
            String fileName;
            VfsFileChooserDialog fileChooserDialog;
            String path = this.transMeta.environmentSubstitute(this.wPath.getText());
            if (Utils.isEmpty((CharSequence)path)) {
                fileChooserDialog = this.getVfsFileChooserDialog(null, null);
                fileName = this.selectedVFSScheme.getScheme() + "://";
            } else {
                FileObject initialFile = this.getInitialFile(this.wPath.getText());
                FileObject rootFile = initialFile.getFileSystem().getRoot();
                fileChooserDialog = this.getVfsFileChooserDialog(rootFile, initialFile);
                fileName = null;
            }
            FileObject selectedFile = fileChooserDialog.open(this.shell, null, this.selectedVFSScheme.getScheme(), true, fileName, FILES_FILTERS, fileFilterNames, true, 2, true, true);
            if (selectedFile != null && !DEFAULT_LOCAL_PATH.equals(filePath = selectedFile.getURL().toString())) {
                this.wPath.setText(filePath);
                this.updateLocation();
            }
        }
        catch (KettleFileException ex) {
            this.log.logError(this.getBaseMsg("OrcDialog.FileBrowser.KettleFileException"));
        }
        catch (FileSystemException ex) {
            this.log.logError(this.getBaseMsg("OrcDialog.FileBrowser.FileSystemException"));
        }
    }

    private void updateLocation() {
        String scheme;
        String pathText = this.wPath.getText();
        String string = scheme = pathText.isEmpty() ? HDFS_SCHEME : UriParser.extractScheme((String)pathText);
        if (scheme != null) {
            try {
                List<VFSScheme> availableVFSSchemes = this.getAvailableVFSSchemes();
                for (int i = 0; i < availableVFSSchemes.size(); ++i) {
                    VFSScheme s = availableVFSSchemes.get(i);
                    if (!scheme.equals(s.getScheme())) continue;
                    this.wLocation.select(i);
                    this.selectedVFSScheme = s;
                }
            }
            catch (KettleFileException ex) {
                this.log.logError(this.getBaseMsg("OrcDialog.FileBrowser.KettleFileException"));
            }
            catch (FileSystemException ex) {
                this.log.logError(this.getBaseMsg("OrcDialog.FileBrowser.FileSystemException"));
            }
        }
        if (this.wPreview != null) {
            this.wPreview.setEnabled(!pathText.isEmpty());
        }
    }

    protected String getBaseMsg(String key) {
        return BaseMessages.getString(this.BPKG, (String)key, (String[])new String[0]);
    }

    protected String getMsg(String key) {
        return BaseMessages.getString(this.PKG, (String)key, (String[])new String[0]);
    }

    protected FileObject getInitialFile(String filePath) throws KettleFileException {
        String fileName;
        FileObject initialFile = null;
        if (filePath != null && !filePath.isEmpty() && (fileName = this.transMeta.environmentSubstitute(filePath)) != null && !fileName.isEmpty()) {
            initialFile = KettleVFS.getFileObject((String)fileName);
        }
        if (initialFile == null) {
            initialFile = KettleVFS.getFileObject((String)Spoon.getInstance().getLastFileOpened());
        }
        return initialFile;
    }

    protected List<VFSScheme> getAvailableVFSSchemes() throws KettleFileException, FileSystemException {
        VfsFileChooserDialog fileChooserDialog = this.getVfsFileChooserDialog(null, null);
        List customVfsUiPanels = fileChooserDialog.getCustomVfsUiPanels();
        ArrayList<VFSScheme> vfsSchemes = new ArrayList<VFSScheme>();
        customVfsUiPanels.forEach(vfsPanel -> {
            VFSScheme scheme = new VFSScheme(vfsPanel.getVfsScheme(), vfsPanel.getVfsSchemeDisplayText());
            vfsSchemes.add(scheme);
        });
        return vfsSchemes;
    }

    protected VfsFileChooserDialog getVfsFileChooserDialog(FileObject rootFile, FileObject initialFile) throws KettleFileException, FileSystemException {
        return this.getSpoon().getVfsFileChooserDialog(rootFile, initialFile);
    }

    private Spoon getSpoon() {
        return Spoon.getInstance();
    }

    protected int getMinHeight(Composite comp, int minWidth) {
        comp.pack();
        return comp.computeSize((int)minWidth, (int)-1).y;
    }

    protected void setTruncatedColumn(Table table, final int targetColumn) {
        table.addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if (event.index == targetColumn) {
                    event.detail &= 0xFFFFFFEF;
                }
            }
        });
        table.addListener(42, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                int colIdx = event.index;
                if (colIdx == targetColumn) {
                    String contents = item.getText(colIdx);
                    if (Utils.isEmpty((CharSequence)contents)) {
                        return;
                    }
                    Point size = event.gc.textExtent(contents);
                    int targetWidth = item.getBounds((int)colIdx).width;
                    int yOffset = Math.max(0, (event.height - size.y) / 2);
                    if (size.x > targetWidth) {
                        contents = BaseOrcStepDialog.this.shortenText(event.gc, contents, targetWidth);
                    }
                    event.gc.drawText(contents, event.x + 2, event.y + yOffset, true);
                }
            }
        });
    }

    protected void addColumnTooltip(final Table table, final int columnIndex) {
        final DefaultToolTip toolTip = new DefaultToolTip((Control)table, 1, true);
        toolTip.setRespectMonitorBounds(true);
        toolTip.setRespectDisplayBounds(true);
        toolTip.setPopupDelay(350);
        toolTip.setHideDelay(2000);
        toolTip.setShift(new Point(5, 5));
        table.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                String contents;
                Point coord = new Point(e.x, e.y);
                TableItem item = table.getItem(coord);
                if (item != null && item.getBounds(columnIndex).contains(coord) && !Utils.isEmpty((CharSequence)(contents = item.getText(columnIndex)))) {
                    toolTip.setText(contents);
                    toolTip.show(coord);
                    return;
                }
                toolTip.hide();
            }

            public void mouseExit(MouseEvent e) {
                toolTip.hide();
            }
        });
    }

    protected String shortenText(GC gc, String text, int targetWidth) {
        if (Utils.isEmpty((CharSequence)text)) {
            return "";
        }
        int textWidth = gc.textExtent((String)text).x;
        int extra = gc.textExtent((String)ELLIPSIS).x + 4;
        if (targetWidth <= extra || textWidth <= targetWidth) {
            return text;
        }
        int len = text.length();
        for (int chomp = 1; chomp < len && textWidth + extra >= targetWidth; ++chomp) {
            text = text.substring(0, text.length() - 1);
            textWidth = gc.textExtent((String)text).x;
        }
        return text + ELLIPSIS;
    }

    private int getControlOffset(Control control, int controlWidth) {
        return this.getWidth() - this.getMarginWidths(control) - controlWidth;
    }

    private int getMarginWidths(Control control) {
        int extraWidth = 0;
        Composite parent = control.getParent();
        while (!parent.equals(this.getParent())) {
            extraWidth += parent.computeTrim((int)0, (int)0, (int)0, (int)0).width;
            if (parent.getLayout() instanceof FormLayout) {
                extraWidth += 2 * ((FormLayout)parent.getLayout()).marginWidth;
            }
            parent = parent.getParent();
        }
        return extraWidth;
    }

    protected void setIntegerOnly(TextVar textVar) {
        textVar.getTextWidget().addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (!(StringUtil.isEmpty((String)e.text) || StringUtil.isVariable((String)e.text) || StringUtil.IsInteger((String)e.text))) {
                    e.doit = false;
                }
            }
        });
    }

    protected class FD {
        private final Control control;
        private final FormData fd;

        public FD(Control control) {
            this.control = control;
            BaseOrcStepDialog.this.props.setLook(control);
            this.fd = new FormData();
        }

        public FD width(int width) {
            this.fd.width = width;
            return this;
        }

        public FD height(int height) {
            this.fd.height = height;
            return this;
        }

        public FD top(int numerator, int offset) {
            this.fd.top = new FormAttachment(numerator, offset);
            return this;
        }

        public FD top(Control control, int offset) {
            this.fd.top = new FormAttachment(control, offset);
            return this;
        }

        public FD bottom(int numerator, int offset) {
            this.fd.bottom = new FormAttachment(numerator, offset);
            return this;
        }

        public FD bottom(Control control, int offset) {
            this.fd.bottom = new FormAttachment(control, offset);
            return this;
        }

        public FD left(int numerator, int offset) {
            this.fd.left = new FormAttachment(numerator, offset);
            return this;
        }

        public FD left(int numerator) {
            return this.left(numerator, 0);
        }

        public FD left(Control control, int offset) {
            this.fd.left = new FormAttachment(control, offset);
            return this;
        }

        public FD right(int numerator, int offset) {
            this.fd.right = new FormAttachment(numerator, offset);
            return this;
        }

        public FD rright() {
            this.fd.right = new FormAttachment(100, -BaseOrcStepDialog.this.getControlOffset(this.control, this.fd.width));
            return this;
        }

        public FD right(Control control, int offset) {
            this.fd.right = new FormAttachment(control, offset);
            return this;
        }

        public void apply() {
            this.control.setLayoutData((Object)this.fd);
        }
    }
}

