/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig;

import java.util.Map;
import java.util.Set;
import org.apache.parquet.pig.PigSchemaConverter;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class PigMetaData {
    private static final String PIG_SCHEMA = "pig.schema";
    private String pigSchema;

    public static PigMetaData fromMetaData(Map<String, String> keyValueMetaData) {
        if (keyValueMetaData.containsKey(PIG_SCHEMA)) {
            return new PigMetaData(keyValueMetaData.get(PIG_SCHEMA));
        }
        return null;
    }

    public static Set<String> getPigSchemas(Map<String, Set<String>> keyValueMetaData) {
        return keyValueMetaData.get(PIG_SCHEMA);
    }

    public PigMetaData(Schema pigSchema) {
        this.pigSchema = PigSchemaConverter.pigSchemaToString(pigSchema);
    }

    public PigMetaData(String pigSchema) {
        this.pigSchema = pigSchema;
    }

    public void setPigSchema(String pigSchema) {
        this.pigSchema = pigSchema;
    }

    public String getPigSchema() {
        return this.pigSchema;
    }

    public void addToMetaData(Map<String, String> map) {
        map.put(PIG_SCHEMA, this.pigSchema);
    }
}

