/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.util;

import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import org.pentaho.platform.util.logging.Logger;
import org.pentaho.platform.util.messages.Messages;

public class ParameterHelper {
    public static String parameterToString(String value, String defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static long parameterToLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            long longValue = Long.valueOf(value);
            return longValue;
        }
        catch (Exception e) {
            Logger.error(ParameterHelper.class.getName(), Messages.getInstance().getErrorString("ParameterHelper.ERROR_0001_INVALID_NUMERIC"), (Throwable)e);
            return defaultValue;
        }
    }

    public static Date parameterToDate(String value, Date defaultValue) {
        try {
            Date date = DateFormat.getInstance().parse(value);
            if (date == null) {
                return defaultValue;
            }
            return date;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static BigDecimal parameterToDecimal(String value, BigDecimal defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            BigDecimal decimal = new BigDecimal(value);
            return decimal;
        }
        catch (Exception e) {
            Logger.error(ParameterHelper.class.getName(), Messages.getInstance().getErrorString("ParameterHelper.ERROR_0001_INVALID_NUMERIC"), (Throwable)e);
            return defaultValue;
        }
    }

    public static Object[] parameterToObjectArray(Object value, Object[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof Object[]) {
            return (Object[])value;
        }
        return new Object[]{value};
    }

    public static String[] parameterToStringArray(Object value, String[] defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Object[]) {
            Object[] oArray = (Object[])value;
            for (int i = 0; i < oArray.length; ++i) {
                oArray[i] = oArray[i].toString();
            }
            return (String[])oArray;
        }
        return new String[]{value.toString()};
    }
}

