/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalResourceCache {
    private static final Logger log = LoggerFactory.getLogger(ExternalResourceCache.class);
    protected volatile Map<String, TransValues> transMap = new ConcurrentHashMap<String, TransValues>();
    protected volatile Map<String, ExternalResourceValues> resourceMap = new ConcurrentHashMap<String, ExternalResourceValues>();
    private static ExternalResourceCache INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExternalResourceCache getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<ExternalResourceCache> clazz = ExternalResourceCache.class;
        synchronized (ExternalResourceCache.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new ExternalResourceCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private ExternalResourceCache() {
    }

    protected String getUniqueId(StepMeta meta) {
        if (meta == null || meta.getParentTransMeta() == null) {
            return null;
        }
        TransMeta transMeta = meta.getParentTransMeta();
        if (transMeta.getRepository() == null) {
            String transName = transMeta.getFilename() == null ? transMeta.getName() : transMeta.getFilename();
            return KettleAnalyzerUtil.normalizeFilePathSafely(transName) + "::" + meta.getName();
        }
        return transMeta.getPathAndName() + "." + transMeta.getDefaultExtension() + "::" + meta.getName();
    }

    public void removeCachedResources(Trans trans) {
        TransMeta transMeta = trans.getTransMeta();
        List steps = transMeta.getSteps();
        for (StepMeta step : steps) {
            String uniqueMetaId = this.getUniqueId(step);
            Resources transformations = this.transMap.get(uniqueMetaId);
            if (transformations != null && transformations.contains(trans)) {
                transformations.remove(trans);
            }
            if (transformations != null && transformations.size() != 0) continue;
            this.resourceMap.remove(uniqueMetaId);
            this.transMap.remove(uniqueMetaId);
        }
    }

    public Resources<IExternalResourceInfo> get(Trans trans, BaseStepMeta meta) {
        if (meta == null) {
            return null;
        }
        this.cacheTrans(trans, meta);
        String uniqueMetaId = this.getUniqueId(meta.getParentStepMeta());
        return this.resourceMap.get(uniqueMetaId);
    }

    private void cacheTrans(Trans trans, BaseStepMeta meta) {
        if (trans != null) {
            String uniqueMetaId = this.getUniqueId(meta.getParentStepMeta());
            TransValues transformations = this.transMap.get(uniqueMetaId);
            if (transformations == null) {
                transformations = new TransValues();
                this.transMap.put(uniqueMetaId, transformations);
            }
            transformations.add(trans);
        }
    }

    public void cache(Trans trans, BaseStepMeta meta, ExternalResourceValues resources) {
        this.cacheTrans(trans, meta);
        String uniqueMetaId = this.getUniqueId(meta.getParentStepMeta());
        this.resourceMap.put(uniqueMetaId, resources);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, ExternalResourceValues> entry : this.resourceMap.entrySet()) {
            sb.append(" ---- " + entry.getKey() + ": " + entry.getValue().size() + "\n");
            sb.append(entry.getValue().toString());
        }
        for (Map.Entry<String, Resources> entry : this.transMap.entrySet()) {
            sb.append(" ---- " + entry.getKey() + ": " + ((TransValues)entry.getValue()).size() + "\n");
            sb.append(((TransValues)entry.getValue()).toString());
        }
        log.debug("\n" + sb.toString());
        return sb.toString();
    }

    public ExternalResourceValues newExternalResourceValues() {
        return new ExternalResourceValues();
    }

    public abstract class Resources<V> {
        protected Set<V> internal = new ConcurrentHashSet();

        public void add(V value) {
            this.internal.add(value);
        }

        public boolean remove(V value) {
            return this.internal.remove(value);
        }

        public int size() {
            return this.internal.size();
        }

        public boolean contains(V value) {
            return this.internal.contains(value);
        }

        public Set<V> getInternal() {
            return new HashSet<V>(this.internal);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (V value : this.internal) {
                sb.append(" ............ ").append(value.getClass().getSimpleName()).append(" ").append(value.hashCode()).append("\n");
            }
            return sb.toString();
        }
    }

    public class TransValues
    extends Resources<Trans> {
    }

    public class ExternalResourceValues
    extends Resources<IExternalResourceInfo> {
        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (IExternalResourceInfo resource : this.internal) {
                sb.append(" ............ ").append(resource.getClass().getSimpleName()).append(" ").append(resource.getName()).append(" (").append(resource.hashCode()).append(") \n");
            }
            return sb.toString();
        }
    }
}

