/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.annotations;

import com.google.common.annotations.VisibleForTesting;
import com.tinkerpop.blueprints.Direction;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaNone;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.ISubTransAwareMeta;
import org.pentaho.di.trans.StepWithMappingMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.steps.transexecutor.TransExecutorMeta;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.dictionary.DictionaryHelper;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseAnalyzerException;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.KettleAnalyzerUtil;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.AnnotatedClassField;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.AnnotatedClassFields;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.Metaverse;
import org.pentaho.metaverse.api.analyzer.kettle.step.IClonableStepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepAnalyzer;
import org.pentaho.metaverse.api.analyzer.kettle.step.StepNodes;
import org.pentaho.metaverse.api.analyzer.kettle.step.SubtransAnalyzer;
import org.pentaho.metaverse.api.messages.Messages;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationDrivenStepMetaAnalyzer
extends StepAnalyzer<BaseStepMeta> {
    private final transient Logger log = LoggerFactory.getLogger(AnnotationDrivenStepMetaAnalyzer.class);
    private final transient Class<? extends BaseStepMeta> stepClass;
    private final Map<String, String> typeCategoryMap;
    private final transient EntityRegister register;
    private final transient BaseStepMeta meta;

    public AnnotationDrivenStepMetaAnalyzer(BaseStepMeta meta) {
        this(meta, DictionaryHelper.typeCategoryMap, DictionaryHelper::registerEntityType);
    }

    AnnotationDrivenStepMetaAnalyzer(BaseStepMeta meta, Map<String, String> typeCategoryMap, EntityRegister register) {
        this.meta = meta;
        this.stepClass = meta.getClass();
        this.typeCategoryMap = typeCategoryMap;
        this.register = register;
        this.registerTypes();
    }

    @Override
    protected IClonableStepAnalyzer newInstance() {
        return new AnnotationDrivenStepMetaAnalyzer(this.meta);
    }

    @Override
    protected void customAnalyze(BaseStepMeta meta, IMetaverseNode rootNode) throws MetaverseAnalyzerException {
        AnnotatedClassFields annoFields = new AnnotatedClassFields(meta);
        Map<AnnotatedClassField<Metaverse.Node>, IMetaverseNode> externalNodes = annoFields.nodes().map(field -> this.attachNodes(rootNode, (AnnotatedClassField<Metaverse.Node>)field, annoFields)).collect(Collectors.toMap(Pair::left, Pair::right));
        annoFields.links().forEach(nodeLink -> this.linkResourceFieldToNode(externalNodes, (Metaverse.NodeLink)nodeLink.annotation, annoFields));
        rootNode.setProperties(annoFields.props().collect(Collectors.toMap(AnnotatedClassField::name, AnnotatedClassField::val)));
        if (meta instanceof StepWithMappingMeta) {
            this.analyzeAndLinkSubtrans(meta, rootNode, externalNodes);
        }
    }

    private void analyzeAndLinkSubtrans(Object meta, IMetaverseNode rootNode, Map<AnnotatedClassField<Metaverse.Node>, IMetaverseNode> externalNodes) throws MetaverseAnalyzerException {
        try {
            TransMeta subTransMeta = TransExecutorMeta.loadMappingMeta((StepWithMappingMeta)((StepWithMappingMeta)meta), (Repository)this.parentTransMeta.getRepository(), (IMetaStore)this.parentTransMeta.getMetaStore(), (VariableSpace)this.parentTransMeta);
            IMetaverseNode subTransNode = KettleAnalyzerUtil.analyze(this, this.parentTransMeta, (ISubTransAwareMeta)meta, rootNode);
            SubtransAnalyzer<BaseStepMeta> subtransAnalyzer = this.getSubtransAnalyzer();
            this.linkToSubTransInputs(externalNodes, subTransMeta, subTransNode, subtransAnalyzer);
            String resultFieldsStep = this.getSubTransResultFieldName();
            if (null != resultFieldsStep && !resultFieldsStep.equals("")) {
                this.linkToSubTransOutputs(subTransMeta, subTransNode, subtransAnalyzer, resultFieldsStep);
            } else {
                this.log.warn(Messages.getString("ERROR.AnnotationDrivenStepMetaAnalyzer.SubtransResultNotFound"));
            }
        }
        catch (KettleException e) {
            this.log.error(Messages.getErrorString("WARN.AnnotationDrivenStepMetaAnalyzer.SubtransProcessingException"), (Throwable)e);
        }
    }

    private void linkToSubTransOutputs(TransMeta subTransMeta, IMetaverseNode subTransNode, SubtransAnalyzer<BaseStepMeta> subtransAnalyzer, String resultFieldsStep) {
        StepNodes outputNodes = this.getOutputs();
        for (String stepName : outputNodes.getStepNames()) {
            for (String fieldName : outputNodes.getFieldNames(stepName)) {
                subtransAnalyzer.linkResultFieldToSubTrans(outputNodes.findNode(stepName, fieldName), subTransMeta, subTransNode, this.descriptor, resultFieldsStep);
            }
        }
    }

    private void linkToSubTransInputs(Map<AnnotatedClassField<Metaverse.Node>, IMetaverseNode> externalNodes, TransMeta subTransMeta, IMetaverseNode subTransNode, SubtransAnalyzer<BaseStepMeta> subtransAnalyzer) {
        externalNodes.entrySet().stream().filter(entry -> ((Metaverse.Node)((AnnotatedClassField)entry.getKey()).annotation).subTransLink().equals("SUBTRANS_INPUT")).forEach(entry -> subtransAnalyzer.linkUsedFieldToSubTrans((IMetaverseNode)entry.getValue(), subTransMeta, subTransNode, this.descriptor, fieldName -> fieldName.equals(((AnnotatedClassField)entry.getKey()).val())));
    }

    protected String getSubTransResultFieldName() {
        String resultFieldsStep = "";
        if (this.baseStepMeta instanceof BaseStreamStepMeta) {
            resultFieldsStep = ((BaseStreamStepMeta)this.baseStepMeta).getSubStep();
        } else if (this.baseStepMeta instanceof TransExecutorMeta) {
            if (((TransExecutorMeta)this.baseStepMeta).getOutputRowsSourceStep() != null) {
                resultFieldsStep = ((TransExecutorMeta)this.baseStepMeta).getOutputRowsSourceStep();
            } else if (((TransExecutorMeta)this.baseStepMeta).getExecutorsOutputStep() != null) {
                resultFieldsStep = ((TransExecutorMeta)this.baseStepMeta).getExecutorsOutputStep();
            }
        }
        return resultFieldsStep;
    }

    @Override
    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return Collections.singleton(this.stepClass);
    }

    @Override
    protected Set<StepField> getUsedFields(BaseStepMeta meta) {
        this.loadStreamFields(meta);
        return new AnnotatedClassFields(meta).props().map(AnnotatedClassField::val).map(this::stepNameFieldName).filter(Optional::isPresent).map(Optional::get).map(stepField -> new StepField((String)stepField.left, (String)stepField.right)).collect(Collectors.toSet());
    }

    @Override
    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(BaseStepMeta meta) {
        Map<String, RowMetaInterface> rowMetas = super.getOutputRowMetaInterfaces(meta);
        AnnotatedClassFields nodeTree = new AnnotatedClassFields(meta);
        RowMeta resourceRowMeta = new RowMeta();
        new AnnotatedClassFields(meta).links().filter(field -> ((Metaverse.Node)nodeTree.node((String)((Metaverse.NodeLink)field.annotation).nodeName()).get().annotation).link().equals("outputs")).forEach(field -> resourceRowMeta.addValueMeta((ValueMetaInterface)new ValueMetaNone(field.name)));
        if (resourceRowMeta.size() > 0) {
            rowMetas.put("_resource_", (RowMetaInterface)resourceRowMeta);
        }
        return rowMetas;
    }

    private void registerTypes() {
        Arrays.stream(this.stepClass.getAnnotationsByType(Metaverse.CategoryMap.class)).forEach(catMap -> this.typeCategoryMap.put(catMap.entity(), catMap.category()));
        Arrays.stream(this.stepClass.getAnnotationsByType(Metaverse.EntityLink.class)).forEach(entityLink -> {
            String parentEntity = entityLink.parentEntity().isEmpty() ? null : entityLink.parentEntity();
            this.register.registerEntityTypes(entityLink.link(), entityLink.entity(), parentEntity);
        });
    }

    private void linkResourceFieldToNode(Map<AnnotatedClassField<Metaverse.Node>, IMetaverseNode> resourceNodes, Metaverse.NodeLink nodeLink, AnnotatedClassFields annoFields) {
        IMetaverseNode childNode;
        StepNodes stepNodes;
        IMetaverseNode resourceFieldNode = null;
        StepNodes stepNodes2 = stepNodes = this.isOutLink(nodeLink) ? this.getOutputs() : this.getInputs();
        if (stepNodes != null && !stepNodes.getFieldNames().isEmpty()) {
            resourceFieldNode = stepNodes.findNode("_resource_", nodeLink.nodeName());
        }
        if (resourceFieldNode == null) {
            StepNodes newStepNodeObj = new StepNodes();
            resourceNodes.entrySet().stream().filter(mapEntry -> ((IMetaverseNode)mapEntry.getValue()).getProperty("type").equals("_resource_")).forEach(mapEntry -> newStepNodeObj.addNode("_resource_", ((IMetaverseNode)mapEntry.getValue()).getName(), (IMetaverseNode)mapEntry.getValue()));
            stepNodes = newStepNodeObj;
            resourceFieldNode = stepNodes.findNode("_resource_", nodeLink.nodeName());
        }
        if ((childNode = resourceFieldNode) != null) {
            annoFields.node(nodeLink.parentNodeName()).map(resourceNodes::get).ifPresent(parentNode -> this.addLink(nodeLink, childNode, (IMetaverseNode)parentNode));
        } else {
            String parentNodeLink = nodeLink.parentNodelink();
            String fromNode = nodeLink.nodeName();
            String toNode = nodeLink.parentNodeName();
            this.log.warn(Messages.getErrorString("ERROR.AnnotationDrivenStepMetaAnalyzer.LinkError", parentNodeLink, fromNode, toNode));
        }
    }

    private void addLink(Metaverse.NodeLink attribute, IMetaverseNode resourceFieldNode, IMetaverseNode resourceNode) {
        if (this.isOutLink(attribute)) {
            this.getMetaverseBuilder().addLink(resourceNode, attribute.parentNodelink(), resourceFieldNode);
        } else {
            this.getMetaverseBuilder().addLink(resourceFieldNode, attribute.parentNodelink(), resourceNode);
        }
    }

    private boolean isOutLink(Metaverse.NodeLink attribute) {
        return attribute.linkDirection().equals(Direction.OUT.name());
    }

    void loadStreamFields(BaseStepMeta meta) {
        this.loadInputAndOutputStreamFields(meta);
    }

    private Optional<Pair<String, String>> stepNameFieldName(String fieldName) {
        List fieldMatches = this.prevFields.entrySet().stream().filter(tuple -> Arrays.asList(((RowMetaInterface)tuple.getValue()).getFieldNames()).contains(fieldName)).collect(Collectors.toList());
        if (fieldMatches.size() != 1) {
            return Optional.empty();
        }
        return Optional.of(new Pair(((Map.Entry)fieldMatches.get(0)).getKey(), fieldName));
    }

    private Pair<AnnotatedClassField<Metaverse.Node>, IMetaverseNode> attachNodes(IMetaverseNode rootNode, AnnotatedClassField<Metaverse.Node> resource, AnnotatedClassFields annoFields) {
        Metaverse.Node nodeAnno = (Metaverse.Node)resource.annotation;
        IMetaverseNode node = this.createNode(rootNode, resource);
        node.setProperties(annoFields.props().filter(field -> ((Metaverse.Property)field.annotation).parentNodeName().equals(nodeAnno.name())).collect(Collectors.toMap(AnnotatedClassField::name, AnnotatedClassField::val)));
        if (nodeAnno.linkDirection().equals(Direction.OUT.name())) {
            this.getMetaverseBuilder().addNode(node).addLink(node, nodeAnno.link(), rootNode);
        } else {
            this.getMetaverseBuilder().addNode(node).addLink(rootNode, nodeAnno.link(), node);
        }
        return new Pair<AnnotatedClassField<Metaverse.Node>, IMetaverseNode>(resource, node);
    }

    private IMetaverseNode createNode(IMetaverseNode rootNode, AnnotatedClassField<Metaverse.Node> field) {
        return this.createNodeFromDescriptor(new MetaverseComponentDescriptor(field.name, ((Metaverse.Node)field.annotation).type(), rootNode, this.getDescriptor().getContext()));
    }

    @VisibleForTesting
    protected SubtransAnalyzer<BaseStepMeta> getSubtransAnalyzer() {
        return new SubtransAnalyzer<BaseStepMeta>(this, this.log);
    }

    private static class Pair<L, R> {
        final L left;
        final R right;

        Pair(L l, R r) {
            this.left = l;
            this.right = r;
        }

        public L left() {
            return this.left;
        }

        public R right() {
            return this.right;
        }
    }

    @FunctionalInterface
    static interface EntityRegister {
        public void registerEntityTypes(String var1, String var2, String var3);
    }
}

