/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metaverse.api.analyzer.kettle.step;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.StepField;

public class StepNodes {
    private LowerCaseKeyLinkedHashMap<String, LowerCaseKeyLinkedHashMap<String, IMetaverseNode>> store = new LowerCaseKeyLinkedHashMap();

    public void addNode(String stepName, String fieldName, IMetaverseNode node) {
        if (!this.store.containsKey(stepName)) {
            this.store.put(stepName, (LowerCaseKeyLinkedHashMap<String, IMetaverseNode>)new LowerCaseKeyLinkedHashMap());
        }
        Map stepFields = this.store.get(stepName);
        stepFields.put(fieldName, node);
    }

    public List<IMetaverseNode> findNodes(String fieldName) {
        ArrayList<IMetaverseNode> nodes = new ArrayList<IMetaverseNode>();
        for (Map stepNodes : this.store.values()) {
            IMetaverseNode match = (IMetaverseNode)stepNodes.get(fieldName);
            if (match == null) continue;
            nodes.add(match);
        }
        return nodes;
    }

    public IMetaverseNode findNode(StepField stepField) {
        return this.findNode(stepField.getStepName(), stepField.getFieldName());
    }

    public IMetaverseNode findNode(String stepName, String fieldName) {
        IMetaverseNode node = null;
        Map stepNodes = this.store.get(stepName);
        if (stepNodes != null) {
            node = (IMetaverseNode)stepNodes.get(fieldName);
        }
        return node;
    }

    public Set<String> getStepNames() {
        return this.store.keySet();
    }

    public Set<String> getFieldNames(String stepName) {
        Map stepNodes = this.store.get(stepName);
        Set fieldNames = null;
        if (stepNodes != null) {
            fieldNames = stepNodes.keySet();
        }
        return fieldNames;
    }

    public Set<StepField> getFieldNames() {
        LinkedHashSet<StepField> fieldNames = new LinkedHashSet<StepField>();
        for (String stepName : this.getStepNames()) {
            Set<String> names = this.getFieldNames(stepName);
            for (String name : names) {
                fieldNames.add(new StepField(stepName, name));
            }
        }
        return fieldNames;
    }

    static class LowerCaseKeyLinkedHashMap<K, V>
    extends LinkedHashMap<String, V> {
        private Map<String, String> keyMap = new HashMap<String, String>();

        LowerCaseKeyLinkedHashMap() {
        }

        @Override
        public V put(String key, V value) {
            this.keyMap.put(StringUtil.safeToLowerCase((Object)key), key);
            return super.put(key, value);
        }

        @Override
        public V get(Object key) {
            return super.get(this.keyMap.get(StringUtil.safeToLowerCase((Object)key)));
        }

        @Override
        public boolean containsKey(Object key) {
            return super.containsKey(this.keyMap.get(StringUtil.safeToLowerCase((Object)key)));
        }
    }
}

