/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.util.ParamChecker;

public class XLog
implements Log {
    public static final String INSTRUMENTATION_LOG_NAME = "oozieinstrumentation";
    public static final int STD = 1;
    public static final int OPS = 4;
    private static final int ALL = 5;
    private static final int[] LOGGER_MASKS = new int[]{1, 4};
    Log[] loggers = new Log[2];
    private String prefix = null;

    public static XLog getLog(String name) {
        return new XLog(LogFactory.getLog((String)name));
    }

    public static XLog getLog(Class clazz) {
        return new XLog(LogFactory.getLog((Class)clazz));
    }

    public static XLog resetPrefix(XLog log) {
        log.setMsgPrefix(Info.get().createPrefix());
        return log;
    }

    public XLog(Log log) {
        this.loggers[0] = log;
        this.loggers[1] = LogFactory.getLog((String)"oozieops");
    }

    public String getMsgPrefix() {
        return this.prefix;
    }

    public void setMsgPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void debug(Object o) {
        this.log(Level.DEBUG, 1, "{0}", o);
    }

    public void debug(Object o, Throwable throwable) {
        this.log(Level.DEBUG, 1, "{0}", o, throwable);
    }

    public void error(Object o) {
        this.log(Level.ERROR, 1, "{0}", o);
    }

    public void error(Object o, Throwable throwable) {
        this.log(Level.ERROR, 1, "{0}", o, throwable);
    }

    public void fatal(Object o) {
        this.log(Level.FATAL, 1, "{0}", o);
    }

    public void fatal(Object o, Throwable throwable) {
        this.log(Level.FATAL, 1, "{0}", o, throwable);
    }

    public void info(Object o) {
        this.log(Level.INFO, 1, "{0}", o);
    }

    public void info(Object o, Throwable throwable) {
        this.log(Level.INFO, 1, "{0}", o, throwable);
    }

    public void trace(Object o) {
        this.log(Level.TRACE, 1, "{0}", o);
    }

    public void trace(Object o, Throwable throwable) {
        this.log(Level.TRACE, 1, "{0}", o, throwable);
    }

    public void warn(Object o) {
        this.log(Level.WARN, 1, "{0}", o);
    }

    public void warn(Object o, Throwable throwable) {
        this.log(Level.WARN, 1, "{0}", o, throwable);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(Level.DEBUG, 5);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(Level.ERROR, 5);
    }

    public boolean isFatalEnabled() {
        return this.isEnabled(Level.FATAL, 5);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(Level.INFO, 5);
    }

    public boolean isTraceEnabled() {
        return this.isEnabled(Level.TRACE, 5);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(Level.WARN, 5);
    }

    private boolean isEnabled(Level level, int loggerMask) {
        for (int i = 0; i < this.loggers.length; ++i) {
            if ((LOGGER_MASKS[i] & loggerMask) == 0) continue;
            boolean enabled = false;
            switch (level) {
                case FATAL: {
                    enabled = this.loggers[i].isFatalEnabled();
                    break;
                }
                case ERROR: {
                    enabled = this.loggers[i].isErrorEnabled();
                    break;
                }
                case INFO: {
                    enabled = this.loggers[i].isInfoEnabled();
                    break;
                }
                case WARN: {
                    enabled = this.loggers[i].isWarnEnabled();
                    break;
                }
                case DEBUG: {
                    enabled = this.loggers[i].isDebugEnabled();
                    break;
                }
                case TRACE: {
                    enabled = this.loggers[i].isTraceEnabled();
                }
            }
            if (!enabled) continue;
            return true;
        }
        return false;
    }

    private void log(Level level, int loggerMask, String msgTemplate, Object ... params) {
        if (this.isEnabled(level, loggerMask |= 1)) {
            String prefix = this.getMsgPrefix() != null ? this.getMsgPrefix() : Info.get().getPrefix();
            prefix = prefix != null && prefix.length() > 0 ? prefix + " " : "";
            String msg = prefix + XLog.format(msgTemplate, params);
            Throwable throwable = XLog.getCause(params);
            block8: for (int i = 0; i < LOGGER_MASKS.length; ++i) {
                if (!this.isEnabled(level, loggerMask & LOGGER_MASKS[i])) continue;
                Log log = this.loggers[i];
                switch (level) {
                    case FATAL: {
                        log.fatal((Object)msg, throwable);
                        continue block8;
                    }
                    case ERROR: {
                        log.error((Object)msg, throwable);
                        continue block8;
                    }
                    case INFO: {
                        log.info((Object)msg, throwable);
                        continue block8;
                    }
                    case WARN: {
                        log.warn((Object)msg, throwable);
                        continue block8;
                    }
                    case DEBUG: {
                        log.debug((Object)msg, throwable);
                        continue block8;
                    }
                    case TRACE: {
                        log.trace((Object)msg, throwable);
                    }
                }
            }
        }
    }

    public void fatal(String msgTemplate, Object ... params) {
        this.log(Level.FATAL, 1, msgTemplate, params);
    }

    public void error(String msgTemplate, Object ... params) {
        this.log(Level.ERROR, 1, msgTemplate, params);
    }

    public void info(String msgTemplate, Object ... params) {
        this.log(Level.INFO, 1, msgTemplate, params);
    }

    public void warn(String msgTemplate, Object ... params) {
        this.log(Level.WARN, 1, msgTemplate, params);
    }

    public void debug(String msgTemplate, Object ... params) {
        this.log(Level.DEBUG, 1, msgTemplate, params);
    }

    public void trace(String msgTemplate, Object ... params) {
        this.log(Level.TRACE, 1, msgTemplate, params);
    }

    public void fatal(int loggerMask, String msgTemplate, Object ... params) {
        this.log(Level.FATAL, loggerMask, msgTemplate, params);
    }

    public void error(int loggerMask, String msgTemplate, Object ... params) {
        this.log(Level.ERROR, loggerMask, msgTemplate, params);
    }

    public void info(int loggerMask, String msgTemplate, Object ... params) {
        this.log(Level.INFO, loggerMask, msgTemplate, params);
    }

    public void warn(int loggerMask, String msgTemplate, Object ... params) {
        this.log(Level.WARN, loggerMask, msgTemplate, params);
    }

    public void debug(int loggerMask, String msgTemplate, Object ... params) {
        this.log(Level.DEBUG, loggerMask, msgTemplate, params);
    }

    public void trace(int loggerMask, String msgTemplate, Object ... params) {
        this.log(Level.TRACE, loggerMask, msgTemplate, params);
    }

    public static String format(String msgTemplate, Object ... params) {
        ParamChecker.notEmpty(msgTemplate, "msgTemplate");
        msgTemplate = msgTemplate.replace("{E}", System.getProperty("line.separator"));
        if (params != null && params.length > 0) {
            msgTemplate = MessageFormat.format(msgTemplate, params);
        }
        return msgTemplate;
    }

    public static Throwable getCause(Object ... params) {
        Throwable throwable = null;
        if (params != null && params.length > 0 && params[params.length - 1] instanceof Throwable) {
            throwable = (Throwable)params[params.length - 1];
        }
        return throwable;
    }

    public static enum Level {
        FATAL,
        ERROR,
        INFO,
        WARN,
        DEBUG,
        TRACE;

    }

    public static class Info {
        private static String template = "";
        private String prefix = "";
        private static List<String> parameterNames = new ArrayList<String>();
        private static ThreadLocal<Info> tlLogInfo = new ThreadLocal<Info>(){

            @Override
            protected Info initialValue() {
                return new Info();
            }
        };
        private Map<String, String> parameters = new HashMap<String, String>();

        public static void defineParameter(String name) {
            ParamChecker.notEmpty(name, "name");
            int count = parameterNames.size();
            if (count > 0) {
                template = template + " ";
            }
            template = template + name + "[{" + count + "}]";
            parameterNames.add(name);
        }

        public static void reset() {
            template = "";
            parameterNames.clear();
        }

        public static Info get() {
            return tlLogInfo.get();
        }

        public static void remove() {
            tlLogInfo.remove();
        }

        public Info() {
        }

        public Info(Info logInfo) {
            this.setParameters(logInfo);
        }

        public void clear() {
            this.parameters.clear();
            this.resetPrefix();
        }

        public void setParameter(String name, String value) {
            if (!parameterNames.contains(name)) {
                throw new IllegalArgumentException(XLog.format("Parameter[{0}] not defined", name));
            }
            this.parameters.put(name, value);
        }

        public String getParameter(String name) {
            return this.parameters.get(name);
        }

        public void clearParameter(String name) {
            if (!parameterNames.contains(name)) {
                throw new IllegalArgumentException(XLog.format("Parameter[{0}] not defined", name));
            }
            this.parameters.remove(name);
        }

        public void setParameters(Info logInfo) {
            this.parameters.clear();
            this.parameters.putAll(logInfo.parameters);
        }

        public String createPrefix() {
            String[] params = new String[parameterNames.size()];
            for (int i = 0; i < params.length; ++i) {
                params[i] = this.parameters.get(parameterNames.get(i));
                if (params[i] != null) continue;
                params[i] = "-";
            }
            return MessageFormat.format(template, params);
        }

        public String resetPrefix() {
            this.prefix = this.createPrefix();
            return this.prefix;
        }

        public String getPrefix() {
            return this.prefix;
        }
    }
}

