/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.row.value.ValueMetaString;
import org.pentaho.di.core.util.serialization.ConfigHelper;
import org.pentaho.di.core.util.serialization.Sensitive;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.StepOption;
import org.pentaho.di.trans.step.mqtt.MQTTClientBuilder;
import org.pentaho.di.trans.step.mqtt.MQTTConsumer;
import org.pentaho.di.trans.step.mqtt.MQTTConsumerData;
import org.pentaho.di.trans.streaming.common.BaseStreamStepMeta;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metaverse.api.analyzer.kettle.annotations.Metaverse;

@Step(id="MQTTConsumer", image="MQTTConsumer.svg", i18nPackageName="org.pentaho.di.trans.step.mqtt", name="MQTTConsumer.TypeLongDesc", description="MQTTConsumer.TypeTooltipDesc", categoryDescription="i18n:org.pentaho.di.trans.step:BaseStep.Category.Streaming", documentationUrl="Products/MQTT_Consumer")
@InjectionSupported(localizationPrefix="MQTTConsumerMeta.Injection.", groups={"SSL"})
@Metaverse.CategoryMaps(value={@Metaverse.CategoryMap(entity="MQTT Topic", category="messageQueue"), @Metaverse.CategoryMap(entity="MQTT Server", category="datasource")})
@Metaverse.EntityLinks(value={@Metaverse.EntityLink(entity="MQTT Server", link="parentconcept", parentEntity="External Connection"), @Metaverse.EntityLink(entity="MQTT Topic", link="containsconcept", parentEntity="MQTT Server"), @Metaverse.EntityLink(entity="MQTT Topic", link="parentconcept")})
public class MQTTConsumerMeta
extends BaseStreamStepMeta
implements StepMetaInterface {
    private static final Class<?> PKG = MQTTConsumerMeta.class;
    @Metaverse.Node(name="MQTT Server", type="MQTT Server")
    @Metaverse.Property(name="MQTT Server", parentNodeName="MQTT Server")
    @Injection(name="MQTT_SERVER")
    public String mqttServer = "";
    @Metaverse.Node(name="MQTT Topic", type="MQTT Topic", link="isreadby")
    @Metaverse.Property(name="TOPIC", parentNodeName="MQTT Topic")
    @Injection(name="TOPICS")
    public List<String> topics = new ArrayList<String>();
    @Metaverse.Node(name="Message", type="_resource_", link="inputs", nameFromValue="FALSE", subTransLink="SUBTRANS_INPUT")
    @Metaverse.Property(name="Message", parentNodeName="Message")
    @Metaverse.NodeLink(nodeName="Message", parentNodeName="MQTT Topic", linkDirection="OUT")
    @Injection(name="MSG_OUTPUT_NAME")
    public String msgOutputName = "Message";
    @Metaverse.Node(name="Topic name", type="_resource_", link="inputs", nameFromValue="FALSE", subTransLink="SUBTRANS_INPUT")
    @Metaverse.Property(name="Topic name", parentNodeName="Topic name")
    @Metaverse.NodeLink(nodeName="Topic name", parentNodeName="MQTT Topic", linkDirection="OUT")
    @Injection(name="TOPIC_OUTPUT_NAME")
    public String topicOutputName = "Topic";
    @Injection(name="QOS")
    public String qos = "0";
    @Metaverse.Property(name="USERNAME", parentNodeName="MQTT Server")
    @Injection(name="USERNAME")
    public String username = "";
    @Sensitive
    @Injection(name="PASSWORD")
    private String password = "";
    @Metaverse.Property(name="USE_SSL", parentNodeName="MQTT Server")
    @Injection(name="USE_SSL", group="SSL")
    public Boolean useSsl = false;
    @Injection(name="SSL_KEYS", group="SSL")
    List<String> sslKeys = new ArrayList<String>();
    @Sensitive
    @Injection(name="SSL_VALUES", group="SSL")
    List<String> sslValues = new ArrayList<String>();
    @Injection(name="KEEP_ALIVE_INTERVAL")
    private String keepAliveInterval = "";
    @Injection(name="MAX_INFLIGHT")
    private String maxInflight = "";
    @Injection(name="CONNECTION_TIMEOUT")
    private String connectionTimeout = "";
    @Injection(name="CLEAN_SESSION")
    private String cleanSession = "";
    @Injection(name="STORAGE_LEVEL")
    private String storageLevel = "";
    @Metaverse.Property(name="SERVER_URIS", parentNodeName="MQTT Server")
    @Injection(name="SERVER_URIS")
    public String serverUris = "";
    @Injection(name="MQTT_VERSION")
    private String mqttVersion = "";
    @Injection(name="AUTOMATIC_RECONNECT")
    private String automaticReconnect = "";
    @Injection(name="MESSAGE_DATA_TYPE")
    public String messageDataType = ValueMetaInterface.getTypeDescription((int)2);

    public MQTTConsumerMeta() {
        this.setSpecificationMethod(ObjectLocationSpecificationMethod.FILENAME);
    }

    public void setDefault() {
        super.setDefault();
        this.mqttServer = "";
        this.qos = "0";
        this.username = "";
        this.password = "";
        this.sslKeys = MQTTClientBuilder.DEFAULT_SSL_OPTS.keySet().stream().sorted().collect(Collectors.toList());
        this.sslValues = this.sslKeys.stream().map(arg_0 -> MQTTClientBuilder.DEFAULT_SSL_OPTS.get(arg_0)).collect(Collectors.toList());
        this.keepAliveInterval = "";
        this.maxInflight = "";
        this.connectionTimeout = "";
        this.cleanSession = "";
        this.storageLevel = "";
        this.serverUris = "";
        this.mqttVersion = "";
        this.automaticReconnect = "";
        this.messageDataType = ValueMetaInterface.getTypeDescription((int)2);
    }

    public int getMessageDataType() {
        return ValueMetaInterface.getTypeCode((String)this.messageDataType);
    }

    public String getFileName() {
        return this.getTransformationPath();
    }

    public RowMeta getRowMeta(String origin, VariableSpace space) {
        RowMeta rowMeta = new RowMeta();
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaBase(this.msgOutputName, this.getMessageDataType()));
        rowMeta.addValueMeta((ValueMetaInterface)new ValueMetaString(this.topicOutputName));
        return rowMeta;
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MQTTConsumer(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new MQTTConsumerData();
    }

    public String getDialogClassName() {
        return "org.pentaho.di.trans.step.mqtt.MQTTConsumerDialog";
    }

    public String getMqttServer() {
        return this.mqttServer;
    }

    public void setMqttServer(String mqttServer) {
        this.mqttServer = mqttServer;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public String getMsgOutputName() {
        return this.msgOutputName;
    }

    public void setMsgOutputName(String msgOutputName) {
        this.msgOutputName = msgOutputName;
    }

    public String getTopicOutputName() {
        return this.topicOutputName;
    }

    public void setTopicOutputName(String topicOutputName) {
        this.topicOutputName = topicOutputName;
    }

    public String getQos() {
        return this.qos;
    }

    public void setQos(String qos) {
        this.qos = qos;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Map<String, String> getSslConfig() {
        return ConfigHelper.conf(this.sslKeys, this.sslValues).asMap();
    }

    public void setSslConfig(Map<String, String> sslConfig) {
        this.sslKeys = ConfigHelper.conf(sslConfig).keys();
        this.sslValues = ConfigHelper.conf(sslConfig).vals();
    }

    public boolean isUseSsl() {
        return this.useSsl;
    }

    public void setUseSsl(boolean useSsl) {
        this.useSsl = useSsl;
    }

    public String getKeepAliveInterval() {
        return this.keepAliveInterval;
    }

    public void setKeepAliveInterval(String keepAliveInterval) {
        this.keepAliveInterval = keepAliveInterval;
    }

    public String getMaxInflight() {
        return this.maxInflight;
    }

    public void setMaxInflight(String maxInflight) {
        this.maxInflight = maxInflight;
    }

    public String getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public String getCleanSession() {
        return this.cleanSession;
    }

    public void setCleanSession(String cleanSession) {
        this.cleanSession = cleanSession;
    }

    public String getStorageLevel() {
        return this.storageLevel;
    }

    public void setStorageLevel(String storageLevel) {
        this.storageLevel = storageLevel;
    }

    public String getServerUris() {
        return this.serverUris;
    }

    public void setServerUris(String serverUris) {
        this.serverUris = serverUris;
    }

    public String getMqttVersion() {
        return this.mqttVersion;
    }

    public void setMqttVersion(String mqttVersion) {
        this.mqttVersion = mqttVersion;
    }

    public String getAutomaticReconnect() {
        return this.automaticReconnect;
    }

    public void setAutomaticReconnect(String automaticReconnect) {
        this.automaticReconnect = automaticReconnect;
    }

    List<StepOption> retrieveOptions() {
        return Arrays.asList(new StepOption("KEEP_ALIVE_INTERVAL", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.KEEP_ALIVE_INTERVAL", (String[])new String[0]), this.keepAliveInterval), new StepOption("MAX_INFLIGHT", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.MAX_INFLIGHT", (String[])new String[0]), this.maxInflight), new StepOption("CONNECTION_TIMEOUT", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CONNECTION_TIMEOUT", (String[])new String[0]), this.connectionTimeout), new StepOption("CLEAN_SESSION", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CLEAN_SESSION", (String[])new String[0]), this.cleanSession), new StepOption("STORAGE_LEVEL", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.STORAGE_LEVEL", (String[])new String[0]), this.storageLevel), new StepOption("SERVER_URIS", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.SERVER_URIS", (String[])new String[0]), this.serverUris), new StepOption("MQTT_VERSION", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.MQTT_VERSION", (String[])new String[0]), this.mqttVersion), new StepOption("AUTOMATIC_RECONNECT", BaseMessages.getString(PKG, (String)"MQTTDialog.Options.AUTOMATIC_RECONNECT", (String[])new String[0]), this.automaticReconnect));
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        super.check(remarks, transMeta, stepMeta, prev, input, output, info, space, repository, metaStore);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.KEEP_ALIVE_INTERVAL", (String[])new String[0]), (String)this.keepAliveInterval);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.MAX_INFLIGHT", (String[])new String[0]), (String)this.maxInflight);
        StepOption.checkInteger(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CONNECTION_TIMEOUT", (String[])new String[0]), (String)this.connectionTimeout);
        StepOption.checkBoolean(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.CLEAN_SESSION", (String[])new String[0]), (String)this.cleanSession);
        MQTTClientBuilder.checkVersion(remarks, stepMeta, space, this.mqttVersion);
        StepOption.checkBoolean(remarks, (StepMeta)stepMeta, (VariableSpace)space, (String)BaseMessages.getString(PKG, (String)"MQTTDialog.Options.AUTOMATIC_RECONNECT", (String[])new String[0]), (String)this.automaticReconnect);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MQTTConsumerMeta that = (MQTTConsumerMeta)((Object)o);
        return Objects.equals(this.useSsl, that.useSsl) && Objects.equals(this.mqttServer, that.mqttServer) && Objects.equals(this.topics, that.topics) && Objects.equals(this.msgOutputName, that.msgOutputName) && Objects.equals(this.topicOutputName, that.topicOutputName) && Objects.equals(this.qos, that.qos) && Objects.equals(this.sslKeys, that.sslKeys) && Objects.equals(this.sslValues, that.sslValues) && Objects.equals(this.username, that.username) && Objects.equals(this.password, that.password) && Objects.equals(this.keepAliveInterval, that.keepAliveInterval) && Objects.equals(this.maxInflight, that.maxInflight) && Objects.equals(this.connectionTimeout, that.connectionTimeout) && Objects.equals(this.cleanSession, that.cleanSession) && Objects.equals(this.storageLevel, that.storageLevel) && Objects.equals(this.serverUris, that.serverUris) && Objects.equals(this.mqttVersion, that.mqttVersion) && Objects.equals(this.automaticReconnect, that.automaticReconnect);
    }

    public int hashCode() {
        return Objects.hash(this.mqttServer, this.topics, this.msgOutputName, this.topicOutputName, this.qos, this.useSsl, this.sslKeys, this.sslValues, this.username, this.password, this.keepAliveInterval, this.maxInflight, this.connectionTimeout, this.cleanSession, this.storageLevel, this.serverUris, this.mqttVersion, this.automaticReconnect);
    }
}

