/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.step.mqtt;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.util.serialization.BaseSerializingMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.mqtt.MQTTClientBuilder;
import org.pentaho.di.trans.step.mqtt.MQTTProducerMeta;

public class MQTTProducer
extends BaseStep
implements StepInterface {
    private static final Class<?> PKG = MQTTProducer.class;
    private MQTTProducerMeta meta;
    Supplier<MqttClient> client = Suppliers.memoize(this::connectToClient);
    private AtomicBoolean connectionError = new AtomicBoolean(false);

    public MQTTProducer(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean init(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) {
        boolean isInitalized = super.init(stepMetaInterface, stepDataInterface);
        BaseSerializingMeta serializingMeta = (BaseSerializingMeta)stepMetaInterface;
        this.meta = (MQTTProducerMeta)serializingMeta.withVariables((VariableSpace)this);
        ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
        this.meta.check(remarks, this.getTransMeta(), this.meta.getParentStepMeta(), null, null, null, null, this.variables, this.getRepository(), this.getMetaStore());
        boolean errorsPresent = remarks.stream().filter(result -> result.getType() == 4).peek(result -> this.logError(result.getText())).count() > 0L;
        return !errorsPresent && isInitalized;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        Object[] row = this.getRow();
        if (null == row) {
            this.setOutputDone();
            return false;
        }
        try {
            ((MqttClient)this.client.get()).publish(this.getTopic(row), this.getMessage(row));
            this.incrementLinesOutput();
            this.putRow(this.getInputRowMeta(), row);
            if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                this.logBasic(BaseMessages.getString(PKG, (String)"MQTTProducer.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
            }
        }
        catch (MqttException e) {
            this.logError(BaseMessages.getString(PKG, (String)"MQTTProducer.Error.QOSNotSupported", (String[])new String[]{this.meta.qos}));
            this.logError(e.getMessage(), e);
            this.setErrors(1L);
            this.stopAll();
            return false;
        }
        catch (RuntimeException re) {
            this.stopAll();
            this.logError(re.getMessage(), re);
            return false;
        }
        return true;
    }

    private MqttClient connectToClient() {
        this.logDebug("Publishing using a quality of service level of " + this.meta.qos);
        try {
            return MQTTClientBuilder.builder().withBroker(this.meta.mqttServer).withClientId(this.meta.clientId).withQos(this.meta.qos).withStep(this).withUsername(this.meta.username).withPassword(this.meta.password).withSslConfig(this.meta.getSslConfig()).withIsSecure(this.meta.useSsl).withKeepAliveInterval(this.meta.keepAliveInterval).withMaxInflight(this.meta.maxInflight).withConnectionTimeout(this.meta.connectionTimeout).withCleanSession(this.meta.cleanSession).withStorageLevel(this.meta.storageLevel).withServerUris(this.meta.serverUris).withMqttVersion(this.meta.mqttVersion).withAutomaticReconnect(this.meta.automaticReconnect).buildAndConnect();
        }
        catch (MqttException e) {
            this.connectionError.set(true);
            throw new IllegalStateException(e);
        }
    }

    private MqttMessage getMessage(Object[] row) throws KettleStepException {
        MqttMessage mqttMessage = new MqttMessage();
        try {
            mqttMessage.setQos(Integer.parseInt(this.meta.qos));
        }
        catch (NumberFormatException e) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"MQTTProducer.Error.QOS", (String[])new String[]{this.meta.qos}));
        }
        mqttMessage.setPayload((byte[])this.getFieldData(row, this.meta.messageField).map(this::dataAsBytes).orElse(null));
        return mqttMessage;
    }

    private byte[] dataAsBytes(Object data) {
        if (this.getInputRowMeta().searchValueMeta(this.meta.messageField).isBinary()) {
            return (byte[])data;
        }
        return Objects.toString(data).getBytes(StandardCharsets.UTF_8);
    }

    private String getTopic(Object[] row) {
        String topic = this.meta.topicInField != false ? this.getFieldData(row, this.meta.fieldTopic).map(Objects::toString).orElse("") : this.meta.topic;
        return topic;
    }

    private Optional<Object> getFieldData(Object[] row, String field) {
        int messageFieldIndex = this.getInputRowMeta().indexOfValue(field);
        Preconditions.checkArgument((messageFieldIndex > -1 ? 1 : 0) != 0, (Object)BaseMessages.getString(PKG, (String)"MQTTProducer.Error.FieldNotFound", (String[])new String[]{field}));
        return Optional.ofNullable(row[messageFieldIndex]);
    }

    public void stopRunning(StepMetaInterface stepMetaInterface, StepDataInterface stepDataInterface) throws KettleException {
        this.stopMqttClient();
        super.stopRunning(stepMetaInterface, stepDataInterface);
    }

    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        super.dispose(smi, sdi);
        this.stopMqttClient();
    }

    private void stopMqttClient() {
        try {
            if (!this.connectionError.get() && this.client.get() != null && ((MqttClient)this.client.get()).isConnected()) {
                this.log.logDebug(BaseMessages.getString(PKG, (String)"MQTTProducer.Log.Closing", (String[])new String[0]));
                ((MqttClient)this.client.get()).disconnect();
                ((MqttClient)this.client.get()).close();
            }
        }
        catch (IllegalArgumentException | MqttException e) {
            this.logError(e.getMessage());
        }
    }
}

