/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.general.Dataset;
import org.jfree.ui.RectangleEdge;
import org.pentaho.plugin.jfreereport.reportcharts.ChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.CollectorFunctionResult;
import org.pentaho.plugin.jfreereport.reportcharts.ColorHelper;
import org.pentaho.plugin.jfreereport.reportcharts.ICollectorFunction;
import org.pentaho.plugin.jfreereport.reportcharts.JFreeChartReportDrawable;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.DynamicExpression;
import org.pentaho.reporting.engine.classic.core.function.AbstractExpression;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.function.FormulaExpression;
import org.pentaho.reporting.engine.classic.core.function.ProcessingContext;
import org.pentaho.reporting.engine.classic.core.function.WrapperExpressionRuntime;
import org.pentaho.reporting.engine.classic.core.states.LegacyDataRowWrapper;
import org.pentaho.reporting.engine.classic.core.util.StrokeUtility;
import org.pentaho.reporting.engine.classic.core.util.beans.BeanUtility;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public abstract class AbstractChartExpression
extends AbstractExpression
implements ChartExpression,
DynamicExpression {
    public static final String LINE_STYLE_SOLID_STR = "solid";
    public static final String LINE_STYLE_DASH_STR = "dash";
    public static final String LINE_STYLE_DOT_STR = "dot";
    public static final String LINE_STYLE_DASHDOT_STR = "dashdot";
    public static final String LINE_STYLE_DASHDOTDOT_STR = "dashdotdot";
    protected static final Stroke EMPTY_STROKE = new BasicStroke(0.0f);
    private static final Log logger = LogFactory.getLog(AbstractChartExpression.class);
    private static final Map<String, RectangleEdge> LEGEND_LOCATIONS;
    private String dataSource;
    private String titleText;
    private String titleField;
    private String noDataMessage;
    private boolean antiAlias;
    private String legendLocation;
    private String titleFont;
    private String labelFont;
    private String legendFont;
    private Font itemLabelFont;
    private boolean showBorder;
    private String borderColor;
    private String backgroundColor;
    private Color plotBackgroundColor;
    private Color legendBackgroundColor;
    private float plotForegroundAlpha;
    private float plotBackgroundAlpha;
    private boolean drawLegendBorder;
    private Boolean itemsLabelVisible;
    private boolean showLegend;
    private boolean threeD;
    private boolean chartSectionOutline;
    private String backgroundImage;
    private HashMap<Object, JFreeChart> chartCache;
    private ArrayList<String> seriesColors = new ArrayList();
    private transient Image plotImageCache;
    private Color legendTextColor;
    private String postProcessingLanguage;
    private String postProcessingScript;
    private String tooltipFormula;
    private String urlFormula;
    private LinkedHashMap<String, Expression> expressionMap;

    protected AbstractChartExpression() {
        this.seriesColors.add("#ff6600");
        this.seriesColors.add("#fcd202");
        this.seriesColors.add("#b0de09");
        this.seriesColors.add("#0d8ecf");
        this.seriesColors.add("#2a0cd0");
        this.seriesColors.add("#cd0d74");
        this.seriesColors.add("#cc0000");
        this.seriesColors.add("#00cc00");
        this.seriesColors.add("#0000cc");
        this.seriesColors.add("#3a3a3a");
        this.seriesColors.add("#ffaa72");
        this.seriesColors.add("#fde673");
        this.seriesColors.add("#d3ed77");
        this.seriesColors.add("#79c1e4");
        this.seriesColors.add("#8979e5");
        this.seriesColors.add("#e379b2");
        this.seriesColors.add("#e37272");
        this.seriesColors.add("#72e372");
        this.seriesColors.add("#7272e3");
        this.seriesColors.add("#929292");
        this.seriesColors.add("#a64100");
        this.seriesColors.add("#a48901");
        this.seriesColors.add("#739106");
        this.seriesColors.add("#085c87");
        this.seriesColors.add("#1b0887");
        this.seriesColors.add("#85084c");
        this.seriesColors.add("#850000");
        this.seriesColors.add("#008500");
        this.seriesColors.add("#000085");
        this.seriesColors.add("#000000");
        this.backgroundColor = "#ffffff";
        this.drawLegendBorder = true;
        this.legendFont = "SansSerif--8";
        this.labelFont = "SansSerif--8";
        this.titleFont = "SansSerif-BOLD-14";
        this.legendLocation = "bottom";
        this.antiAlias = true;
        this.noDataMessage = "CHART.USER_NO_DATA_AVAILABLE";
        this.showLegend = true;
        this.chartCache = new HashMap();
        this.plotBackgroundAlpha = 1.0f;
        this.plotForegroundAlpha = 1.0f;
        this.expressionMap = new LinkedHashMap();
    }

    public Font getItemLabelFont() {
        return this.itemLabelFont;
    }

    public void setItemLabelFont(Font itemLabelFont) {
        this.itemLabelFont = itemLabelFont;
    }

    public String getTooltipFormula() {
        return this.tooltipFormula;
    }

    public void setTooltipFormula(String tooltipFormula) {
        this.tooltipFormula = tooltipFormula;
    }

    public String getUrlFormula() {
        return this.urlFormula;
    }

    public void setUrlFormula(String urlFormula) {
        this.urlFormula = urlFormula;
    }

    public String getPostProcessingLanguage() {
        return this.postProcessingLanguage;
    }

    public void setPostProcessingLanguage(String postProcessingLanguage) {
        this.postProcessingLanguage = postProcessingLanguage;
    }

    public String getPostProcessingScript() {
        return this.postProcessingScript;
    }

    public void setPostProcessingScript(String postProcessingScript) {
        this.postProcessingScript = postProcessingScript;
    }

    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public void setLegendBackgroundColor(Color legendBackgroundColor) {
        this.legendBackgroundColor = legendBackgroundColor;
    }

    public Color getLegendTextColor() {
        return this.legendTextColor;
    }

    public void setLegendTextColor(Color legendTextColor) {
        this.legendTextColor = legendTextColor;
    }

    public float getPlotForegroundAlpha() {
        return this.plotForegroundAlpha;
    }

    public void setPlotForegroundAlpha(float plotForegroundAlpha) {
        this.plotForegroundAlpha = plotForegroundAlpha;
    }

    public float getPlotBackgroundAlpha() {
        return this.plotBackgroundAlpha;
    }

    public void setPlotBackgroundAlpha(float plotBackgroundAlpha) {
        this.plotBackgroundAlpha = plotBackgroundAlpha;
    }

    public Color getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public void setPlotBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public String getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(String value) {
        this.titleFont = value;
    }

    public String getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(String value) {
        this.legendFont = value;
    }

    public String getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(String value) {
        this.labelFont = value;
    }

    @Override
    public String getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public String[] getHyperlinkFormulas() {
        if (!StringUtils.isEmpty((String)this.urlFormula)) {
            return new String[]{this.urlFormula};
        }
        return new String[0];
    }

    public String getTitleField() {
        return this.titleField;
    }

    public void setTitleField(String titleField) {
        this.titleField = titleField;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public boolean isAntiAlias() {
        return this.antiAlias;
    }

    public void setAntiAlias(boolean value) {
        this.antiAlias = value;
    }

    public String getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(String value) {
        this.borderColor = value;
    }

    public String getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String value) {
        this.backgroundColor = value;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean value) {
        this.showBorder = value;
    }

    public String getLegendLocation() {
        return this.legendLocation;
    }

    public void setLegendLocation(String value) {
        this.legendLocation = value;
    }

    public boolean isDrawLegendBorder() {
        return this.drawLegendBorder;
    }

    public void setDrawLegendBorder(boolean value) {
        this.drawLegendBorder = value;
    }

    public boolean isShowLegend() {
        return this.showLegend;
    }

    public void setShowLegend(boolean value) {
        this.showLegend = value;
    }

    public boolean isThreeD() {
        return this.threeD;
    }

    public void setThreeD(boolean value) {
        this.threeD = value;
    }

    public boolean isChartSectionOutline() {
        return this.chartSectionOutline;
    }

    public void setChartSectionOutline(boolean value) {
        this.chartSectionOutline = value;
    }

    public String getNoDataMessage() {
        return this.noDataMessage;
    }

    public void setNoDataMessage(String noDataMessage) {
        this.noDataMessage = noDataMessage;
    }

    public void setBackgroundImage(String value) {
        this.backgroundImage = value;
        this.plotImageCache = null;
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public Boolean getItemsLabelVisible() {
        return this.itemsLabelVisible;
    }

    public void setItemsLabelVisible(Boolean itemsLabelVisible) {
        this.itemsLabelVisible = itemsLabelVisible;
    }

    public void setSeriesColor(int index, String field) {
        if (this.seriesColors.size() == index) {
            this.seriesColors.add(field);
        } else {
            this.seriesColors.set(index, field);
        }
    }

    public String getSeriesColor(int index) {
        return this.seriesColors.get(index);
    }

    public int getSeriesColorCount() {
        return this.seriesColors.size();
    }

    public String[] getSeriesColor() {
        return this.seriesColors.toArray(new String[this.seriesColors.size()]);
    }

    public void setSeriesColor(String[] fields) {
        this.seriesColors.clear();
        this.seriesColors.addAll(Arrays.asList(fields));
    }

    public Map<String, Expression> getExpressionMap() {
        return new LinkedHashMap<String, Expression>(this.expressionMap);
    }

    public void setExpressionMap(Map<String, Expression> values) {
        this.expressionMap.clear();
        this.expressionMap.putAll(values);
    }

    public void addExpression(String property, Expression e) {
        this.expressionMap.put(property, e);
    }

    public void removeExpression(String property) {
        this.expressionMap.remove(property);
    }

    protected void storeChartInCache(Object key, JFreeChart chart) {
        if (key == null) {
            return;
        }
        if (chart == null) {
            throw new NullPointerException();
        }
        this.chartCache.put(key, chart);
    }

    protected JFreeChart loadChartFromCache(Object key) {
        if (key == null) {
            return null;
        }
        JFreeChart o = this.chartCache.get(key);
        if (o != null) {
            return o;
        }
        return null;
    }

    public Expression getInstance() {
        AbstractChartExpression instance = (AbstractChartExpression)super.getInstance();
        instance.chartCache = (HashMap)instance.chartCache.clone();
        instance.chartCache.clear();
        instance.seriesColors = (ArrayList)this.seriesColors.clone();
        instance.plotImageCache = null;
        instance.expressionMap = (LinkedHashMap)this.expressionMap.clone();
        for (Map.Entry<String, Expression> entry : this.expressionMap.entrySet()) {
            entry.setValue(entry.getValue().getInstance());
        }
        return instance;
    }

    public Object getValue() {
        try {
            JFreeChart chart;
            Object cacheKey;
            Dataset dataset;
            Object collector;
            for (Map.Entry<String, Expression> pair : this.expressionMap.entrySet()) {
                FormulaExpression formulaExpression = (FormulaExpression)pair.getValue();
                formulaExpression.setRuntime(this.getRuntime());
                Object o = formulaExpression.getValue();
                BeanUtility beanUtility = new BeanUtility((Object)this);
                Class propertyType = beanUtility.getPropertyType(pair.getKey());
                beanUtility.setPropertyAsString(pair.getKey(), propertyType, String.valueOf(o));
            }
            Object maybeCollector = this.getDataRow().get(this.getDataSource());
            if (maybeCollector instanceof ICollectorFunction) {
                collector = (ICollectorFunction)maybeCollector;
                dataset = (Dataset)collector.getDatasourceValue();
                cacheKey = collector.getCacheKey();
            } else if (maybeCollector instanceof CollectorFunctionResult) {
                collector = (CollectorFunctionResult)maybeCollector;
                dataset = collector.getDataSet();
                cacheKey = collector.getCacheKey();
            } else {
                logger.debug((Object)"CATEGORICALCHARTEXPRESSION.USER_NOT_A_DATASET");
                return null;
            }
            if (dataset == null) {
                return null;
            }
            Object key = cacheKey != null ? cacheKey : this.getName();
            JFreeChart chartFromCache = this.loadChartFromCache(key);
            if (chartFromCache != null) {
                chart = chartFromCache;
            } else {
                chart = this.computeChart(dataset);
                if (chart == null) {
                    return null;
                }
                this.storeChartInCache(key, chart);
            }
            this.configureChart(chart);
            this.postProcessChart(chart);
            return new JFreeChartReportDrawable(chart, !StringUtils.isEmpty((String)this.getUrlFormula()) || !StringUtils.isEmpty((String)this.getTooltipFormula()));
        }
        catch (Exception e) {
            logger.error((Object)"Failed to configure chart", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JFreeChart postProcessChart(JFreeChart originalChart) {
        if (this.postProcessingLanguage == null || this.postProcessingScript == null) {
            return originalChart;
        }
        LegacyDataRowWrapper legacyDataRowWrapper = new LegacyDataRowWrapper();
        WrapperExpressionRuntime runtimeWrapper = new WrapperExpressionRuntime();
        runtimeWrapper.update(null, this.getRuntime());
        legacyDataRowWrapper.setParent(this.getDataRow());
        try {
            BSFManager interpreter = new BSFManager();
            interpreter.declareBean("chartExpression", (Object)this, this.getClass());
            interpreter.declareBean("chart", (Object)originalChart, JFreeChart.class);
            interpreter.declareBean("runtime", (Object)runtimeWrapper, ExpressionRuntime.class);
            interpreter.declareBean("dataRow", (Object)legacyDataRowWrapper, DataRow.class);
            Object o = interpreter.eval(this.postProcessingLanguage, "expression", 1, 1, (Object)this.postProcessingScript);
            if (o instanceof JFreeChart) {
                JFreeChart jFreeChart = (JFreeChart)o;
                return jFreeChart;
            }
            JFreeChart jFreeChart = originalChart;
            return jFreeChart;
        }
        catch (BSFException e) {
            logger.warn((Object)"Failed to evaluate post processing script", (Throwable)e);
        }
        finally {
            legacyDataRowWrapper.setParent(null);
            runtimeWrapper.update(null, null);
        }
        return originalChart;
    }

    protected JFreeChart computeChart(Dataset dataset) {
        return null;
    }

    protected void configureChart(JFreeChart chart) {
        TextTitle chartTitle = chart.getTitle();
        if (chartTitle != null) {
            Font titleFont = Font.decode(this.getTitleFont());
            chartTitle.setFont(titleFont);
        }
        if (!this.isAntiAlias()) {
            chart.setAntiAlias(false);
        }
        chart.setBorderVisible(this.isShowBorder());
        Color backgroundColor = this.parseColorFromString(this.getBackgroundColor());
        if (backgroundColor != null) {
            chart.setBackgroundPaint((Paint)backgroundColor);
        }
        if (this.plotBackgroundColor != null) {
            chart.getPlot().setBackgroundPaint((Paint)this.plotBackgroundColor);
        }
        chart.getPlot().setBackgroundAlpha(this.plotBackgroundAlpha);
        chart.getPlot().setForegroundAlpha(this.plotForegroundAlpha);
        Color borderCol = this.parseColorFromString(this.getBorderColor());
        if (borderCol != null) {
            chart.setBorderPaint((Paint)borderCol);
        }
        if (!this.isShowLegend()) {
            chart.removeLegend();
        } else {
            LegendTitle chLegend = chart.getLegend();
            if (chLegend != null) {
                RectangleEdge loc = this.translateEdge(this.legendLocation.toLowerCase());
                if (loc != null) {
                    chLegend.setPosition(loc);
                }
                if (this.getLegendFont() != null) {
                    chLegend.setItemFont(Font.decode(this.getLegendFont()));
                }
                if (!this.isDrawLegendBorder()) {
                    chLegend.setBorder(BlockBorder.NONE);
                }
                if (this.legendBackgroundColor != null) {
                    chLegend.setBackgroundPaint((Paint)this.legendBackgroundColor);
                }
                if (this.legendTextColor != null) {
                    chLegend.setItemPaint((Paint)this.legendTextColor);
                }
            }
        }
        Plot plot = chart.getPlot();
        plot.setNoDataMessageFont(Font.decode(this.getLabelFont()));
        String message = this.getNoDataMessage();
        if (message != null) {
            plot.setNoDataMessage(message);
        }
        plot.setOutlineVisible(this.isChartSectionOutline());
        if (this.backgroundImage != null) {
            if (this.plotImageCache != null) {
                plot.setBackgroundImage(this.plotImageCache);
            } else {
                ExpressionRuntime expressionRuntime = this.getRuntime();
                ProcessingContext context = expressionRuntime.getProcessingContext();
                ResourceKey contentBase = context.getContentBase();
                ResourceManager manager = context.getResourceManager();
                try {
                    ResourceKey key = this.createKeyFromString(manager, contentBase, this.backgroundImage);
                    Resource resource = manager.create(key, null, Image.class);
                    Image image = (Image)resource.getResource();
                    plot.setBackgroundImage(image);
                    this.plotImageCache = image;
                }
                catch (Exception e) {
                    logger.error((Object)"ABSTRACTCHARTEXPRESSION.ERROR_0007_ERROR_RETRIEVING_PLOT_IMAGE", (Throwable)e);
                    throw new IllegalStateException("Failed to process chart");
                }
            }
        }
    }

    private ResourceKey createKeyFromString(ResourceManager resourceManager, ResourceKey contextKey, String file) {
        try {
            if (contextKey != null) {
                return resourceManager.deriveKey(contextKey, file);
            }
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load background-image as derived path: " + (Object)((Object)re)));
        }
        try {
            return resourceManager.createKey((Object)new URL(file));
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load background-image as URL: " + (Object)((Object)re)));
        }
        catch (MalformedURLException re) {
            // empty catch block
        }
        try {
            return resourceManager.createKey((Object)new File(file));
        }
        catch (ResourceException re) {
            logger.debug((Object)("Failed to load background-image as file: " + (Object)((Object)re)));
            return null;
        }
    }

    protected Color parseColorFromString(String colStr) {
        if (colStr == null) {
            return null;
        }
        try {
            return Color.decode(colStr);
        }
        catch (NumberFormatException numberFormatException) {
            return ColorHelper.lookupColor(colStr);
        }
    }

    protected String computeTitle() {
        Object computedTitle;
        if (this.titleField != null && (computedTitle = this.getDataRow().get(this.titleField)) != null) {
            return String.valueOf(computedTitle);
        }
        if (this.titleText != null && (computedTitle = this.getDataRow().get(this.titleText)) != null) {
            return String.valueOf(computedTitle);
        }
        return this.titleText;
    }

    protected RectangleEdge translateEdge(String edge) {
        RectangleEdge translatedEdge = LEGEND_LOCATIONS.get(edge);
        if (translatedEdge != null) {
            return translatedEdge;
        }
        return RectangleEdge.LEFT;
    }

    public int getDependencyLevel() {
        return -2;
    }

    public void setDependencyLevel(int ignored) {
    }

    public static Stroke translateLineStyle(float lineWidth, String lineStyle) {
        if (lineWidth < 0.0f) {
            logger.error((Object)"LineChartExpression.ERROR_0001_INVALID_LINE_WIDTH");
            lineWidth = 1.0f;
        }
        int strokeType = LINE_STYLE_DASH_STR.equals(lineStyle) ? 1 : (LINE_STYLE_DOT_STR.equals(lineStyle) ? 2 : (LINE_STYLE_DASHDOT_STR.equals(lineStyle) ? 3 : (LINE_STYLE_DASHDOTDOT_STR.equals(lineStyle) ? 4 : (lineWidth == 0.0f ? 5 : 0))));
        return StrokeUtility.createStroke((int)strokeType, (float)lineWidth);
    }

    public void setChartWidth(int value) {
    }

    public int getChartWidth() {
        return 0;
    }

    public void setChartHeight(int value) {
    }

    public int getChartHeight() {
        return 0;
    }

    public void setChartDirectory(String value) {
    }

    public void setChartFile(String value) {
    }

    public void setChartUrlMask(String value) {
    }

    public String getChartDirectory() {
        return null;
    }

    public String getChartFile() {
        return null;
    }

    public String getChartUrlMask() {
        return null;
    }

    public boolean isReturnFileNameOnly() {
        return false;
    }

    public void setReturnFileNameOnly(boolean value) {
    }

    public boolean isReturnImageReference() {
        return false;
    }

    public void setReturnImageReference(boolean value) {
    }

    public JFreeChart getChartFromCache(Object key) {
        if (key == null) {
            return null;
        }
        return this.loadChartFromCache(key);
    }

    public void putChartInCache(JFreeChart chart, Object key) {
        if (chart == null || key == null) {
            return;
        }
        this.storeChartInCache(key, chart);
    }

    public boolean isUseDrawable() {
        return true;
    }

    public void setUseDrawable(boolean value) {
    }

    protected Color getColorFromString(String colStr) {
        return this.parseColorFromString(colStr);
    }

    public String getPossibleExpressionStringValue(String lookupValue) {
        if (lookupValue == null) {
            return null;
        }
        Object maybeExpression = null;
        try {
            maybeExpression = this.getDataRow().get(lookupValue);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (maybeExpression != null) {
            return maybeExpression.toString();
        }
        return lookupValue;
    }

    protected void standardTickUnitsApplyFormat(NumberAxis numberAxis, NumberFormat format) {
        TickUnits standardTickUnits = (TickUnits)numberAxis.getStandardTickUnits();
        TickUnits cutTickUnits = new TickUnits();
        double formatterMinSize = 1.0 / Math.pow(10.0, format.getMaximumFractionDigits());
        for (int i = 0; i < standardTickUnits.size(); ++i) {
            if (Double.compare(standardTickUnits.get(i).getSize(), formatterMinSize) < 0) continue;
            cutTickUnits.add((TickUnit)new NumberTickUnit(standardTickUnits.get(i).getSize()));
        }
        numberAxis.setStandardTickUnits((TickUnitSource)cutTickUnits);
    }

    public String getTitle() {
        return this.getPossibleExpressionStringValue(this.getTitleText());
    }

    public void setTitle(String title) {
        this.titleText = title;
    }

    public List getSeriesColors() {
        return this.seriesColors;
    }

    static {
        HashMap<String, RectangleEdge> locations = new HashMap<String, RectangleEdge>();
        locations.put("left", RectangleEdge.LEFT);
        locations.put("west", RectangleEdge.LEFT);
        locations.put("right", RectangleEdge.RIGHT);
        locations.put("east", RectangleEdge.RIGHT);
        locations.put("top", RectangleEdge.TOP);
        locations.put("north", RectangleEdge.TOP);
        locations.put("bottom", RectangleEdge.BOTTOM);
        locations.put("south", RectangleEdge.BOTTOM);
        LEGEND_LOCATIONS = Collections.unmodifiableMap(locations);
    }
}

