/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.plugin.jfreereport.reportcharts;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.SpiderWebPlot;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.jfree.util.TableOrder;
import org.pentaho.plugin.jfreereport.reportcharts.AbstractChartExpression;
import org.pentaho.plugin.jfreereport.reportcharts.ColorHelper;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaCategoryTooltipGenerator;
import org.pentaho.plugin.jfreereport.reportcharts.FormulaCategoryURLGenerator;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class RadarChartExpression
extends AbstractChartExpression {
    private static final long serialVersionUID = 7082583397390897215L;
    private float gridintervall = -25.0f;
    private boolean drawgrid = true;
    private boolean radarwebfilled;
    private double headsize = 0.001;
    private float thicknessprimaryseries = 2.0f;

    @Override
    protected JFreeChart computeChart(Dataset dataset) {
        DefaultCategoryDataset defaultDataset = new DefaultCategoryDataset();
        if (dataset instanceof DefaultCategoryDataset) {
            defaultDataset = (DefaultCategoryDataset)dataset;
        }
        if (this.drawgrid) {
            this.initializeGrid(defaultDataset);
        }
        ExtendedSpiderWebPlot plot = new ExtendedSpiderWebPlot((CategoryDataset)defaultDataset);
        for (int i = 0; i < this.getSeriesColor().length; ++i) {
            Color seriesColor;
            String colorDef = this.getSeriesColor(i);
            if (colorDef == null) {
                seriesColor = Color.RED;
            } else {
                seriesColor = ColorHelper.lookupColor(colorDef);
                if (seriesColor == null) {
                    seriesColor = Color.decode(colorDef);
                }
            }
            plot.setSeriesPaint(i, seriesColor);
        }
        return new JFreeChart(this.computeTitle(), JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, this.isShowLegend());
    }

    private void initializeGrid(DefaultCategoryDataset defaultDataset) {
        block7: {
            double gridIntervalIncrement;
            block6: {
                if (!(this.gridintervall < 0.0f)) break block6;
                double gridIntervalIncrement2 = -this.gridintervall;
                if (100.0 / gridIntervalIncrement2 > 5000.0) {
                    return;
                }
                int columns = defaultDataset.getColumnCount();
                double maxdata = this.computeMaxValue(defaultDataset);
                NumberFormat format = NumberFormat.getPercentInstance(this.getRuntime().getResourceBundleFactory().getLocale());
                for (double gridline = gridIntervalIncrement2; gridline <= 100.0; gridline += gridIntervalIncrement2) {
                    double gridScaled = maxdata * gridline / 100.0;
                    String gridLineText = format.format(gridline / 100.0);
                    GridCategoryItem rowKey = new GridCategoryItem(gridLineText);
                    for (int i = 0; i < columns; ++i) {
                        defaultDataset.addValue(gridScaled, (Comparable)rowKey, defaultDataset.getColumnKey(i));
                    }
                }
                break block7;
            }
            if (!(this.gridintervall > 0.0f)) break block7;
            int columns = defaultDataset.getColumnCount();
            double maxdata = this.computeMaxValue(defaultDataset);
            if (maxdata / (gridIntervalIncrement = (double)this.gridintervall) > 5000.0) {
                return;
            }
            NumberFormat format = NumberFormat.getNumberInstance(this.getRuntime().getResourceBundleFactory().getLocale());
            double gridline = 0.0;
            while (gridline < maxdata) {
                String gridLineText = format.format(gridline += gridIntervalIncrement);
                GridCategoryItem rowKey = new GridCategoryItem(gridLineText);
                for (int i = 0; i < columns; ++i) {
                    defaultDataset.addValue(gridline, (Comparable)rowKey, defaultDataset.getColumnKey(i));
                }
            }
        }
    }

    private double computeMaxValue(DefaultCategoryDataset defaultDataset) {
        int rows = defaultDataset.getRowCount();
        int columns = defaultDataset.getColumnCount();
        double maxdata = 0.01;
        for (int r = 0; r < rows; ++r) {
            for (int cc = 0; cc < columns; ++cc) {
                Number value = defaultDataset.getValue(r, cc);
                if (value == null || !(value.doubleValue() > maxdata)) continue;
                maxdata = value.doubleValue();
            }
        }
        return maxdata;
    }

    @Override
    protected void configureChart(JFreeChart chart) {
        int t;
        super.configureChart(chart);
        BasicStroke thick = new BasicStroke(this.thicknessprimaryseries);
        SpiderWebPlot webPlot = (SpiderWebPlot)chart.getPlot();
        webPlot.setLabelFont(Font.decode(this.getLabelFont()));
        if (!StringUtils.isEmpty((String)this.getTooltipFormula())) {
            webPlot.setToolTipGenerator((CategoryToolTipGenerator)new FormulaCategoryTooltipGenerator(this.getRuntime(), this.getTooltipFormula()));
        }
        if (!StringUtils.isEmpty((String)this.getUrlFormula())) {
            webPlot.setURLGenerator((CategoryURLGenerator)new FormulaCategoryURLGenerator(this.getRuntime(), this.getUrlFormula()));
        }
        CategoryDataset categoryDataset = webPlot.getDataset();
        int count = categoryDataset.getRowCount();
        for (t = 0; t < count; ++t) {
            if (categoryDataset.getRowKey(t) instanceof GridCategoryItem) continue;
            webPlot.setSeriesOutlineStroke(t, (Stroke)thick);
        }
        webPlot.setWebFilled(this.radarwebfilled);
        webPlot.setHeadPercent(this.headsize);
        for (t = 0; t < count; ++t) {
            if (!(categoryDataset.getRowKey(t) instanceof GridCategoryItem)) continue;
            webPlot.setSeriesPaint(t, (Paint)Color.GRAY);
        }
    }

    public void setGridintervall(float gridintervall) {
        this.gridintervall = gridintervall;
    }

    public float getGridintervall() {
        return this.gridintervall;
    }

    public void setDrawgrid(boolean drawgrid) {
        this.drawgrid = drawgrid;
    }

    public boolean isDrawgrid() {
        return this.drawgrid;
    }

    public void setRadarwebfilled(boolean radarwebfilled) {
        this.radarwebfilled = radarwebfilled;
    }

    public boolean isRadarwebfilled() {
        return this.radarwebfilled;
    }

    public void setHeadsize(double headsize) {
        this.headsize = headsize;
    }

    public double getHeadsize() {
        return this.headsize;
    }

    public void setThicknessprimaryseries(float thicknessprimaryseries) {
        this.thicknessprimaryseries = thicknessprimaryseries;
    }

    public float getThicknessprimaryseries() {
        return this.thicknessprimaryseries;
    }

    private static class ExtendedSpiderWebPlot
    extends SpiderWebPlot {
        public ExtendedSpiderWebPlot(CategoryDataset dataset) {
            super(dataset);
        }

        public LegendItemCollection getLegendItems() {
            LegendItemCollection result = new LegendItemCollection();
            if (this.getDataset() == null) {
                return result;
            }
            List keys = null;
            CategoryDataset dataset = this.getDataset();
            TableOrder dataExtractOrder = this.getDataExtractOrder();
            if (dataExtractOrder == TableOrder.BY_ROW) {
                keys = dataset.getRowKeys();
            } else if (dataExtractOrder == TableOrder.BY_COLUMN) {
                keys = dataset.getColumnKeys();
            }
            if (keys == null) {
                return result;
            }
            int series = 0;
            Iterator iterator = keys.iterator();
            Shape shape = this.getLegendItemShape();
            while (iterator.hasNext()) {
                Comparable key = (Comparable)iterator.next();
                if (key instanceof GridCategoryItem) continue;
                String label = key.toString();
                Paint paint = this.getSeriesPaint(series);
                Paint outlinePaint = this.getSeriesOutlinePaint(series);
                Stroke stroke = this.getSeriesOutlineStroke(series);
                LegendItem item = new LegendItem(label, label, null, null, shape, paint, stroke, outlinePaint);
                item.setDataset((Dataset)this.getDataset());
                item.setSeriesKey(key);
                item.setSeriesIndex(series);
                result.add(item);
                ++series;
            }
            return result;
        }
    }

    private static class GridCategoryItem
    implements Comparable {
        private String text;

        private GridCategoryItem(String text) {
            if (text == null) {
                throw new NullPointerException();
            }
            this.text = text;
        }

        public int compareTo(Object o) {
            GridCategoryItem gci = (GridCategoryItem)o;
            return this.text.compareTo(gci.text);
        }

        public String toString() {
            return this.text;
        }
    }
}

