/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.parquet.io.SeekableInputStream;

class H1SeekableInputStream
extends SeekableInputStream {
    private final int COPY_BUFFER_SIZE = 8192;
    private final byte[] temp = new byte[8192];
    private final FSDataInputStream stream;

    public H1SeekableInputStream(FSDataInputStream stream) {
        this.stream = stream;
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    @Override
    public long getPos() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void seek(long newPos) throws IOException {
        this.stream.seek(newPos);
    }

    @Override
    public int read() throws IOException {
        return this.stream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public void readFully(byte[] bytes) throws IOException {
        this.stream.readFully(bytes, 0, bytes.length);
    }

    @Override
    public void readFully(byte[] bytes, int start, int len) throws IOException {
        this.stream.readFully(bytes);
    }

    @Override
    public int read(ByteBuffer buf) throws IOException {
        if (buf.hasArray()) {
            return H1SeekableInputStream.readHeapBuffer(this.stream, buf);
        }
        return H1SeekableInputStream.readDirectBuffer(this.stream, buf, this.temp);
    }

    @Override
    public void readFully(ByteBuffer buf) throws IOException {
        if (buf.hasArray()) {
            H1SeekableInputStream.readFullyHeapBuffer(this.stream, buf);
        } else {
            H1SeekableInputStream.readFullyDirectBuffer(this.stream, buf, this.temp);
        }
    }

    static int readHeapBuffer(FSDataInputStream f, ByteBuffer buf) throws IOException {
        int bytesRead = f.read(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        if (bytesRead < 0) {
            return bytesRead;
        }
        buf.position(buf.position() + bytesRead);
        return bytesRead;
    }

    static void readFullyHeapBuffer(FSDataInputStream f, ByteBuffer buf) throws IOException {
        f.readFully(buf.array(), buf.arrayOffset() + buf.position(), buf.remaining());
        buf.position(buf.limit());
    }

    static int readDirectBuffer(FSDataInputStream f, ByteBuffer buf, byte[] temp) throws IOException {
        int bytesRead;
        int nextReadLength = Math.min(buf.remaining(), temp.length);
        int totalBytesRead = 0;
        while ((bytesRead = f.read(temp, 0, nextReadLength)) == temp.length) {
            buf.put(temp);
            totalBytesRead += bytesRead;
            nextReadLength = Math.min(buf.remaining(), temp.length);
        }
        if (bytesRead < 0) {
            return totalBytesRead == 0 ? -1 : totalBytesRead;
        }
        buf.put(temp, 0, bytesRead);
        return totalBytesRead += bytesRead;
    }

    static void readFullyDirectBuffer(FSDataInputStream f, ByteBuffer buf, byte[] temp) throws IOException {
        int nextReadLength = Math.min(buf.remaining(), temp.length);
        int bytesRead = 0;
        while (nextReadLength > 0 && (bytesRead = f.read(temp, 0, nextReadLength)) >= 0) {
            buf.put(temp, 0, bytesRead);
            nextReadLength = Math.min(buf.remaining(), temp.length);
        }
        if (bytesRead < 0 && buf.remaining() > 0) {
            throw new EOFException("Reached the end of stream. Still have: " + buf.remaining() + " bytes left");
        }
    }
}

