/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseConnectionPoolParameter;
import org.pentaho.di.core.database.DatabaseFactory;
import org.pentaho.di.core.database.DatabaseInterfaceExtended;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.PartitionDatabaseMeta;
import org.pentaho.di.core.database.SqlScriptStatement;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.repository.ObjectId;

public abstract class BaseDatabaseMeta
implements Cloneable,
DatabaseInterfaceExtended {
    public static final String ATTRIBUTE_PORT_NUMBER = "PORT_NUMBER";
    public static final String ATTRIBUTE_SQL_CONNECT = "SQL_CONNECT";
    public static final String ATTRIBUTE_USE_POOLING = "USE_POOLING";
    public static final String ATTRIBUTE_MAXIMUM_POOL_SIZE = "MAXIMUM_POOL_SIZE";
    public static final String ATTRIBUTE_INITIAL_POOL_SIZE = "INITIAL_POOL_SIZE";
    public static final String ATTRIBUTE_PREFIX_EXTRA_OPTION = "EXTRA_OPTION_";
    public static final String ATTRIBUTE_IS_CLUSTERED = "IS_CLUSTERED";
    private static final String ATTRIBUTE_CLUSTER_PARTITION_PREFIX = "CLUSTER_PARTITION_";
    public static final String ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX = "CLUSTER_HOSTNAME_";
    public static final String ATTRIBUTE_CLUSTER_PORT_PREFIX = "CLUSTER_PORT_";
    public static final String ATTRIBUTE_CLUSTER_DBNAME_PREFIX = "CLUSTER_DBNAME_";
    public static final String ATTRIBUTE_CLUSTER_USERNAME_PREFIX = "CLUSTER_USERNAME_";
    public static final String ATTRIBUTE_CLUSTER_PASSWORD_PREFIX = "CLUSTER_PASSWORD_";
    public static final String ATTRIBUTE_POOLING_PARAMETER_PREFIX = "POOLING_";
    public static final String ATTRIBUTE_USE_RESULT_STREAMING = "STREAM_RESULTS";
    public static final String ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR = "MSSQL_DOUBLE_DECIMAL_SEPARATOR";
    public static final String ATTRIBUTE_QUOTE_ALL_FIELDS = "QUOTE_ALL_FIELDS";
    public static final String ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE = "FORCE_IDENTIFIERS_TO_LOWERCASE";
    public static final String ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE = "FORCE_IDENTIFIERS_TO_UPPERCASE";
    public static final String ATTRIBUTE_PREFERRED_SCHEMA_NAME = "PREFERRED_SCHEMA_NAME";
    public static final String ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE = "SUPPORTS_BOOLEAN_DATA_TYPE";
    public static final String ATTRIBUTE_SUPPORTS_TIMESTAMP_DATA_TYPE = "SUPPORTS_TIMESTAMP_DATA_TYPE";
    public static final String ATTRIBUTE_PRESERVE_RESERVED_WORD_CASE = "PRESERVE_RESERVED_WORD_CASE";
    public static final String SEQUENCE_FOR_BATCH_ID = "SEQUENCE_FOR_BATCH_ID";
    public static final String AUTOINCREMENT_SQL_FOR_BATCH_ID = "AUTOINCREMENT_SQL_FOR_BATCH_ID";
    protected boolean releaseSavepoint = true;
    public static final String SELECT_COUNT_STATEMENT = "select count(*) FROM";
    public static final DatabaseConnectionPoolParameter[] poolingParameters = new DatabaseConnectionPoolParameter[]{new DatabaseConnectionPoolParameter("defaultAutoCommit", "true", "The default auto-commit state of connections created by this pool."), new DatabaseConnectionPoolParameter("defaultReadOnly", null, "The default read-only state of connections created by this pool.\nIf not set then the setReadOnly method will not be called.\n (Some drivers don't support read only mode, ex: Informix)"), new DatabaseConnectionPoolParameter("defaultTransactionIsolation", null, "the default TransactionIsolation state of connections created by this pool. One of the following: (see javadoc)\n\n  * NONE\n  * READ_COMMITTED\n  * READ_UNCOMMITTED\n  * REPEATABLE_READ  * SERIALIZABLE\n"), new DatabaseConnectionPoolParameter("defaultCatalog", null, "The default catalog of connections created by this pool."), new DatabaseConnectionPoolParameter("initialSize", "0", "The initial number of connections that are created when the pool is started."), new DatabaseConnectionPoolParameter("maxActive", "8", "The maximum number of active connections that can be allocated from this pool at the same time, or non-positive for no limit."), new DatabaseConnectionPoolParameter("maxIdle", "8", "The maximum number of connections that can remain idle in the pool, without extra ones being released, or negative for no limit."), new DatabaseConnectionPoolParameter("minIdle", "0", "The minimum number of connections that can remain idle in the pool, without extra ones being created, or zero to create none."), new DatabaseConnectionPoolParameter("maxWait", "-1", "The maximum number of milliseconds that the pool will wait (when there are no available connections) for a connection to be returned before throwing an exception, or -1 to wait indefinitely."), new DatabaseConnectionPoolParameter("validationQuery", null, "The SQL query that will be used to validate connections from this pool before returning them to the caller.\nIf specified, this query MUST be an SQL SELECT statement that returns at least one row."), new DatabaseConnectionPoolParameter("testOnBorrow", "true", "The indication of whether objects will be validated before being borrowed from the pool.\nIf the object fails to validate, it will be dropped from the pool, and we will attempt to borrow another.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("testOnReturn", "false", "The indication of whether objects will be validated before being returned to the pool.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("testWhileIdle", "false", "The indication of whether objects will be validated by the idle object evictor (if any). If an object fails to validate, it will be dropped from the pool.\nNOTE - for a true value to have any effect, the validationQuery parameter must be set to a non-null string."), new DatabaseConnectionPoolParameter("timeBetweenEvictionRunsMillis", null, "The number of milliseconds to sleep between runs of the idle object evictor thread. When non-positive, no idle object evictor thread will be run."), new DatabaseConnectionPoolParameter("poolPreparedStatements", "false", "Enable prepared statement pooling for this pool."), new DatabaseConnectionPoolParameter("maxOpenPreparedStatements", "-1", "The maximum number of open statements that can be allocated from the statement pool at the same time, or zero for no limit."), new DatabaseConnectionPoolParameter("accessToUnderlyingConnectionAllowed", "false", "Controls if the PoolGuard allows access to the underlying connection."), new DatabaseConnectionPoolParameter("removeAbandoned", "false", "Flag to remove abandoned connections if they exceed the removeAbandonedTimout.\nIf set to true a connection is considered abandoned and eligible for removal if it has been idle longer than the removeAbandonedTimeout. Setting this to true can recover db connections from poorly written applications which fail to close a connection."), new DatabaseConnectionPoolParameter("removeAbandonedTimeout", "300", "Timeout in seconds before an abandoned connection can be removed."), new DatabaseConnectionPoolParameter("logAbandoned", "false", "Flag to log stack traces for application code which abandoned a Statement or Connection.\nLogging of abandoned Statements and Connections adds overhead for every Connection open or new Statement because a stack trace has to be generated.")};
    private static final String FIELDNAME_PROTECTOR = "_";
    private String name;
    private String displayName;
    private int accessType;
    private String hostname;
    private String databaseName;
    private String username;
    private String password;
    private String servername;
    private String dataTablespace;
    private String indexTablespace;
    private boolean changed = false;
    private Properties attributes = new Properties();
    private ObjectId objectId;
    private String pluginId;
    private String pluginName;

    public BaseDatabaseMeta() {
        if (this.getAccessTypeList() != null && this.getAccessTypeList().length > 0) {
            this.accessType = this.getAccessTypeList()[0];
        }
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    @Override
    public abstract int[] getAccessTypeList();

    @Override
    public int getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(int accessType) {
        this.accessType = accessType;
        if (this.accessType == 4) {
            this.username = "";
            this.password = "";
        }
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        if (this.getDisplayName() == null || this.getDisplayName().length() == 0) {
            this.setDisplayName(name);
        }
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    @Override
    public void setDatabasePortNumberString(String databasePortNumberString) {
        if (databasePortNumberString != null) {
            this.getAttributes().put(ATTRIBUTE_PORT_NUMBER, databasePortNumberString);
        }
    }

    @Override
    public String getDatabasePortNumberString() {
        return this.getAttributes().getProperty(ATTRIBUTE_PORT_NUMBER, "-1");
    }

    @Override
    public String getHostname() {
        return this.hostname;
    }

    @Override
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @Override
    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(ObjectId id) {
        this.objectId = id;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = this.accessType == 4 ? "" : password;
    }

    @Override
    public String getServername() {
        return this.servername;
    }

    @Override
    public void setServername(String servername) {
        this.servername = servername;
    }

    @Override
    public String getDataTablespace() {
        return this.dataTablespace;
    }

    @Override
    public void setDataTablespace(String dataTablespace) {
        this.dataTablespace = dataTablespace;
    }

    @Override
    public String getIndexTablespace() {
        return this.indexTablespace;
    }

    @Override
    public void setIndexTablespace(String indexTablespace) {
        this.indexTablespace = indexTablespace;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        if (this.accessType == 4) {
            this.username = "";
        }
        this.username = username;
    }

    @Override
    public Properties getAttributes() {
        return this.attributes;
    }

    @Override
    public void setAttributes(Properties attributes) {
        this.attributes = attributes;
    }

    @Override
    public Object clone() {
        BaseDatabaseMeta retval = null;
        try {
            retval = (BaseDatabaseMeta)super.clone();
            retval.attributes = (Properties)this.attributes.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        return retval;
    }

    @Override
    public int getDefaultDatabasePort() {
        return -1;
    }

    @Override
    public Map<String, String> getDefaultOptions() {
        return Collections.emptyMap();
    }

    @Override
    public boolean supportsSetCharacterStream() {
        return true;
    }

    @Override
    public boolean supportsAutoInc() {
        return true;
    }

    @Override
    public String getLimitClause(int nrRows) {
        return "";
    }

    @Override
    public int getNotFoundTK(boolean use_autoinc) {
        return 0;
    }

    @Override
    public String getSQLNextSequenceValue(String sequenceName) {
        return "";
    }

    @Override
    public String getSQLCurrentSequenceValue(String sequenceName) {
        return "";
    }

    @Override
    public String getSQLSequenceExists(String sequenceName) {
        return "";
    }

    @Override
    public boolean isFetchSizeSupported() {
        return true;
    }

    @Override
    public boolean needsPlaceHolder() {
        return false;
    }

    @Override
    public boolean supportsSchemas() {
        return true;
    }

    @Override
    public boolean supportsCatalogs() {
        return true;
    }

    @Override
    public boolean supportsEmptyTransactions() {
        return true;
    }

    @Override
    public String getFunctionSum() {
        return "SUM";
    }

    @Override
    public String getFunctionAverage() {
        return "AVG";
    }

    @Override
    public String getFunctionMinimum() {
        return "MIN";
    }

    @Override
    public String getFunctionMaximum() {
        return "MAX";
    }

    @Override
    public String getFunctionCount() {
        return "COUNT";
    }

    @Override
    public String getSchemaTableCombination(String schema_name, String table_part) {
        return schema_name + "." + table_part;
    }

    @Deprecated
    public String getBackwardsCompatibleSchemaTableCombination(String schemaPart, String tablePart) {
        String schemaTable = "";
        schemaTable = schemaPart != null && (schemaPart.contains(this.getStartQuote()) || schemaPart.contains(this.getEndQuote())) ? schemaTable + schemaPart : schemaTable + this.getStartQuote() + schemaPart + this.getEndQuote();
        schemaTable = schemaTable + ".";
        schemaTable = tablePart != null && (tablePart.contains(this.getStartQuote()) || tablePart.contains(this.getEndQuote())) ? schemaTable + tablePart : schemaTable + this.getStartQuote() + tablePart + this.getEndQuote();
        return schemaTable;
    }

    @Deprecated
    public String getBackwardsCompatibleTable(String tablePart) {
        if (tablePart != null && (tablePart.contains(this.getStartQuote()) || tablePart.contains(this.getEndQuote()))) {
            return tablePart;
        }
        return this.getStartQuote() + tablePart + this.getEndQuote();
    }

    @Override
    public int getMaxTextFieldLength() {
        return 9999999;
    }

    @Override
    public int getMaxVARCHARLength() {
        return 9999999;
    }

    @Override
    public boolean supportsTransactions() {
        return true;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsBitmapIndex() {
        return true;
    }

    @Override
    public boolean supportsSetLong() {
        return true;
    }

    @Override
    public String getDropColumnStatement(String tablename, ValueMetaInterface v, String tk, boolean use_autoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tablename + " DROP " + v.getName() + Const.CR;
    }

    @Override
    public String[] getReservedWords() {
        return new String[0];
    }

    @Override
    public boolean quoteReservedWords() {
        return true;
    }

    @Override
    public String getStartQuote() {
        return "\"";
    }

    @Override
    public String getEndQuote() {
        return "\"";
    }

    @Override
    public boolean supportsRepository() {
        return false;
    }

    @Override
    public String[] getTableTypes() {
        return new String[]{"TABLE"};
    }

    @Override
    public String[] getViewTypes() {
        return new String[]{"VIEW"};
    }

    @Override
    public String[] getSynonymTypes() {
        return new String[]{"SYNONYM"};
    }

    @Override
    public boolean useSchemaNameForTableList() {
        return false;
    }

    @Override
    public boolean supportsViews() {
        return true;
    }

    @Override
    public boolean supportsSynonyms() {
        return false;
    }

    @Override
    public String getSQLListOfProcedures() {
        return null;
    }

    @Override
    public String getSQLListOfSequences() {
        return null;
    }

    @Override
    public String getTruncateTableStatement(String tableName) {
        return "TRUNCATE TABLE " + tableName;
    }

    @Override
    public String getSQLQueryFields(String tableName) {
        return "SELECT * FROM " + tableName;
    }

    @Override
    public boolean supportsFloatRoundingOnUpdate() {
        return true;
    }

    @Override
    public String getSQLLockTables(String[] tableNames) {
        return null;
    }

    @Override
    public String getSQLUnlockTables(String[] tableNames) {
        return null;
    }

    @Override
    public boolean supportsTimeStampToDateConversion() {
        return true;
    }

    @Override
    public boolean supportsBatchUpdates() {
        return true;
    }

    @Override
    public boolean supportsBooleanDataType() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE, "N");
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setSupportsBooleanDataType(boolean b) {
        this.attributes.setProperty(ATTRIBUTE_SUPPORTS_BOOLEAN_DATA_TYPE, b ? "Y" : "N");
    }

    @Override
    public boolean supportsTimestampDataType() {
        String supportsTimestamp = this.attributes.getProperty(ATTRIBUTE_SUPPORTS_TIMESTAMP_DATA_TYPE, "N");
        return "Y".equalsIgnoreCase(supportsTimestamp);
    }

    @Override
    public void setSupportsTimestampDataType(boolean b) {
        this.attributes.setProperty(ATTRIBUTE_SUPPORTS_TIMESTAMP_DATA_TYPE, b ? "Y" : "N");
    }

    @Override
    public boolean preserveReservedCase() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_PRESERVE_RESERVED_WORD_CASE, "Y");
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setPreserveReservedCase(boolean b) {
        this.attributes.setProperty(ATTRIBUTE_PRESERVE_RESERVED_WORD_CASE, b ? "Y" : "N");
    }

    @Override
    public boolean isDefaultingToUppercase() {
        return true;
    }

    @Override
    public Map<String, String> getExtraOptions() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        Enumeration<Object> keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String attribute = (String)keys.nextElement();
            if (!attribute.startsWith(ATTRIBUTE_PREFIX_EXTRA_OPTION)) continue;
            String value = this.attributes.getProperty(attribute, "");
            map.put(attribute.substring(ATTRIBUTE_PREFIX_EXTRA_OPTION.length()), value);
        }
        return map;
    }

    @Override
    public void addExtraOption(String databaseTypeCode, String option, String value) {
        this.attributes.put(ATTRIBUTE_PREFIX_EXTRA_OPTION + databaseTypeCode + "." + option, value);
    }

    @Override
    public String getExtraOptionSeparator() {
        return ";";
    }

    @Override
    public String getExtraOptionValueSeparator() {
        return "=";
    }

    @Override
    public String getExtraOptionIndicator() {
        return ";";
    }

    @Override
    public boolean supportsOptionsInURL() {
        return true;
    }

    @Override
    public String getExtraOptionsHelpText() {
        return null;
    }

    @Override
    public boolean supportsGetBlob() {
        return true;
    }

    @Override
    public String getConnectSQL() {
        return this.attributes.getProperty(ATTRIBUTE_SQL_CONNECT);
    }

    @Override
    public void setConnectSQL(String sql) {
        this.attributes.setProperty(ATTRIBUTE_SQL_CONNECT, sql);
    }

    @Override
    public boolean supportsSetMaxRows() {
        return true;
    }

    @Override
    public boolean isUsingConnectionPool() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_USE_POOLING);
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setUsingConnectionPool(boolean usePool) {
        this.attributes.setProperty(ATTRIBUTE_USE_POOLING, usePool ? "Y" : "N");
    }

    @Override
    public int getMaximumPoolSize() {
        return Const.toInt(this.attributes.getProperty(ATTRIBUTE_MAXIMUM_POOL_SIZE), 10);
    }

    @Override
    public String getMaximumPoolSizeString() {
        return this.attributes.getProperty(ATTRIBUTE_MAXIMUM_POOL_SIZE);
    }

    @Override
    public void setMaximumPoolSize(int maximumPoolSize) {
        this.attributes.setProperty(ATTRIBUTE_MAXIMUM_POOL_SIZE, Integer.toString(maximumPoolSize));
    }

    @Override
    public void setMaximumPoolSizeString(String maximumPoolSize) {
        this.attributes.setProperty(ATTRIBUTE_MAXIMUM_POOL_SIZE, maximumPoolSize);
    }

    @Override
    public int getInitialPoolSize() {
        return Const.toInt(this.attributes.getProperty(ATTRIBUTE_INITIAL_POOL_SIZE), 5);
    }

    @Override
    public String getInitialPoolSizeString() {
        return this.attributes.getProperty(ATTRIBUTE_INITIAL_POOL_SIZE);
    }

    @Override
    public void setInitialPoolSize(int initialPoolSize) {
        this.attributes.setProperty(ATTRIBUTE_INITIAL_POOL_SIZE, Integer.toString(initialPoolSize));
    }

    @Override
    public void setInitialPoolSizeString(String initialPoolSize) {
        this.attributes.setProperty(ATTRIBUTE_INITIAL_POOL_SIZE, initialPoolSize);
    }

    @Override
    public boolean isPartitioned() {
        String isClustered = this.attributes.getProperty(ATTRIBUTE_IS_CLUSTERED);
        return "Y".equalsIgnoreCase(isClustered);
    }

    @Override
    public void setPartitioned(boolean clustered) {
        this.attributes.setProperty(ATTRIBUTE_IS_CLUSTERED, clustered ? "Y" : "N");
    }

    @Override
    public PartitionDatabaseMeta[] getPartitioningInformation() {
        int nr = 0;
        while (this.attributes.getProperty(ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX + nr) != null) {
            ++nr;
        }
        PartitionDatabaseMeta[] clusterInfo = new PartitionDatabaseMeta[nr];
        for (nr = 0; nr < clusterInfo.length; ++nr) {
            String partitionId = this.attributes.getProperty(ATTRIBUTE_CLUSTER_PARTITION_PREFIX + nr);
            String hostname = this.attributes.getProperty(ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX + nr);
            String port = this.attributes.getProperty(ATTRIBUTE_CLUSTER_PORT_PREFIX + nr);
            String dbName = this.attributes.getProperty(ATTRIBUTE_CLUSTER_DBNAME_PREFIX + nr);
            String username = this.attributes.getProperty(ATTRIBUTE_CLUSTER_USERNAME_PREFIX + nr);
            String password = this.attributes.getProperty(ATTRIBUTE_CLUSTER_PASSWORD_PREFIX + nr);
            clusterInfo[nr] = new PartitionDatabaseMeta(partitionId, hostname, port, dbName);
            clusterInfo[nr].setUsername(username);
            clusterInfo[nr].setPassword(Encr.decryptPasswordOptionallyEncrypted(password));
        }
        return clusterInfo;
    }

    @Override
    public void setPartitioningInformation(PartitionDatabaseMeta[] clusterInfo) {
        for (int nr = 0; nr < clusterInfo.length; ++nr) {
            PartitionDatabaseMeta meta = clusterInfo[nr];
            this.attributes.put(ATTRIBUTE_CLUSTER_PARTITION_PREFIX + nr, Const.NVL(meta.getPartitionId(), ""));
            this.attributes.put(ATTRIBUTE_CLUSTER_HOSTNAME_PREFIX + nr, Const.NVL(meta.getHostname(), ""));
            this.attributes.put(ATTRIBUTE_CLUSTER_PORT_PREFIX + nr, Const.NVL(meta.getPort(), ""));
            this.attributes.put(ATTRIBUTE_CLUSTER_DBNAME_PREFIX + nr, Const.NVL(meta.getDatabaseName(), ""));
            this.attributes.put(ATTRIBUTE_CLUSTER_USERNAME_PREFIX + nr, Const.NVL(meta.getUsername(), ""));
            this.attributes.put(ATTRIBUTE_CLUSTER_PASSWORD_PREFIX + nr, Const.NVL(Encr.encryptPasswordIfNotUsingVariables(meta.getPassword()), ""));
        }
    }

    @Override
    public Properties getConnectionPoolingProperties() {
        Properties properties = new Properties();
        for (String string : this.attributes.keySet()) {
            if (!string.startsWith(ATTRIBUTE_POOLING_PARAMETER_PREFIX)) continue;
            String key = string.substring(ATTRIBUTE_POOLING_PARAMETER_PREFIX.length());
            String value = this.attributes.getProperty(string);
            properties.put(key, value);
        }
        return properties;
    }

    @Override
    public void setConnectionPoolingProperties(Properties properties) {
        for (String string : this.attributes.keySet()) {
            if (!string.startsWith(ATTRIBUTE_POOLING_PARAMETER_PREFIX)) continue;
            this.attributes.remove(string);
        }
        for (String string : properties.keySet()) {
            String value = properties.getProperty(string);
            if (Utils.isEmpty(string) || Utils.isEmpty(value)) continue;
            this.attributes.put(ATTRIBUTE_POOLING_PARAMETER_PREFIX + string, value);
        }
    }

    @Override
    public String getSQLTableExists(String tablename) {
        return "SELECT 1 FROM " + tablename;
    }

    @Override
    public String getSQLColumnExists(String columnname, String tablename) {
        return "SELECT " + columnname + " FROM " + tablename;
    }

    @Override
    public boolean needsToLockAllTables() {
        return true;
    }

    @Override
    public boolean isStreamingResults() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_USE_RESULT_STREAMING, "Y");
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setStreamingResults(boolean useStreaming) {
        this.attributes.setProperty(ATTRIBUTE_USE_RESULT_STREAMING, useStreaming ? "Y" : "N");
    }

    @Override
    public boolean isQuoteAllFields() {
        String quoteAllFields = this.attributes.getProperty(ATTRIBUTE_QUOTE_ALL_FIELDS, "N");
        return "Y".equalsIgnoreCase(quoteAllFields);
    }

    @Override
    public void setQuoteAllFields(boolean quoteAllFields) {
        this.attributes.setProperty(ATTRIBUTE_QUOTE_ALL_FIELDS, quoteAllFields ? "Y" : "N");
    }

    @Override
    public boolean isForcingIdentifiersToLowerCase() {
        String forceLowerCase = this.attributes.getProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE, "N");
        return "Y".equalsIgnoreCase(forceLowerCase);
    }

    @Override
    public void setForcingIdentifiersToLowerCase(boolean forceLowerCase) {
        this.attributes.setProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_LOWERCASE, forceLowerCase ? "Y" : "N");
    }

    @Override
    public boolean isForcingIdentifiersToUpperCase() {
        String forceUpperCase = this.attributes.getProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE, "N");
        return "Y".equalsIgnoreCase(forceUpperCase);
    }

    @Override
    public void setForcingIdentifiersToUpperCase(boolean forceUpperCase) {
        this.attributes.setProperty(ATTRIBUTE_FORCE_IDENTIFIERS_TO_UPPERCASE, forceUpperCase ? "Y" : "N");
    }

    @Override
    public boolean isUsingDoubleDecimalAsSchemaTableSeparator() {
        String usePool = this.attributes.getProperty(ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR, "N");
        return "Y".equalsIgnoreCase(usePool);
    }

    @Override
    public void setUsingDoubleDecimalAsSchemaTableSeparator(boolean useDoubleDecimalSeparator) {
        this.attributes.setProperty(ATTRIBUTE_MSSQL_DOUBLE_DECIMAL_SEPARATOR, useDoubleDecimalSeparator ? "Y" : "N");
    }

    @Override
    public boolean isRequiringTransactionsOnQueries() {
        return true;
    }

    @Override
    public String getDatabaseFactoryName() {
        return DatabaseFactory.class.getName();
    }

    @Override
    public String getPreferredSchemaName() {
        return this.attributes.getProperty(ATTRIBUTE_PREFERRED_SCHEMA_NAME);
    }

    @Override
    public void setPreferredSchemaName(String preferredSchemaName) {
        this.attributes.setProperty(ATTRIBUTE_PREFERRED_SCHEMA_NAME, preferredSchemaName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkIndexExists(Database database, String schemaName, String tableName, String[] idx_fields) throws KettleDatabaseException {
        String tablename = database.getDatabaseMeta().getQuotedSchemaTableCombination(schemaName, tableName);
        boolean[] exists = new boolean[idx_fields.length];
        for (int i = 0; i < exists.length; ++i) {
            exists[i] = false;
        }
        try {
            try (ResultSet indexList = null;){
                indexList = database.getDatabaseMetaData().getIndexInfo(null, null, tablename, false, true);
                while (indexList.next()) {
                    String column = indexList.getString("COLUMN_NAME");
                    int idx = Const.indexOfString(column, idx_fields);
                    if (idx < 0) continue;
                    exists[idx] = true;
                }
            }
            boolean all = true;
            for (int i = 0; i < exists.length && all; ++i) {
                if (exists[i]) continue;
                all = false;
            }
            return all;
        }
        catch (Exception e) {
            throw new KettleDatabaseException("Unable to determine if indexes exists on table [" + tablename + "]", e);
        }
    }

    @Override
    public boolean supportsSequenceNoMaxValueOption() {
        return false;
    }

    @Override
    public boolean requiresCreateTablePrimaryKeyAppend() {
        return false;
    }

    @Override
    public boolean requiresCastToVariousForIsNull() {
        return false;
    }

    @Override
    public boolean isDisplaySizeTwiceThePrecision() {
        return false;
    }

    @Override
    public boolean supportsPreparedStatementMetadataRetrieval() {
        return true;
    }

    @Override
    public boolean supportsResultSetMetadataRetrievalOnly() {
        return false;
    }

    @Override
    public boolean isSystemTable(String tableName) {
        return false;
    }

    @Override
    public boolean supportsNewLinesInSQL() {
        return true;
    }

    @Override
    public String getSQLListOfSchemas() {
        return null;
    }

    @Override
    public int getMaxColumnsInIndex() {
        return 0;
    }

    @Override
    public boolean supportsErrorHandlingOnBatchUpdates() {
        return true;
    }

    @Override
    public String getSQLInsertAutoIncUnknownDimensionRow(String schemaTable, String keyField, String versionField) {
        return "insert into " + schemaTable + "(" + keyField + ", " + versionField + ") values (0, 1)";
    }

    @Override
    public boolean isExplorable() {
        return true;
    }

    @Override
    public String getXulOverlayFile() {
        return null;
    }

    @Override
    public String quoteSQLString(String string) {
        string = string.replaceAll("'", "''");
        string = string.replaceAll("\\n", "\\\\n");
        string = string.replaceAll("\\r", "\\\\r");
        return "'" + string + "'";
    }

    @Override
    public String getSelectCountStatement(String tableName) {
        return "select count(*) FROM " + tableName;
    }

    @Override
    public String generateColumnAlias(int columnIndex, String suggestedName) {
        return "COL" + Integer.toString(columnIndex);
    }

    @Override
    public List<String> parseStatements(String sqlScript) {
        List<SqlScriptStatement> scriptStatements = this.getSqlScriptStatements(sqlScript);
        ArrayList<String> statements = new ArrayList<String>();
        for (SqlScriptStatement scriptStatement : scriptStatements) {
            statements.add(scriptStatement.getStatement());
        }
        return statements;
    }

    @Override
    public List<SqlScriptStatement> getSqlScriptStatements(String sqlScript) {
        ArrayList<SqlScriptStatement> statements = new ArrayList<SqlScriptStatement>();
        String all = sqlScript;
        int from = 0;
        int to = 0;
        int length = all.length();
        while (to < length) {
            int nextBacktickIndex;
            int nextDQuoteIndex;
            char c = all.charAt(to);
            while (all.substring(from).startsWith("--")) {
                int nextLineIndex = all.indexOf(Const.CR, from);
                from = nextLineIndex + Const.CR.length();
                if (to >= length) break;
                c = all.charAt(c);
            }
            if (to >= length) break;
            if (c == '\"' && (nextDQuoteIndex = all.indexOf(34, to + 1)) >= 0) {
                to = nextDQuoteIndex + 1;
            }
            if (c == '`' && (nextBacktickIndex = all.indexOf(96, to + 1)) >= 0) {
                to = nextBacktickIndex + 1;
            }
            if ((c = all.charAt(to)) == '\'') {
                char prevChar;
                boolean skip = true;
                if (to > 0 && ((prevChar = all.charAt(to - 1)) == '\\' || prevChar == '\'')) {
                    skip = false;
                }
                while (skip) {
                    char prevChar2;
                    char nextChar;
                    int nextQuoteIndex = all.indexOf(39, to + 1);
                    if (nextQuoteIndex < 0) continue;
                    to = nextQuoteIndex + 1;
                    skip = false;
                    if (to < all.length() && (nextChar = all.charAt(to)) == '\'') {
                        skip = true;
                        ++to;
                    }
                    if (to <= 0 || (prevChar2 = all.charAt(to - 2)) != '\\') continue;
                    skip = true;
                    ++to;
                }
            }
            if ((c = all.charAt(to)) == ';' || to >= length - 1) {
                String stat;
                if (to >= length - 1) {
                    ++to;
                }
                if (!this.onlySpaces(stat = all.substring(from, to))) {
                    String s;
                    statements.add(new SqlScriptStatement(s, from, to, (s = Const.trim(stat)).toUpperCase().startsWith("SELECT") || s.toLowerCase().startsWith("show")));
                }
                from = ++to;
                continue;
            }
            ++to;
        }
        return statements;
    }

    protected boolean onlySpaces(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == ' ' || c == '\t' || c == '\n' || c == '\r') continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isMySQLVariant() {
        return false;
    }

    public boolean canTest() {
        return true;
    }

    public boolean requiresName() {
        return true;
    }

    @Override
    public boolean releaseSavepoint() {
        return this.releaseSavepoint;
    }

    public Long getNextBatchIdUsingSequence(String sequenceName, String schemaName, DatabaseMeta dbm, Database ldb) throws KettleDatabaseException {
        return ldb.getNextSequenceValue(schemaName, sequenceName, null);
    }

    public Long getNextBatchIdUsingAutoIncSQL(String autoIncSQL, DatabaseMeta dbm, Database ldb) throws KettleDatabaseException {
        Long rtn;
        block11: {
            rtn = null;
            PreparedStatement stmt = ldb.prepareSQL(autoIncSQL, true);
            try {
                stmt.executeUpdate();
                RowMetaAndData rmad = ldb.getGeneratedKeys(stmt);
                if (rmad.getRowMeta().size() > 0) {
                    rtn = rmad.getRowMeta().getInteger(rmad.getData(), 0);
                    break block11;
                }
                throw new KettleDatabaseException("Unable to retrieve value of auto-generated technical key : no value found!");
            }
            catch (KettleValueException kve) {
                throw new KettleDatabaseException(kve);
            }
            catch (SQLException sqlex) {
                throw new KettleDatabaseException(sqlex);
            }
            finally {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getNextBatchIdUsingLockTables(DatabaseMeta dbm, Database ldb, String schemaName, String tableName, String fieldName) throws KettleDatabaseException {
        String sql;
        Long rtn = null;
        String schemaAndTable = dbm.getQuotedSchemaTableCombination(schemaName, tableName);
        ldb.lockTables(new String[]{schemaAndTable});
        try {
            sql = "INSERT INTO " + schemaAndTable + " (" + dbm.quoteField(fieldName) + ") values (-1)";
            ldb.execStatement(sql);
            rtn = ldb.getNextValue(null, schemaName, tableName, fieldName);
            sql = "DELETE FROM " + schemaAndTable + " WHERE " + dbm.quoteField(fieldName) + "= -1";
        }
        catch (Throwable throwable) {
            String sql2 = "DELETE FROM " + schemaAndTable + " WHERE " + dbm.quoteField(fieldName) + "= -1";
            ldb.execStatement(sql2);
            ldb.unlockTables(new String[]{schemaAndTable});
            throw throwable;
        }
        ldb.execStatement(sql);
        ldb.unlockTables(new String[]{schemaAndTable});
        return rtn;
    }

    @Override
    public Long getNextBatchId(DatabaseMeta dbm, Database ldb, String schemaName, String tableName, String fieldName) throws KettleDatabaseException {
        ldb.setCommit(10);
        Map<String, String> connectionExtraOptions = this.getExtraOptions();
        String sequenceProp = this.getPluginId() + "." + SEQUENCE_FOR_BATCH_ID;
        String autoIncSQLProp = this.getPluginId() + "." + AUTOINCREMENT_SQL_FOR_BATCH_ID;
        if (connectionExtraOptions != null) {
            if (this.supportsSequences() && connectionExtraOptions.containsKey(sequenceProp)) {
                return this.getNextBatchIdUsingSequence(connectionExtraOptions.get(sequenceProp), schemaName, dbm, ldb);
            }
            if (this.supportsAutoInc() && connectionExtraOptions.containsKey(autoIncSQLProp)) {
                return this.getNextBatchIdUsingAutoIncSQL(connectionExtraOptions.get(autoIncSQLProp), dbm, ldb);
            }
        }
        return this.getNextBatchIdUsingLockTables(dbm, ldb, schemaName, tableName, fieldName);
    }

    @Override
    public String getDataTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta) {
        return this.getTablespaceDDL(variables, databaseMeta, databaseMeta.getDatabaseInterface().getDataTablespace());
    }

    @Override
    public String getIndexTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta) {
        return this.getTablespaceDDL(variables, databaseMeta, databaseMeta.getDatabaseInterface().getIndexTablespace());
    }

    public String getTablespaceDDL(VariableSpace variables, DatabaseMeta databaseMeta, String tablespaceName) {
        return "";
    }

    @Override
    public Object getValueFromResultSet(ResultSet rs, ValueMetaInterface val, int i) throws KettleDatabaseException {
        return val.getValueFromResultSet(this, rs, i);
    }

    @Override
    public boolean useSafePoints() {
        return false;
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }

    @Override
    public String getSQLValue(ValueMetaInterface valueMeta, Object valueData, String dateFormat) throws KettleValueException {
        StringBuilder ins = new StringBuilder();
        if (valueMeta.isNull(valueData)) {
            ins.append("null");
        } else {
            switch (valueMeta.getType()) {
                case 2: 
                case 4: {
                    String string = valueMeta.getString(valueData);
                    string = this.quoteSQLString(string);
                    ins.append(string);
                    break;
                }
                case 3: {
                    Date date = valueMeta.getDate(valueData);
                    if (Utils.isEmpty(dateFormat)) {
                        ins.append("'" + valueMeta.getString(valueData) + "'");
                        break;
                    }
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
                        ins.append("'" + formatter.format(date) + "'");
                        break;
                    }
                    catch (Exception e) {
                        throw new KettleValueException("Error : ", e);
                    }
                }
                default: {
                    ins.append(valueMeta.getString(valueData));
                }
            }
        }
        return ins.toString();
    }

    protected String getFieldnameProtector() {
        return FIELDNAME_PROTECTOR;
    }

    @Override
    public String getSafeFieldname(String fieldname) {
        StringBuilder newName = new StringBuilder(fieldname.length());
        char[] protectors = this.getFieldnameProtector().toCharArray();
        for (int idx = 0; idx < fieldname.length(); ++idx) {
            char c = fieldname.charAt(idx);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') {
                newName.append(c);
                continue;
            }
            if (c == ' ') {
                newName.append('_');
                continue;
            }
            for (char protector : protectors) {
                if (c != protector) continue;
                newName.append(c);
            }
        }
        fieldname = newName.toString();
        for (String reservedWord : this.getReservedWords()) {
            if (!fieldname.equalsIgnoreCase(reservedWord)) continue;
            fieldname = fieldname + this.getFieldnameProtector();
        }
        if ((fieldname = fieldname.replace(" ", this.getFieldnameProtector())).matches("^[0-9].*")) {
            fieldname = this.getFieldnameProtector() + fieldname;
        }
        return fieldname;
    }

    @Override
    public String getSequenceNoMaxValueOption() {
        return "NOMAXVALUE";
    }

    @Override
    public boolean supportsAutoGeneratedKeys() {
        return true;
    }

    @Override
    public ValueMetaInterface customizeValueFromSQLType(ValueMetaInterface v, ResultSetMetaData rm, int index) throws SQLException {
        return null;
    }

    @Override
    public String getCreateTableStatement() {
        return "CREATE TABLE ";
    }

    @Override
    public String getDropTableIfExistsStatement(String tableName) {
        return "DROP TABLE IF EXISTS " + tableName;
    }

    @Override
    public boolean fullExceptionLog(Exception e) {
        return true;
    }

    @Override
    public void addDefaultOptions() {
    }

    @Override
    public void addAttribute(String attributeId, String value) {
        this.attributes.setProperty(attributeId, value);
    }

    @Override
    public String getAttribute(String attributeId, String defaultValue) {
        return this.attributes.getProperty(attributeId, defaultValue);
    }
}

