/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.database;

import org.pentaho.di.core.database.PostgreSQLDatabaseMeta;
import org.pentaho.di.core.util.Utils;

public class RedshiftDatabaseMeta
extends PostgreSQLDatabaseMeta {
    public static final String IAM_ROLE = "iamRole";
    public static final String AWS_ACCESS_KEY_ID = "awsAccessKeyId";
    public static final String AWS_ACCESS_KEY = "awsAccessKey";
    public static final String AUTHENTICATION_METHOD = "awsAuthenticationMethod";

    public RedshiftDatabaseMeta() {
        this.addExtraOption("REDSHIFT", "tcpKeepAlive", "true");
        this.addExtraOption("REDSHIFT", "loginTimeout", "10");
    }

    @Override
    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 5439;
        }
        return -1;
    }

    @Override
    public String getDriverClass() {
        if (this.getAccessType() == 1) {
            return "sun.jdbc.odbc.JdbcOdbcDriver";
        }
        return "com.amazon.redshift.jdbc4.Driver";
    }

    @Override
    public String getURL(String hostname, String port, String databaseName) {
        if (this.getAccessType() == 1) {
            return "jdbc:odbc:" + databaseName;
        }
        return "jdbc:redshift://" + hostname + ":" + port + "/" + databaseName;
    }

    @Override
    public String getExtraOptionsHelpText() {
        return "http://docs.aws.amazon.com/redshift/latest/mgmt/configure-jdbc-connection.html";
    }

    @Override
    public boolean isFetchSizeSupported() {
        return false;
    }

    @Override
    public boolean supportsSetMaxRows() {
        return false;
    }

    @Override
    public String[] getUsedLibraries() {
        return new String[]{"RedshiftJDBC4_1.0.10.1010.jar"};
    }

    public String getIamRole() {
        return this.getParamIfSet(IAM_ROLE, this.getAttributes().getProperty(IAM_ROLE));
    }

    public String getAwsAccessKeyId() {
        return this.getParamIfSet(AWS_ACCESS_KEY_ID, this.getAttributes().getProperty(AWS_ACCESS_KEY_ID));
    }

    public String getAwsAccessKey() {
        return this.getParamIfSet(AWS_ACCESS_KEY, this.getAttributes().getProperty(AWS_ACCESS_KEY));
    }

    public String getAwsAuthenticationMethod() {
        return this.getParamIfSet(AUTHENTICATION_METHOD, this.getAttributes().getProperty(AUTHENTICATION_METHOD));
    }

    @Override
    public String getXulOverlayFile() {
        return "redshift";
    }

    private String getParamIfSet(String param, String val) {
        if (!Utils.isEmpty(val)) {
            return "&" + param + "=" + val;
        }
        return "";
    }
}

