/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager.oracle;

import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;

public final class OracleUtils {
    private static final String PERIOD_REGEX = "\\.";
    private static final String PERIOD_DELIMITER = ".";

    public static boolean isOracleEscapingDisabled(Configuration conf) {
        return conf.getBoolean("sqoop.oracle.escaping.disabled", true);
    }

    public static boolean isEscaped(String identifier) {
        return !StringUtils.isBlank((CharSequence)identifier) && identifier.startsWith("\"") && identifier.endsWith("\"");
    }

    public static String escapeIdentifier(String identifier) {
        return OracleUtils.escapeIdentifier(identifier, false);
    }

    public static String escapeIdentifier(String identifier, boolean escapingDisabled) {
        if (escapingDisabled || StringUtils.isBlank((CharSequence)identifier)) {
            return identifier;
        }
        if (OracleUtils.isEscaped(identifier)) {
            return identifier;
        }
        String[] parts = identifier.split(PERIOD_REGEX);
        StringBuilder escapedIdentifier = new StringBuilder();
        for (String part : parts) {
            if (StringUtils.isNotBlank((CharSequence)escapedIdentifier)) {
                escapedIdentifier.append(PERIOD_DELIMITER);
            }
            escapedIdentifier.append("\"").append(part).append("\"");
        }
        return StringUtils.isNotBlank((CharSequence)escapedIdentifier) ? escapedIdentifier.toString() : null;
    }

    public static String unescapeIdentifier(String identifier) {
        if (StringUtils.isBlank((CharSequence)identifier)) {
            return identifier;
        }
        if (OracleUtils.isEscaped(identifier)) {
            return identifier.substring(1, identifier.length() - 1);
        }
        return identifier;
    }
}

