/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.mapreduce;

import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.sqoop.SqoopJobDataPublisher;
import org.apache.sqoop.SqoopOptions;

public final class PublishJobData {
    public static final Log LOG = LogFactory.getLog((String)PublishJobData.class.getName());

    private PublishJobData() {
    }

    public static void publishJobData(Configuration conf, SqoopOptions options, String operation, String tableName, long startTime) {
        long endTime = new Date().getTime();
        String publishClassName = conf.get("sqoop.job.data.publish.class");
        if (!StringUtils.isEmpty((CharSequence)publishClassName)) {
            try {
                Class<?> publishClass = Class.forName(publishClassName);
                Object obj = publishClass.newInstance();
                if (obj instanceof SqoopJobDataPublisher) {
                    SqoopJobDataPublisher publisher = (SqoopJobDataPublisher)obj;
                    SqoopJobDataPublisher.Data data = new SqoopJobDataPublisher.Data(operation, options, tableName, startTime, endTime);
                    LOG.info((Object)("Published data is " + data.toString()));
                    publisher.publish(data);
                } else {
                    LOG.warn((Object)"Publisher class not an instance of SqoopJobDataPublisher. Ignoring...");
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Unable to publish " + operation + " data to publisher " + ex.getMessage()), (Throwable)ex);
            }
        }
    }
}

