/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerConfig;
import org.apache.kafka.clients.producer.ProducerConfig;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.config.ConfigDef;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.big.data.api.cluster.NamedClusterService;
import org.pentaho.big.data.api.cluster.service.locator.NamedClusterServiceLocator;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaConsumerInputMeta;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaFactory;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.osgi.metastore.locator.api.MetastoreLocator;

public class KafkaDialogHelper {
    private ComboVar wTopic;
    private ComboVar wClusterName;
    private Button wbCluster;
    private TextVar wBootstrapServers;
    private KafkaFactory kafkaFactory;
    private NamedClusterService namedClusterService;
    private MetastoreLocator metastoreLocator;
    private NamedClusterServiceLocator namedClusterServiceLocator;
    private TableView optionsTable;
    private StepMeta parentMeta;

    public KafkaDialogHelper(ComboVar wClusterName, ComboVar wTopic, Button wbCluster, TextVar wBootstrapServers, KafkaFactory kafkaFactory, NamedClusterService namedClusterService, NamedClusterServiceLocator namedClusterServiceLocator, MetastoreLocator metastoreLocator, TableView optionsTable, StepMeta parentMeta) {
        this.wClusterName = wClusterName;
        this.wTopic = wTopic;
        this.wbCluster = wbCluster;
        this.wBootstrapServers = wBootstrapServers;
        this.kafkaFactory = kafkaFactory;
        this.namedClusterService = namedClusterService;
        this.metastoreLocator = metastoreLocator;
        this.namedClusterServiceLocator = namedClusterServiceLocator;
        this.optionsTable = optionsTable;
        this.parentMeta = parentMeta;
    }

    public void clusterNameChanged(Event event) {
        if (this.wbCluster.getSelection() && StringUtil.isEmpty((String)this.wClusterName.getText()) || !this.wbCluster.getSelection() && StringUtil.isEmpty((String)this.wBootstrapServers.getText())) {
            return;
        }
        String current = this.wTopic.getText();
        String clusterName = this.wClusterName.getText();
        boolean isCluster = this.wbCluster.getSelection();
        String directBootstrapServers = this.wBootstrapServers == null ? "" : this.wBootstrapServers.getText();
        Map<String, String> config = KafkaDialogHelper.getConfig(this.optionsTable);
        if (!this.wTopic.getCComboWidget().isDisposed()) {
            this.wTopic.getCComboWidget().removeAll();
        }
        CompletableFuture.supplyAsync(() -> this.listTopics(clusterName, isCluster, directBootstrapServers, config)).thenAccept(topicMap -> Display.getDefault().syncExec(() -> this.populateTopics((Map<String, List<PartitionInfo>>)topicMap, current)));
    }

    private void populateTopics(Map<String, List<PartitionInfo>> topicMap, String current) {
        topicMap.keySet().stream().filter(key -> !"__consumer_offsets".equals(key)).sorted().forEach(key -> {
            if (!this.wTopic.isDisposed()) {
                this.wTopic.add(key);
            }
        });
        if (!this.wTopic.getCComboWidget().isDisposed()) {
            this.wTopic.getCComboWidget().setText(current);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, List<PartitionInfo>> listTopics(String clusterName, boolean isCluster, String directBootstrapServers, Map<String, String> config) {
        try (Consumer kafkaConsumer = null;){
            Map topicMap;
            KafkaConsumerInputMeta localMeta = new KafkaConsumerInputMeta();
            localMeta.setNamedClusterService(this.namedClusterService);
            localMeta.setNamedClusterServiceLocator(this.namedClusterServiceLocator);
            localMeta.setMetastoreLocator(this.metastoreLocator);
            localMeta.setConnectionType(isCluster ? KafkaConsumerInputMeta.ConnectionType.CLUSTER : KafkaConsumerInputMeta.ConnectionType.DIRECT);
            localMeta.setClusterName(clusterName);
            localMeta.setDirectBootstrapServers(directBootstrapServers);
            localMeta.setConfig(config);
            localMeta.setParentStepMeta(this.parentMeta);
            kafkaConsumer = this.kafkaFactory.consumer(localMeta, Function.identity());
            Map map = topicMap = kafkaConsumer.listTopics();
            return map;
        }
    }

    public static void populateFieldsList(TransMeta transMeta, ComboVar comboVar, String stepName) {
        String current = comboVar.getText();
        comboVar.getCComboWidget().removeAll();
        comboVar.setText(current);
        try {
            RowMetaInterface rmi = transMeta.getPrevStepFields(stepName);
            List ls = rmi.getValueMetaList();
            for (Object l : ls) {
                ValueMetaBase vmb = (ValueMetaBase)l;
                comboVar.add(vmb.getName());
            }
        }
        catch (KettleStepException kettleStepException) {
            // empty catch block
        }
    }

    public static List<String> getConsumerConfigOptionNames() {
        List<String> optionNames = KafkaDialogHelper.getConfigOptionNames(ConsumerConfig.class);
        Stream.of("bootstrap.servers", "group.id", "value.deserializer", "key.deserializer").forEach(optionNames::remove);
        return optionNames;
    }

    public static List<String> getProducerConfigOptionNames() {
        List<String> optionNames = KafkaDialogHelper.getConfigOptionNames(ProducerConfig.class);
        Stream.of("bootstrap.servers", "client.id", "value.serializer", "key.serializer").forEach(optionNames::remove);
        return optionNames;
    }

    public static List<String> getConsumerAdvancedConfigOptionNames() {
        return Arrays.asList("auto.offset.reset", "ssl.key.password", "ssl.keystore.location", "ssl.keystore.password", "ssl.truststore.location", "ssl.truststore.password");
    }

    public static List<String> getProducerAdvancedConfigOptionNames() {
        return Arrays.asList("compression.type", "ssl.key.password", "ssl.keystore.location", "ssl.keystore.password", "ssl.truststore.location", "ssl.truststore.password");
    }

    private static List<String> getConfigOptionNames(Class cl) {
        return KafkaDialogHelper.getStaticField(cl, "CONFIG").map(config -> ((ConfigDef)config).configKeys().keySet().stream().sorted().collect(Collectors.toList())).orElse(new ArrayList());
    }

    private static Optional<Object> getStaticField(Class cl, String fieldName) {
        try {
            Field field = cl.getDeclaredField(fieldName);
            field.setAccessible(true);
            return Optional.ofNullable(field.get(null));
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            return Optional.empty();
        }
    }

    public static Map<String, String> getConfig(TableView optionsTable) {
        int itemCount = optionsTable.getItemCount();
        LinkedHashMap<String, String> advancedConfig = new LinkedHashMap<String, String>();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = optionsTable.getTable().getItem(rowIndex);
            String config = row.getText(1);
            String value = row.getText(2);
            if (StringUtils.isBlank((String)config) || advancedConfig.containsKey(config)) continue;
            advancedConfig.put(config, value);
        }
        return advancedConfig;
    }
}

