/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.kettle.plugins.kafka;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaProducerOutputMeta;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaResourceInfo;
import org.pentaho.big.data.kettle.plugins.kafka.KafkaStepAnalyzer;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaNone;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.metaverse.api.IComponentDescriptor;
import org.pentaho.metaverse.api.IMetaverseNode;
import org.pentaho.metaverse.api.MetaverseComponentDescriptor;
import org.pentaho.metaverse.api.StepField;
import org.pentaho.metaverse.api.analyzer.kettle.ComponentDerivationRecord;
import org.pentaho.metaverse.api.analyzer.kettle.step.ConnectionExternalResourceStepAnalyzer;
import org.pentaho.metaverse.api.model.IExternalResourceInfo;

public class KafkaProducerStepAnalyzer
extends ConnectionExternalResourceStepAnalyzer<KafkaProducerOutputMeta> {
    public KafkaProducerStepAnalyzer() {
        KafkaStepAnalyzer.registerEntityTypes();
    }

    protected IMetaverseNode createTableNode(IExternalResourceInfo resource) {
        MetaverseComponentDescriptor topicDescriptor = new MetaverseComponentDescriptor(((KafkaResourceInfo)resource).getTopic(), "Kafka Topic", this.getConnectionNode(), this.getDescriptor().getContext());
        return this.createNodeFromDescriptor((IComponentDescriptor)topicDescriptor);
    }

    public IMetaverseNode getConnectionNode() {
        if (this.connectionNode == null) {
            MetaverseComponentDescriptor connectionDescriptor = new MetaverseComponentDescriptor(((KafkaProducerOutputMeta)this.baseStepMeta).getBootstrapServers(), "Kafka Server", this.getDescriptor().getNamespace(), this.getDescriptor().getContext());
            this.connectionNode = this.createNodeFromDescriptor((IComponentDescriptor)connectionDescriptor);
        }
        return this.connectionNode;
    }

    public Set<String> getOutputResourceFields(KafkaProducerOutputMeta meta) {
        LinkedHashSet<String> outputResourceFields = new LinkedHashSet<String>();
        if (meta.getKeyField() != null) {
            outputResourceFields.add("Key");
        }
        if (meta.getMessageField() != null) {
            outputResourceFields.add("Message");
        }
        return outputResourceFields;
    }

    protected Map<String, RowMetaInterface> getOutputRowMetaInterfaces(KafkaProducerOutputMeta meta) {
        Map outputRows = super.getOutputRowMetaInterfaces((BaseStepMeta)meta);
        RowMeta topicFields = new RowMeta();
        if (meta.getKeyField() != null) {
            topicFields.addValueMeta((ValueMetaInterface)new ValueMetaNone("Key"));
        }
        if (meta.getMessageField() != null) {
            topicFields.addValueMeta((ValueMetaInterface)new ValueMetaNone("Message"));
        }
        outputRows.put("_resource_", topicFields);
        return outputRows;
    }

    public Set<ComponentDerivationRecord> getChangeRecords(KafkaProducerOutputMeta meta) {
        LinkedHashSet<ComponentDerivationRecord> changes = new LinkedHashSet<ComponentDerivationRecord>();
        Set stepNames = this.getInputs().getStepNames();
        for (String stepName : stepNames) {
            changes.add(new ComponentDerivationRecord(new StepField(stepName, meta.getKeyField()), new StepField("_resource_", "Key")));
            changes.add(new ComponentDerivationRecord(new StepField(stepName, meta.getMessageField()), new StepField("_resource_", "Message")));
        }
        return changes;
    }

    public String getResourceInputNodeType() {
        return null;
    }

    public String getResourceOutputNodeType() {
        return null;
    }

    public boolean isOutput() {
        return true;
    }

    public boolean isInput() {
        return false;
    }

    protected Set<StepField> getUsedFields(KafkaProducerOutputMeta meta) {
        LinkedHashSet<StepField> usedFields = new LinkedHashSet<StepField>();
        Set stepNames = this.getInputs().getStepNames();
        for (String stepName : stepNames) {
            if (meta.getKeyField() != null) {
                usedFields.add(new StepField(stepName, meta.getKeyField()));
            }
            if (meta.getMessageField() == null) continue;
            usedFields.add(new StepField(stepName, meta.getMessageField()));
        }
        return usedFields;
    }

    public Set<Class<? extends BaseStepMeta>> getSupportedSteps() {
        return Collections.singleton(KafkaProducerOutputMeta.class);
    }
}

