/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.pdi;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.util.ThinModelConverter;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.api.data.DBDatasourceServiceException;
import org.pentaho.platform.api.data.IDBDatasourceService;

public class XmiToDatabaseMetaDatasourceService
implements IDBDatasourceService {
    public void clearCache() {
    }

    public void clearDataSource(String dsName) {
    }

    public String getDSBoundName(String dsName) throws DBDatasourceServiceException {
        return dsName;
    }

    public String getDSUnboundName(String dsName) {
        return dsName;
    }

    public DataSource getDataSource(String dsName) throws DBDatasourceServiceException {
        Domain domain = null;
        try {
            XmiParser parser = new XmiParser();
            File file = new File(dsName);
            InputStream inStream = file.exists() ? new FileInputStream(file) : new URL(dsName).openStream();
            domain = parser.parseXmi(inStream);
        }
        catch (Exception e) {
            throw new DBDatasourceServiceException((Throwable)e);
        }
        if (domain.getPhysicalModels().size() == 0 || !(domain.getPhysicalModels().get(0) instanceof SqlPhysicalModel)) {
            throw new DBDatasourceServiceException("No SQL Physical Model Available");
        }
        SqlPhysicalModel model = (SqlPhysicalModel)domain.getPhysicalModels().get(0);
        DatabaseMeta databaseMeta = ThinModelConverter.convertToLegacy((String)model.getId(), (SqlDataSource)model.getDatasource());
        return new DatabaseMetaDataSource(databaseMeta);
    }

    class DatabaseMetaDataSource
    implements DataSource {
        DatabaseMeta databaseMeta;

        public DatabaseMetaDataSource(DatabaseMeta databaseMeta) {
            this.databaseMeta = databaseMeta;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Database database = new Database(this.databaseMeta);
            try {
                database.connect();
            }
            catch (KettleException e) {
                e.printStackTrace();
                throw new SQLException(e.getMessage());
            }
            return database.getConnection();
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return null;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return null;
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return 0;
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) {
            return false;
        }

        @Override
        public <T> T unwrap(Class<T> iface) {
            return null;
        }

        @Override
        public Logger getParentLogger() {
            return null;
        }
    }
}

