/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import javax.persistence.EntityManager;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionSubsetGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ParamChecker;

public class WorkflowInfoWithActionsSubsetGetJPAExecutor
implements JPAExecutor<WorkflowJobBean> {
    private String wfJobId = null;
    private WorkflowJobBean workflow;
    private final int start;
    private final int len;

    public WorkflowInfoWithActionsSubsetGetJPAExecutor(String wfJobId, int start, int len) {
        ParamChecker.notNull(wfJobId, "wfJobId");
        this.wfJobId = wfJobId;
        this.start = start;
        this.len = len;
    }

    @Override
    public WorkflowJobBean execute(EntityManager em) throws JPAExecutorException {
        List<WorkflowActionBean> actionList;
        JPAService jpaService;
        try {
            jpaService = Services.get().get(JPAService.class);
            if (jpaService == null) {
                throw new JPAExecutorException(ErrorCode.E0610, this.wfJobId);
            }
            this.workflow = jpaService.execute(new WorkflowJobGetJPAExecutor(this.wfJobId));
        }
        catch (Exception ex) {
            if (ex instanceof JPAExecutorException) {
                throw (JPAExecutorException)ex;
            }
            throw new JPAExecutorException(ErrorCode.E0603, ex);
        }
        if (this.workflow != null) {
            jpaService = Services.get().get(JPAService.class);
            if (jpaService == null) {
                throw new JPAExecutorException(ErrorCode.E0610, this.wfJobId);
            }
            actionList = jpaService.execute(new WorkflowActionSubsetGetJPAExecutor(this.wfJobId, this.start, this.len));
        } else {
            throw new JPAExecutorException(ErrorCode.E0604, this.wfJobId);
        }
        this.workflow.setActions(actionList);
        return this.workflow;
    }

    @Override
    public String getName() {
        return "WorkflowInfoWithActionsSubsetGetJPAExecutor";
    }
}

