/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.ParamChecker;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeDef;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.xml.sax.SAXException;

public class LiteWorkflowAppParser {
    private static final String DECISION_E = "decision";
    private static final String ACTION_E = "action";
    private static final String END_E = "end";
    private static final String START_E = "start";
    private static final String JOIN_E = "join";
    private static final String FORK_E = "fork";
    private static final Object KILL_E = "kill";
    private static final String SLA_INFO = "info";
    private static final String CREDENTIALS = "credentials";
    private static final String NAME_A = "name";
    private static final String CRED_A = "cred";
    private static final String USER_RETRY_MAX_A = "retry-max";
    private static final String USER_RETRY_INTERVAL_A = "retry-interval";
    private static final String TO_A = "to";
    private static final String FORK_PATH_E = "path";
    private static final String FORK_START_A = "start";
    private static final String ACTION_OK_E = "ok";
    private static final String ACTION_ERROR_E = "error";
    private static final String DECISION_SWITCH_E = "switch";
    private static final String DECISION_CASE_E = "case";
    private static final String DECISION_DEFAULT_E = "default";
    private static final String KILL_MESSAGE_E = "message";
    private Schema schema;
    private Class<? extends DecisionNodeHandler> decisionHandlerClass;
    private Class<? extends ActionNodeHandler> actionHandlerClass;

    public LiteWorkflowAppParser(Schema schema, Class<? extends DecisionNodeHandler> decisionHandlerClass, Class<? extends ActionNodeHandler> actionHandlerClass) throws WorkflowException {
        this.schema = schema;
        this.decisionHandlerClass = decisionHandlerClass;
        this.actionHandlerClass = actionHandlerClass;
    }

    public LiteWorkflowApp validateAndParse(Reader reader) throws WorkflowException {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            String strDef = writer.toString();
            if (this.schema != null) {
                Validator validator = this.schema.newValidator();
                validator.validate(new StreamSource(new StringReader(strDef)));
            }
            Element wfDefElement = XmlUtils.parseXml(strDef);
            LiteWorkflowApp app = this.parse(strDef, wfDefElement);
            HashMap<String, VisitStatus> traversed = new HashMap<String, VisitStatus>();
            traversed.put(app.getNode("::start::").getName(), VisitStatus.VISITING);
            this.validate(app, app.getNode("::start::"), traversed);
            return app;
        }
        catch (JDOMException ex) {
            throw new WorkflowException(ErrorCode.E0700, new Object[]{ex.getMessage(), ex});
        }
        catch (SAXException ex) {
            throw new WorkflowException(ErrorCode.E0701, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0702, ex.getMessage(), ex);
        }
    }

    private LiteWorkflowApp parse(String strDef, Element root) throws WorkflowException {
        Namespace ns = root.getNamespace();
        LiteWorkflowApp def = null;
        for (Element eNode : root.getChildren()) {
            if (eNode.getName().equals("start")) {
                def = new LiteWorkflowApp(root.getAttributeValue(NAME_A), strDef, new StartNodeDef(eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(END_E)) {
                def.addNode(new EndNodeDef(eNode.getAttributeValue(NAME_A)));
                continue;
            }
            if (eNode.getName().equals(KILL_E)) {
                def.addNode(new KillNodeDef(eNode.getAttributeValue(NAME_A), eNode.getChildText(KILL_MESSAGE_E, ns)));
                continue;
            }
            if (eNode.getName().equals(FORK_E)) {
                ArrayList<String> paths = new ArrayList<String>();
                for (Element tran : eNode.getChildren(FORK_PATH_E, ns)) {
                    paths.add(tran.getAttributeValue("start"));
                }
                def.addNode(new ForkNodeDef(eNode.getAttributeValue(NAME_A), paths));
                continue;
            }
            if (eNode.getName().equals(JOIN_E)) {
                def.addNode(new JoinNodeDef(eNode.getAttributeValue(NAME_A), eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(DECISION_E)) {
                Element eSwitch = eNode.getChild(DECISION_SWITCH_E, ns);
                ArrayList<String> transitions = new ArrayList<String>();
                for (Element e : eSwitch.getChildren(DECISION_CASE_E, ns)) {
                    transitions.add(e.getAttributeValue(TO_A));
                }
                transitions.add(eSwitch.getChild(DECISION_DEFAULT_E, ns).getAttributeValue(TO_A));
                String switchStatement = XmlUtils.prettyPrint(eSwitch).toString();
                def.addNode(new DecisionNodeDef(eNode.getAttributeValue(NAME_A), switchStatement, this.decisionHandlerClass, (List<String>)transitions));
                continue;
            }
            if (ACTION_E.equals(eNode.getName())) {
                String[] transitions = new String[2];
                Element eActionConf = null;
                for (Element elem : eNode.getChildren()) {
                    if (ACTION_OK_E.equals(elem.getName())) {
                        transitions[0] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (ACTION_ERROR_E.equals(elem.getName())) {
                        transitions[1] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (SLA_INFO.equals(elem.getName()) || CREDENTIALS.equals(elem.getName())) continue;
                    eActionConf = elem;
                }
                String credStr = eNode.getAttributeValue(CRED_A);
                String userRetryMaxStr = eNode.getAttributeValue(USER_RETRY_MAX_A);
                String userRetryIntervalStr = eNode.getAttributeValue(USER_RETRY_INTERVAL_A);
                String actionConf = XmlUtils.prettyPrint(eActionConf).toString();
                def.addNode(new ActionNodeDef(eNode.getAttributeValue(NAME_A), actionConf, this.actionHandlerClass, transitions[0], transitions[1], credStr, userRetryMaxStr, userRetryIntervalStr));
                continue;
            }
            if (SLA_INFO.equals(eNode.getName()) || CREDENTIALS.equals(eNode.getName())) continue;
            throw new WorkflowException(ErrorCode.E0703, eNode.getName());
        }
        return def;
    }

    private void validate(LiteWorkflowApp app, NodeDef node, Map<String, VisitStatus> traversed) throws WorkflowException {
        if (!(node instanceof StartNodeDef)) {
            try {
                ParamChecker.validateActionName(node.getName());
            }
            catch (IllegalArgumentException ex) {
                throw new WorkflowException(ErrorCode.E0724, ex.getMessage());
            }
        }
        if (node instanceof ActionNodeDef) {
            try {
                boolean supportedAction;
                Element action = XmlUtils.parseXml(node.getConf());
                boolean bl = supportedAction = Services.get().get(ActionService.class).getExecutor(action.getName()) != null;
                if (!supportedAction) {
                    throw new WorkflowException(ErrorCode.E0723, node.getName(), action.getName());
                }
            }
            catch (JDOMException ex) {
                throw new RuntimeException("It should never happen, " + ex.getMessage(), ex);
            }
        }
        if (node instanceof EndNodeDef) {
            traversed.put(node.getName(), VisitStatus.VISITED);
            return;
        }
        if (node instanceof KillNodeDef) {
            traversed.put(node.getName(), VisitStatus.VISITED);
            return;
        }
        for (String transition : node.getTransitions()) {
            if (app.getNode(transition) == null) {
                throw new WorkflowException(ErrorCode.E0708, node.getName(), transition);
            }
            if (traversed.get(app.getNode(transition).getName()) == VisitStatus.VISITING) {
                throw new WorkflowException(ErrorCode.E0707, app.getNode(transition).getName());
            }
            if (traversed.get(app.getNode(transition).getName()) == VisitStatus.VISITED) continue;
            traversed.put(app.getNode(transition).getName(), VisitStatus.VISITING);
            this.validate(app, app.getNode(transition), traversed);
        }
        traversed.put(node.getName(), VisitStatus.VISITED);
    }

    private static enum VisitStatus {
        VISITING,
        VISITED;

    }
}

