/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.firebirdsql.encodings.EncodingFactory;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.gds.impl.GDSHelper;

public class FBParameterMetaData
implements ParameterMetaData {
    private final XSQLVAR[] xsqlvars;
    private final GDSHelper connection;

    protected FBParameterMetaData(XSQLVAR[] xsqlvars, GDSHelper connection) throws SQLException {
        this.xsqlvars = xsqlvars;
        this.connection = connection;
    }

    private String getIscEncoding() {
        if (this.connection != null) {
            return this.connection.getIscEncoding();
        }
        return "NONE";
    }

    public int getParameterCount() {
        return this.xsqlvars.length;
    }

    public int isNullable(int parameter) throws SQLException {
        if ((this.getXsqlvar((int)parameter).sqltype & 1) == 1) {
            return 1;
        }
        return 0;
    }

    public boolean isSigned(int parameter) throws SQLException {
        switch (this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE) {
            case 480: 
            case 482: 
            case 496: 
            case 500: 
            case 530: 
            case 580: {
                return true;
            }
        }
        return false;
    }

    public int getPrecision(int parameter) throws SQLException {
        int colType = this.getParameterType(parameter);
        switch (colType) {
            case 2: 
            case 3: {
                return this.estimatePrecision(parameter);
            }
            case 1: 
            case 12: {
                XSQLVAR var = this.getXsqlvar(parameter);
                int charset = var.sqlsubtype & 0xFF;
                int charSetSize = charset == 127 ? EncodingFactory.getIscEncodingSize(this.getIscEncoding()) : EncodingFactory.getCharacterSetSize(charset);
                return var.sqllen / charSetSize;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 5;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return 19;
            }
        }
        return 0;
    }

    public int getScale(int parameter) throws SQLException {
        return this.getXsqlvar((int)parameter).sqlscale * -1;
    }

    public int getParameterType(int parameter) throws SQLException {
        int sqltype = this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)parameter).sqlscale;
        int sqlsubtype = this.getXsqlvar((int)parameter).sqlsubtype;
        if (sqlscale < 0) {
            switch (sqltype) {
                case 480: 
                case 496: 
                case 500: 
                case 580: {
                    if (sqlsubtype == 2) {
                        return 3;
                    }
                    return 2;
                }
            }
        }
        switch (sqltype) {
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 480: 
            case 530: {
                return 8;
            }
            case 482: {
                return 6;
            }
            case 452: {
                return 1;
            }
            case 448: {
                return 12;
            }
            case 510: {
                return 93;
            }
            case 560: {
                return 92;
            }
            case 570: {
                return 91;
            }
            case 580: {
                if (sqlsubtype == 1) {
                    return 2;
                }
                if (sqlsubtype == 2) {
                    return 3;
                }
                return -5;
            }
            case 520: {
                if (sqlsubtype < 0) {
                    return 2004;
                }
                if (sqlsubtype == 0 || sqlsubtype > 1) {
                    return -4;
                }
                if (sqlsubtype == 1) {
                    return -1;
                }
                return 1111;
            }
            case 550: {
                return 1111;
            }
        }
        return 0;
    }

    public String getParameterTypeName(int parameter) throws SQLException {
        int sqltype = this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)parameter).sqlscale;
        int sqlsubtype = this.getXsqlvar((int)parameter).sqlsubtype;
        if (sqlscale < 0) {
            switch (sqltype) {
                case 480: 
                case 496: 
                case 500: 
                case 580: {
                    if (sqlsubtype == 2) {
                        return "DECIMAL";
                    }
                    return "NUMERIC";
                }
            }
        }
        switch (sqltype) {
            case 500: {
                return "SMALLINT";
            }
            case 496: {
                return "INTEGER";
            }
            case 480: 
            case 530: {
                return "DOUBLE PRECISION";
            }
            case 482: {
                return "FLOAT";
            }
            case 452: {
                return "CHAR";
            }
            case 448: {
                return "VARCHAR";
            }
            case 510: {
                return "TIMESTAMP";
            }
            case 560: {
                return "TIME";
            }
            case 570: {
                return "DATE";
            }
            case 580: {
                if (sqlsubtype == 1) {
                    return "NUMERIC";
                }
                if (sqlsubtype == 2) {
                    return "DECIMAL";
                }
                return "BIGINT";
            }
            case 520: {
                if (sqlsubtype < 0) {
                    return "BLOB SUB_TYPE " + sqlsubtype;
                }
                if (sqlsubtype == 0) {
                    return "BLOB SUB_TYPE 0";
                }
                if (sqlsubtype == 1) {
                    return "BLOB SUB_TYPE 1";
                }
                return "BLOB SUB_TYPE " + sqlsubtype;
            }
            case 550: {
                return "ARRAY";
            }
        }
        return "NULL";
    }

    public String getParameterClassName(int parameter) throws SQLException {
        switch (this.getXsqlvar((int)parameter).sqltype & 0xFFFFFFFE) {
            case 448: 
            case 452: {
                return String.class.getName();
            }
            case 496: 
            case 500: {
                return Integer.class.getName();
            }
            case 480: 
            case 482: 
            case 530: {
                return Double.class.getName();
            }
            case 510: {
                return Timestamp.class.getName();
            }
            case 520: {
                XSQLVAR field = this.getXsqlvar(parameter);
                if (field.sqlsubtype < 0) {
                    return Blob.class.getName();
                }
                if (field.sqlsubtype == 1) {
                    return String.class.getName();
                }
                return byte[].class.getName();
            }
            case 540: {
                return Array.class.getName();
            }
            case 550: {
                return Long.class.getName();
            }
            case 560: {
                return Time.class.getName();
            }
            case 570: {
                return Date.class.getName();
            }
            case 580: {
                if (this.getXsqlvar((int)parameter).sqlscale == 0) {
                    return Long.class.getName();
                }
                return BigDecimal.class.getName();
            }
        }
        throw new SQLException("Unkown SQL type", "HY105");
    }

    public int getParameterMode(int param) throws SQLException {
        return 1;
    }

    private XSQLVAR getXsqlvar(int parameterIndex) {
        return this.xsqlvars[parameterIndex - 1];
    }

    private int estimatePrecision(int parameterIndex) {
        int sqltype = this.getXsqlvar((int)parameterIndex).sqltype & 0xFFFFFFFE;
        int sqlscale = this.getXsqlvar((int)parameterIndex).sqlscale;
        switch (sqltype) {
            case 500: {
                return 5;
            }
            case 496: {
                return 10;
            }
            case 580: {
                return 19;
            }
            case 480: {
                return 19;
            }
        }
        return 0;
    }

    public boolean isWrapperFor(Class arg0) throws SQLException {
        throw new SQLException("not yet implemented");
    }

    public Object unwrap(Class arg0) throws SQLException {
        throw new SQLException("not yet implemented");
    }
}

