/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.io.CodecMap;

public class HiveClientCommon {
    public static final Log LOG = LogFactory.getLog((String)HiveClientCommon.class.getName());

    public void removeTempLogs(Configuration configuration, Path tablePath) throws IOException {
        Path logsPath;
        FileSystem fs = tablePath.getFileSystem(configuration);
        if (fs.exists(logsPath = new Path(tablePath, "_logs"))) {
            LOG.info((Object)("Removing temporary files from import process: " + logsPath));
            if (!fs.delete(logsPath, true)) {
                LOG.warn((Object)"Could not delete temporary files; continuing with import, but it may fail.");
            }
        }
    }

    public void cleanUp(Configuration configuration, Path outputPath) throws IOException {
        FileSystem fs = outputPath.getFileSystem(configuration);
        try {
            if (outputPath != null && fs.exists(outputPath)) {
                FileStatus[] statuses = fs.listStatus(outputPath);
                if (statuses.length == 0) {
                    LOG.info((Object)"Export directory is empty, removing it.");
                    fs.delete(outputPath, true);
                } else if (statuses.length == 1 && statuses[0].getPath().getName().equals("_SUCCESS")) {
                    LOG.info((Object)"Export directory is contains the _SUCCESS file only, removing the directory.");
                    fs.delete(outputPath, true);
                } else {
                    LOG.info((Object)"Export directory is not empty, keeping it.");
                }
            }
        }
        catch (IOException e) {
            LOG.error((Object)"Issue with cleaning (safe to ignore)", (Throwable)e);
        }
    }

    public void indexLzoFiles(SqoopOptions sqoopOptions, Path finalPath) throws IOException {
        String codec = sqoopOptions.getCompressionCodec();
        if (codec != null && (codec.equals("lzop") || codec.equals(CodecMap.getCodecClassName("lzop")))) {
            try {
                Tool tool = (Tool)ReflectionUtils.newInstance(Class.forName("com.hadoop.compression.lzo.DistributedLzoIndexer").asSubclass(Tool.class), (Configuration)sqoopOptions.getConf());
                ToolRunner.run((Configuration)sqoopOptions.getConf(), (Tool)tool, (String[])new String[]{finalPath.toString()});
            }
            catch (Exception ex) {
                LOG.error((Object)"Error indexing lzo files", (Throwable)ex);
                throw new IOException("Error indexing lzo files", ex);
            }
        }
    }
}

