/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import org.apache.commons.lang3.StringUtils;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.db.JdbcConnectionFactory;
import org.apache.sqoop.hive.HiveClient;
import org.apache.sqoop.hive.HiveImport;
import org.apache.sqoop.hive.HiveServer2Client;
import org.apache.sqoop.hive.HiveServer2ConnectionFactoryInitializer;
import org.apache.sqoop.hive.TableDefWriter;
import org.apache.sqoop.manager.ConnManager;

public class HiveClientFactory {
    private final HiveServer2ConnectionFactoryInitializer connectionFactoryInitializer;

    public HiveClientFactory(HiveServer2ConnectionFactoryInitializer connectionFactoryInitializer) {
        this.connectionFactoryInitializer = connectionFactoryInitializer;
    }

    public HiveClientFactory() {
        this(new HiveServer2ConnectionFactoryInitializer());
    }

    public HiveClient createHiveClient(SqoopOptions sqoopOptions, ConnManager connManager) {
        if (this.useHiveCli(sqoopOptions)) {
            return this.createHiveImport(sqoopOptions, connManager);
        }
        return this.createHiveServer2Client(sqoopOptions, connManager);
    }

    private HiveClient createHiveImport(SqoopOptions sqoopOptions, ConnManager connManager) {
        return new HiveImport(sqoopOptions, connManager, sqoopOptions.getConf(), false);
    }

    private HiveClient createHiveServer2Client(SqoopOptions sqoopOptions, ConnManager connManager) {
        TableDefWriter tableDefWriter = this.createTableDefWriter(sqoopOptions, connManager);
        JdbcConnectionFactory hs2JdbcConnectionFactory = this.connectionFactoryInitializer.createJdbcConnectionFactory(sqoopOptions);
        return new HiveServer2Client(sqoopOptions, tableDefWriter, hs2JdbcConnectionFactory);
    }

    TableDefWriter createTableDefWriter(SqoopOptions sqoopOptions, ConnManager connManager) {
        return new TableDefWriter(sqoopOptions, connManager, sqoopOptions.getTableName(), sqoopOptions.getHiveTableName(), sqoopOptions.getConf(), false);
    }

    private boolean useHiveCli(SqoopOptions sqoopOptions) {
        return StringUtils.isEmpty((CharSequence)sqoopOptions.getHs2Url());
    }
}

