/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.hive;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.authentication.KerberosAuthenticator;
import org.apache.sqoop.db.JdbcConnectionFactory;
import org.apache.sqoop.db.decorator.KerberizedConnectionFactoryDecorator;
import org.apache.sqoop.hive.HiveServer2ConnectionFactory;

public class HiveServer2ConnectionFactoryInitializer {
    public JdbcConnectionFactory createJdbcConnectionFactory(SqoopOptions sqoopOptions) {
        String connectionUsername = this.determineConnectionUsername(sqoopOptions);
        JdbcConnectionFactory connectionFactory = new HiveServer2ConnectionFactory(sqoopOptions.getHs2Url(), connectionUsername);
        if (this.useKerberizedConnection(sqoopOptions)) {
            KerberosAuthenticator authenticator = this.createKerberosAuthenticator(sqoopOptions);
            connectionFactory = new KerberizedConnectionFactoryDecorator(connectionFactory, authenticator);
        }
        return connectionFactory;
    }

    private String determineConnectionUsername(SqoopOptions sqoopOptions) {
        if (!StringUtils.isEmpty((CharSequence)sqoopOptions.getHs2User())) {
            return sqoopOptions.getHs2User();
        }
        try {
            return UserGroupInformation.getLoginUser().getUserName();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to determine login user.", e);
        }
    }

    private KerberosAuthenticator createKerberosAuthenticator(SqoopOptions sqoopOptions) {
        return new KerberosAuthenticator(sqoopOptions.getConf(), sqoopOptions.getHs2User(), sqoopOptions.getHs2Keytab());
    }

    private boolean useKerberizedConnection(SqoopOptions sqoopOptions) {
        return !StringUtils.isBlank((CharSequence)sqoopOptions.getHs2Keytab());
    }
}

