/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.GenericJdbcManager;
import org.apache.sqoop.util.LoggingUtils;

public abstract class CatalogQueryManager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)CatalogQueryManager.class.getName());

    public CatalogQueryManager(String driverClass, SqoopOptions opts) {
        super(driverClass, opts);
    }

    protected abstract String getListDatabasesQuery();

    @Override
    public String[] listDatabases() {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> databases = new ArrayList<String>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.getListDatabasesQuery());
            while (rs.next()) {
                databases.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ce);
            }
            LoggingUtils.logAll(LOG, "Failed to list databases", sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", se);
                }
            }
        }
        return databases.toArray(new String[databases.size()]);
    }

    protected abstract String getListTablesQuery();

    @Override
    public String[] listTables() {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> tables = new ArrayList<String>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(this.getListTablesQuery());
            while (rs.next()) {
                tables.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ce);
            }
            LoggingUtils.logAll(LOG, "Failed to list tables", sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", se);
                }
            }
        }
        return tables.toArray(new String[tables.size()]);
    }

    protected abstract String getListColumnsQuery(String var1);

    @Override
    public String[] getColumnNames(String tableName) {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> columns = new ArrayList<String>();
        String listColumnsQuery = this.getListColumnsQuery(tableName);
        try {
            c = this.getConnection();
            s = c.createStatement();
            rs = s.executeQuery(listColumnsQuery);
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ce);
            }
            LoggingUtils.logAll(LOG, "Failed to list columns from query: " + listColumnsQuery, sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", se);
                }
            }
        }
        return this.filterSpecifiedColumnNames(columns.toArray(new String[columns.size()]));
    }

    protected abstract String getPrimaryKeyQuery(String var1);

    @Override
    public String getPrimaryKey(String tableName) {
        Connection c = null;
        Statement s = null;
        ResultSet rs = null;
        ArrayList<String> columns = new ArrayList<String>();
        try {
            c = this.getConnection();
            s = c.createStatement();
            String primaryKeyQuery = this.getPrimaryKeyQuery(tableName);
            LOG.debug((Object)("Retrieving primary key for table '" + tableName + "' with query " + primaryKeyQuery));
            rs = s.executeQuery(primaryKeyQuery);
            while (rs.next()) {
                columns.add(rs.getString(1));
            }
            c.commit();
        }
        catch (SQLException sqle) {
            try {
                if (c != null) {
                    c.rollback();
                }
            }
            catch (SQLException ce) {
                LoggingUtils.logAll(LOG, "Failed to rollback transaction", ce);
            }
            LoggingUtils.logAll(LOG, "Failed to list primary key", sqle);
            throw new RuntimeException(sqle);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException re) {
                    LoggingUtils.logAll(LOG, "Failed to close resultset", re);
                }
            }
            if (s != null) {
                try {
                    s.close();
                }
                catch (SQLException se) {
                    LoggingUtils.logAll(LOG, "Failed to close statement", se);
                }
            }
        }
        if (columns.size() == 0) {
            return null;
        }
        if (columns.size() > 1) {
            LOG.warn((Object)("The table " + tableName + " contains a multi-column primary key. Sqoop will default to the column " + (String)columns.get(0) + " only for this job."));
        }
        return (String)columns.get(0);
    }
}

