/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import java.io.IOException;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.CatalogQueryManager;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.manager.ImportJobContext;
import org.apache.sqoop.manager.JdbcDrivers;
import org.apache.sqoop.mapreduce.ExportBatchOutputFormat;
import org.apache.sqoop.mapreduce.JdbcExportJob;
import org.apache.sqoop.mapreduce.JdbcUpsertExportJob;
import org.apache.sqoop.mapreduce.cubrid.CubridUpsertOutputFormat;
import org.apache.sqoop.util.ExportException;
import org.apache.sqoop.util.ImportException;

public class CubridManager
extends CatalogQueryManager {
    public static final Log LOG = LogFactory.getLog((String)CubridManager.class.getName());
    private Map<String, String> colTypeNames;
    private static final int YEAR_TYPE_OVERWRITE = 5;

    public CubridManager(SqoopOptions opts) {
        super(JdbcDrivers.CUBRID.getDriverClass(), opts);
    }

    @Override
    public void importTable(ImportJobContext context) throws IOException, ImportException {
        super.importTable(context);
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcExportJob exportJob = new JdbcExportJob(context, null, null, ExportBatchOutputFormat.class, this.getParquetJobConfigurator().createParquetExportJobConfigurator());
        exportJob.runExport();
    }

    @Override
    public void upsertTable(ExportJobContext context) throws IOException, ExportException {
        context.setConnManager(this);
        JdbcUpsertExportJob exportJob = new JdbcUpsertExportJob(context, CubridUpsertOutputFormat.class, this.getParquetJobConfigurator().createParquetExportJobConfigurator());
        exportJob.runExport();
    }

    @Override
    public void configureDbOutputColumns(SqoopOptions options) {
        if (options.getUpdateMode() == SqoopOptions.UpdateMode.AllowInsert) {
            return;
        }
        super.configureDbOutputColumns(options);
    }

    @Override
    public String getColNamesQuery(String tableName) {
        return "SELECT t.* FROM " + this.escapeTableName(tableName) + " AS t LIMIT 1";
    }

    @Override
    public String getInputBoundsQuery(String splitByCol, String sanitizedQuery) {
        return "SELECT MIN(" + splitByCol + "), MAX(" + splitByCol + ") FROM (" + sanitizedQuery + ") t1";
    }

    private int overrideSqlType(String tableName, String columnName, int sqlType) {
        if (this.colTypeNames == null) {
            this.colTypeNames = this.getColumnTypeNames(tableName, this.options.getCall(), this.options.getSqlQuery());
        }
        if ("YEAR".equalsIgnoreCase(this.colTypeNames.get(columnName))) {
            sqlType = 5;
        }
        return sqlType;
    }

    @Override
    public String toJavaType(String tableName, String columnName, int sqlType) {
        sqlType = this.overrideSqlType(tableName, columnName, sqlType);
        String javaType = super.toJavaType(tableName, columnName, sqlType);
        return javaType;
    }

    @Override
    public String toHiveType(String tableName, String columnName, int sqlType) {
        sqlType = this.overrideSqlType(tableName, columnName, sqlType);
        return super.toHiveType(tableName, columnName, sqlType);
    }

    @Override
    public Schema.Type toAvroType(String tableName, String columnName, int sqlType) {
        sqlType = this.overrideSqlType(tableName, columnName, sqlType);
        return super.toAvroType(tableName, columnName, sqlType);
    }

    @Override
    protected String getListDatabasesQuery() {
        return null;
    }

    @Override
    protected String getListTablesQuery() {
        return "SELECT CLASS_NAME FROM DB_CLASS WHERE IS_SYSTEM_CLASS = 'NO'";
    }

    @Override
    protected String getListColumnsQuery(String tableName) {
        tableName = tableName.toLowerCase();
        return "SELECT ATTR_NAME FROM DB_ATTRIBUTE WHERE CLASS_NAME = '" + tableName + "'  ORDER BY def_order";
    }

    @Override
    protected String getPrimaryKeyQuery(String tableName) {
        tableName = tableName.toLowerCase();
        return "SELECT KEY_ATTR_NAME FROM DB_INDEX_KEY WHERE CLASS_NAME = '" + tableName + "' ";
    }
}

