/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.ConnManager;
import org.apache.sqoop.manager.CubridManager;
import org.apache.sqoop.manager.Db2Manager;
import org.apache.sqoop.manager.DirectMySQLManager;
import org.apache.sqoop.manager.DirectNetezzaManager;
import org.apache.sqoop.manager.DirectPostgresqlManager;
import org.apache.sqoop.manager.HsqldbManager;
import org.apache.sqoop.manager.ManagerFactory;
import org.apache.sqoop.manager.MySQLManager;
import org.apache.sqoop.manager.NetezzaManager;
import org.apache.sqoop.manager.OracleManager;
import org.apache.sqoop.manager.PostgresqlManager;
import org.apache.sqoop.manager.SQLServerManager;
import org.apache.sqoop.manager.SupportedManagers;
import org.apache.sqoop.metastore.JobData;

public class DefaultManagerFactory
extends ManagerFactory {
    public static final Log LOG = LogFactory.getLog((String)DefaultManagerFactory.class.getName());
    public static final String NET_SOURCEFORGE_JTDS_JDBC_DRIVER = "net.sourceforge.jtds.jdbc.Driver";

    @Override
    public ConnManager accept(JobData data) {
        SqoopOptions options = data.getSqoopOptions();
        String scheme = this.extractScheme(options);
        if (null == scheme) {
            LOG.warn((Object)"Null scheme associated with connect string.");
            return null;
        }
        LOG.debug((Object)("Trying with scheme: " + scheme));
        if (SupportedManagers.MYSQL.isTheManagerTypeOf(options)) {
            if (options.isDirect()) {
                return new DirectMySQLManager(options);
            }
            return new MySQLManager(options);
        }
        if (SupportedManagers.POSTGRES.isTheManagerTypeOf(options)) {
            if (options.isDirect()) {
                return new DirectPostgresqlManager(options);
            }
            return new PostgresqlManager(options);
        }
        if (SupportedManagers.HSQLDB.isTheManagerTypeOf(options)) {
            return new HsqldbManager(options);
        }
        if (SupportedManagers.ORACLE.isTheManagerTypeOf(options)) {
            return new OracleManager(options);
        }
        if (SupportedManagers.SQLSERVER.isTheManagerTypeOf(options)) {
            return new SQLServerManager(options);
        }
        if (SupportedManagers.JTDS_SQLSERVER.isTheManagerTypeOf(options)) {
            return new SQLServerManager(NET_SOURCEFORGE_JTDS_JDBC_DRIVER, options);
        }
        if (SupportedManagers.DB2.isTheManagerTypeOf(options)) {
            return new Db2Manager(options);
        }
        if (SupportedManagers.NETEZZA.isTheManagerTypeOf(options)) {
            if (options.isDirect()) {
                return new DirectNetezzaManager(options);
            }
            return new NetezzaManager(options);
        }
        if (SupportedManagers.CUBRID.isTheManagerTypeOf(options)) {
            return new CubridManager(options);
        }
        return null;
    }

    protected String extractScheme(SqoopOptions options) {
        return SupportedManagers.extractScheme(options);
    }
}

