/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.ExportJobContext;
import org.apache.sqoop.manager.GenericJdbcManager;
import org.apache.sqoop.manager.JdbcDrivers;
import org.apache.sqoop.util.ExportException;

public class HsqldbManager
extends GenericJdbcManager {
    public static final Log LOG = LogFactory.getLog((String)HsqldbManager.class.getName());
    private static final String HSQL_SCHEMA_NAME = "PUBLIC";

    public HsqldbManager(SqoopOptions opts) {
        super(JdbcDrivers.HSQLDB.getDriverClass(), opts);
    }

    @Override
    public String[] listDatabases() {
        String[] databases = new String[]{HSQL_SCHEMA_NAME};
        return databases;
    }

    @Override
    public String escapeTableName(String tableName) {
        return '\"' + tableName + '\"';
    }

    @Override
    public String escapeColName(String colName) {
        return '\"' + colName + '\"';
    }

    @Override
    protected String getCurTimestampQuery() {
        return "SELECT CURRENT_TIMESTAMP FROM INFORMATION_SCHEMA.SYSTEM_TABLES";
    }

    @Override
    public boolean supportsStagingForExport() {
        return true;
    }

    @Override
    public void exportTable(ExportJobContext context) throws IOException, ExportException {
        context.getOptions().getConf().setInt("sqoop.export.records.per.statement", 1);
        super.exportTable(context);
    }
}

