/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.manager;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sqoop.SqoopOptions;
import org.apache.sqoop.manager.JdbcDrivers;

public enum SupportedManagers {
    MYSQL(JdbcDrivers.MYSQL.getSchemePrefix(), true),
    POSTGRES(JdbcDrivers.POSTGRES.getSchemePrefix(), true),
    HSQLDB(JdbcDrivers.HSQLDB.getSchemePrefix(), false),
    ORACLE(JdbcDrivers.ORACLE.getSchemePrefix(), true),
    SQLSERVER(JdbcDrivers.SQLSERVER.getSchemePrefix(), false),
    CUBRID(JdbcDrivers.CUBRID.getSchemePrefix(), false),
    JTDS_SQLSERVER(JdbcDrivers.JTDS_SQLSERVER.getSchemePrefix(), false),
    DB2(JdbcDrivers.DB2.getSchemePrefix(), false),
    NETEZZA(JdbcDrivers.NETEZZA.getSchemePrefix(), true);

    private final String schemePrefix;
    private final boolean hasDirectConnector;
    private static final Log LOG;

    private SupportedManagers(String schemePrefix, boolean hasDirectConnector) {
        this.schemePrefix = schemePrefix;
        this.hasDirectConnector = hasDirectConnector;
    }

    public String getSchemePrefix() {
        return this.schemePrefix;
    }

    public boolean hasDirectConnector() {
        return this.hasDirectConnector;
    }

    public boolean isTheManagerTypeOf(SqoopOptions options) {
        return SupportedManagers.extractScheme(options).startsWith(this.getSchemePrefix());
    }

    public static SupportedManagers createFrom(SqoopOptions options) {
        String scheme = SupportedManagers.extractScheme(options);
        for (SupportedManagers m : SupportedManagers.values()) {
            if (!scheme.startsWith(m.getSchemePrefix())) continue;
            return m;
        }
        return null;
    }

    static String extractScheme(SqoopOptions options) {
        String connectStr = options.getConnectString();
        int schemeStopIdx = connectStr.indexOf("//");
        if (-1 == schemeStopIdx && -1 == (schemeStopIdx = connectStr.lastIndexOf(58))) {
            LOG.warn((Object)"Could not determine scheme component of connect string");
            schemeStopIdx = connectStr.length();
        }
        return connectStr.substring(0, schemeStopIdx);
    }

    static {
        LOG = LogFactory.getLog(SupportedManagers.class);
    }
}

